/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.graphql.GraphQLConversionUtils;
import com.yahoo.elide.graphql.GraphQLScalars;
import com.yahoo.elide.graphql.MutableGraphQLInputObjectType;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.RelationshipOp;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelBuilder {
    private static final Logger log = LoggerFactory.getLogger(ModelBuilder.class);
    public static final String ARGUMENT_DATA = "data";
    public static final String ARGUMENT_INPUT = "Input";
    public static final String ARGUMENT_IDS = "ids";
    public static final String ARGUMENT_FILTER = "filter";
    public static final String ARGUMENT_SORT = "sort";
    public static final String ARGUMENT_FIRST = "first";
    public static final String ARGUMENT_AFTER = "after";
    public static final String ARGUMENT_OPERATION = "op";
    private EntityDictionary entityDictionary;
    private DataFetcher dataFetcher;
    private GraphQLArgument relationshipOpArg;
    private GraphQLArgument idArgument;
    private GraphQLArgument filterArgument;
    private GraphQLArgument pageOffsetArgument;
    private GraphQLArgument pageFirstArgument;
    private GraphQLArgument sortArgument;
    private GraphQLConversionUtils generator;
    private GraphQLObjectType pageInfoObject;
    private Map<Class<?>, MutableGraphQLInputObjectType> inputObjectRegistry;
    private Map<Class<?>, GraphQLObjectType> queryObjectRegistry;
    private Map<Class<?>, GraphQLObjectType> connectionObjectRegistry;
    private Set<Class<?>> excludedEntities;
    private HashMap<String, GraphQLInputType> convertedInputs = new HashMap();

    public ModelBuilder(EntityDictionary entityDictionary, NonEntityDictionary nonEntityDictionary, DataFetcher dataFetcher) {
        this.generator = new GraphQLConversionUtils(entityDictionary, nonEntityDictionary);
        this.entityDictionary = entityDictionary;
        this.dataFetcher = dataFetcher;
        this.relationshipOpArg = GraphQLArgument.newArgument().name(ARGUMENT_OPERATION).type((GraphQLInputType)this.generator.classToEnumType(RelationshipOp.class)).defaultValue((Object)RelationshipOp.FETCH).build();
        this.idArgument = GraphQLArgument.newArgument().name(ARGUMENT_IDS).type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build();
        this.filterArgument = GraphQLArgument.newArgument().name(ARGUMENT_FILTER).type((GraphQLInputType)Scalars.GraphQLString).build();
        this.sortArgument = GraphQLArgument.newArgument().name(ARGUMENT_SORT).type((GraphQLInputType)Scalars.GraphQLString).build();
        this.pageFirstArgument = GraphQLArgument.newArgument().name(ARGUMENT_FIRST).type((GraphQLInputType)Scalars.GraphQLString).build();
        this.pageOffsetArgument = GraphQLArgument.newArgument().name(ARGUMENT_AFTER).type((GraphQLInputType)Scalars.GraphQLString).build();
        this.pageInfoObject = GraphQLObjectType.newObject().name("_pageInfoObject").field(GraphQLFieldDefinition.newFieldDefinition().name("hasNextPage").dataFetcher(dataFetcher).type((GraphQLOutputType)Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("startCursor").dataFetcher(dataFetcher).type((GraphQLOutputType)Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("endCursor").dataFetcher(dataFetcher).type((GraphQLOutputType)Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("totalRecords").dataFetcher(dataFetcher).type((GraphQLOutputType)Scalars.GraphQLLong)).build();
        this.inputObjectRegistry = new HashMap();
        this.queryObjectRegistry = new HashMap();
        this.connectionObjectRegistry = new HashMap();
        this.excludedEntities = new HashSet();
    }

    public void withExcludedEntities(Set<Class<?>> excludedEntities) {
        this.excludedEntities = excludedEntities;
    }

    public GraphQLSchema build() {
        Set allClasses = this.entityDictionary.getBindings();
        if (allClasses.isEmpty()) {
            throw new IllegalArgumentException("None of the provided classes are exported by Elide");
        }
        Set rootClasses = allClasses.stream().filter(arg_0 -> ((EntityDictionary)this.entityDictionary).isRoot(arg_0)).collect(Collectors.toSet());
        this.entityDictionary.walkEntityGraph(rootClasses, this::buildInputObjectStub);
        this.resolveInputObjectRelationships();
        GraphQLObjectType.Builder root = GraphQLObjectType.newObject().name("_root");
        for (Class clazz : rootClasses) {
            String entityName = this.entityDictionary.getJsonAliasFor(clazz);
            root.field(GraphQLFieldDefinition.newFieldDefinition().name(entityName).dataFetcher(this.dataFetcher).argument(this.relationshipOpArg).argument(this.idArgument).argument(this.filterArgument).argument(this.sortArgument).argument(this.pageFirstArgument).argument(this.pageOffsetArgument).argument(this.buildInputObjectArgument(clazz, true)).type((GraphQLOutputType)this.buildConnectionObject(clazz)));
        }
        GraphQLObjectType queryRoot = root.build();
        GraphQLObjectType mutationRoot = root.name("_mutation_root").build();
        this.entityDictionary.walkEntityGraph(rootClasses, this::buildConnectionObject);
        GraphQLSchema schema = GraphQLSchema.newSchema().query(queryRoot).mutation(mutationRoot).build(new HashSet(CollectionUtils.union(this.connectionObjectRegistry.values(), this.inputObjectRegistry.values())));
        return schema;
    }

    private GraphQLObjectType buildConnectionObject(Class<?> entityClass) {
        if (this.connectionObjectRegistry.containsKey(entityClass)) {
            return this.connectionObjectRegistry.get(entityClass);
        }
        String entityName = this.entityDictionary.getJsonAliasFor(entityClass);
        GraphQLObjectType connectionObject = GraphQLObjectType.newObject().name(entityName).field(GraphQLFieldDefinition.newFieldDefinition().name("edges").dataFetcher(this.dataFetcher).type((GraphQLOutputType)this.buildEdgesObject(entityName, (GraphQLOutputType)this.buildQueryObject(entityClass)))).field(GraphQLFieldDefinition.newFieldDefinition().name("pageInfo").dataFetcher(this.dataFetcher).type((GraphQLOutputType)this.pageInfoObject)).build();
        this.connectionObjectRegistry.put(entityClass, connectionObject);
        return connectionObject;
    }

    private GraphQLObjectType buildQueryObject(Class<?> entityClass) {
        if (this.queryObjectRegistry.containsKey(entityClass)) {
            return this.queryObjectRegistry.get(entityClass);
        }
        log.debug("Building query object for {}", (Object)entityClass.getName());
        String entityName = this.entityDictionary.getJsonAliasFor(entityClass);
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("_node__" + entityName);
        String id = this.entityDictionary.getIdFieldName(entityClass);
        builder.field(GraphQLFieldDefinition.newFieldDefinition().name(id).dataFetcher(this.dataFetcher).type((GraphQLOutputType)GraphQLScalars.GRAPHQL_DEFERRED_ID));
        for (String attribute : this.entityDictionary.getAttributes(entityClass)) {
            Class attributeClass = this.entityDictionary.getType(entityClass, attribute);
            if (this.excludedEntities.contains(attributeClass)) continue;
            log.debug("Building query attribute {} {} for entity {}", new Object[]{attribute, attributeClass.getName(), entityClass.getName()});
            GraphQLOutputType attributeType = this.generator.attributeToQueryObject(entityClass, attributeClass, attribute, this.dataFetcher);
            if (attributeType == null) continue;
            builder.field(GraphQLFieldDefinition.newFieldDefinition().name(attribute).dataFetcher(this.dataFetcher).type(attributeType));
        }
        for (String relationship : this.entityDictionary.getElideBoundRelationships(entityClass)) {
            Class relationshipClass = this.entityDictionary.getParameterizedType(entityClass, relationship);
            if (this.excludedEntities.contains(relationshipClass)) continue;
            String relationshipEntityName = this.entityDictionary.getJsonAliasFor(relationshipClass);
            RelationshipType type = this.entityDictionary.getRelationshipType(entityClass, relationship);
            if (type.isToOne()) {
                builder.field(GraphQLFieldDefinition.newFieldDefinition().name(relationship).dataFetcher(this.dataFetcher).argument(this.relationshipOpArg).argument(this.buildInputObjectArgument(relationshipClass, false)).type((GraphQLOutputType)new GraphQLTypeReference(relationshipEntityName)));
                continue;
            }
            builder.field(GraphQLFieldDefinition.newFieldDefinition().name(relationship).dataFetcher(this.dataFetcher).argument(this.relationshipOpArg).argument(this.filterArgument).argument(this.sortArgument).argument(this.pageOffsetArgument).argument(this.pageFirstArgument).argument(this.idArgument).argument(this.buildInputObjectArgument(relationshipClass, true)).type((GraphQLOutputType)new GraphQLTypeReference(relationshipEntityName)));
        }
        GraphQLObjectType queryObject = builder.build();
        this.queryObjectRegistry.put(entityClass, queryObject);
        return queryObject;
    }

    private GraphQLList buildEdgesObject(String relationName, GraphQLOutputType entityType) {
        return new GraphQLList((GraphQLType)GraphQLObjectType.newObject().name("_edges__" + relationName).field(GraphQLFieldDefinition.newFieldDefinition().name("node").dataFetcher(this.dataFetcher).type(entityType)).build());
    }

    private GraphQLArgument buildInputObjectArgument(Class<?> entityClass, boolean asList) {
        GraphQLInputType argumentType = (GraphQLInputType)this.inputObjectRegistry.get(entityClass);
        if (asList) {
            return GraphQLArgument.newArgument().name(ARGUMENT_DATA).type((GraphQLInputType)new GraphQLList((GraphQLType)argumentType)).build();
        }
        return GraphQLArgument.newArgument().name(ARGUMENT_DATA).type(argumentType).build();
    }

    private GraphQLInputType buildInputObjectStub(Class<?> clazz) {
        log.debug("Building input object for {}", (Object)clazz.getName());
        String entityName = this.entityDictionary.getJsonAliasFor(clazz);
        MutableGraphQLInputObjectType.Builder builder = MutableGraphQLInputObjectType.newMutableInputObject();
        builder.name(entityName + ARGUMENT_INPUT);
        String id = this.entityDictionary.getIdFieldName(clazz);
        builder.field(GraphQLInputObjectField.newInputObjectField().name(id).type((GraphQLInputType)Scalars.GraphQLID));
        for (String attribute : this.entityDictionary.getAttributes(clazz)) {
            Class attributeClass = this.entityDictionary.getType(clazz, attribute);
            if (this.excludedEntities.contains(attributeClass)) continue;
            log.debug("Building input attribute {} {} for entity {}", new Object[]{attribute, attributeClass.getName(), clazz.getName()});
            Object attributeType = this.generator.attributeToInputObject(clazz, attributeClass, attribute);
            if (attributeType instanceof GraphQLInputObjectType) {
                String objectName = attributeType.getName() + ARGUMENT_INPUT;
                if (!this.convertedInputs.containsKey(objectName)) {
                    MutableGraphQLInputObjectType wrappedType = new MutableGraphQLInputObjectType(objectName, ((GraphQLInputObjectType)attributeType).getDescription(), ((GraphQLInputObjectType)attributeType).getFields());
                    this.convertedInputs.put(objectName, (GraphQLInputType)wrappedType);
                    attributeType = wrappedType;
                } else {
                    attributeType = this.convertedInputs.get(objectName);
                }
            }
            builder.field(GraphQLInputObjectField.newInputObjectField().name(attribute).type(attributeType));
        }
        MutableGraphQLInputObjectType constructed = builder.build();
        this.inputObjectRegistry.put(clazz, constructed);
        return constructed;
    }

    private void resolveInputObjectRelationships() {
        this.inputObjectRegistry.forEach((clazz, inputObj) -> {
            for (String relationship : this.entityDictionary.getElideBoundRelationships(clazz)) {
                log.debug("Resolving relationship {} for {}", (Object)relationship, (Object)clazz.getName());
                Class relationshipClass = this.entityDictionary.getParameterizedType(clazz, relationship);
                if (this.excludedEntities.contains(relationshipClass)) continue;
                RelationshipType type = this.entityDictionary.getRelationshipType(clazz, relationship);
                if (type.isToOne()) {
                    inputObj.setField(relationship, GraphQLInputObjectField.newInputObjectField().name(relationship).type((GraphQLInputType)this.inputObjectRegistry.get(relationshipClass)).build());
                    continue;
                }
                inputObj.setField(relationship, GraphQLInputObjectField.newInputObjectField().name(relationship).type((GraphQLInputType)new GraphQLList((GraphQLType)this.inputObjectRegistry.get(relationshipClass))).build());
            }
        });
    }
}

