/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import graphql.Assert;
import graphql.AssertException;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MutableGraphQLInputObjectType
extends GraphQLInputObjectType {
    private final Map<String, GraphQLInputObjectField> fieldMap = new LinkedHashMap<String, GraphQLInputObjectField>();
    private final String name;

    public MutableGraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields) {
        super(name, description, fields);
        this.name = name;
        this.buildMap(fields);
    }

    public String getName() {
        return this.name;
    }

    private void buildMap(List<GraphQLInputObjectField> fields) {
        for (GraphQLInputObjectField field : fields) {
            String name = field.getName();
            if (this.fieldMap.containsKey(name)) {
                throw new AssertException("field " + name + " redefined");
            }
            this.fieldMap.put(name, field);
        }
    }

    public void setField(String name, GraphQLInputObjectField field) {
        this.fieldMap.put(name, field);
    }

    public List<GraphQLInputObjectField> getFields() {
        return new ArrayList<GraphQLInputObjectField>(this.fieldMap.values());
    }

    public GraphQLInputObjectField getField(String name) {
        return this.fieldMap.get(name);
    }

    public static Builder newMutableInputObject() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MutableGraphQLInputObjectType that = (MutableGraphQLInputObjectType)((Object)o);
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private String name;
        private String description;
        private List<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder field(GraphQLInputObjectField field) {
            Assert.assertNotNull((Object)field, (String)"field can't be null");
            this.fields.add(field);
            return this;
        }

        public Builder field(GraphQLInputObjectField.Builder builder) {
            this.fields.add(builder.build());
            return this;
        }

        public Builder fields(List<GraphQLInputObjectField> fields) {
            for (GraphQLInputObjectField field : fields) {
                this.field(field);
            }
            return this;
        }

        public MutableGraphQLInputObjectType build() {
            return new MutableGraphQLInputObjectType(this.name, this.description, this.fields);
        }
    }
}

