/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.google.common.collect.Sets;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.graphql.Entity;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.RelationshipOp;
import com.yahoo.elide.graphql.containers.ConnectionContainer;
import com.yahoo.elide.graphql.containers.MapEntryContainer;
import graphql.language.Field;
import graphql.language.FragmentSpread;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentResourceFetcher
implements DataFetcher<Object> {
    private static final Logger log = LoggerFactory.getLogger(PersistentResourceFetcher.class);
    private final ElideSettings settings;
    private final NonEntityDictionary nonEntityDictionary;

    public PersistentResourceFetcher(ElideSettings settings, NonEntityDictionary nonEntityDictionary) {
        this.settings = settings;
        this.nonEntityDictionary = nonEntityDictionary;
    }

    public Object get(DataFetchingEnvironment environment) {
        Map args = environment.getArguments();
        RelationshipOp operation = args.getOrDefault("op", RelationshipOp.FETCH);
        Environment context = new Environment(environment);
        if (log.isDebugEnabled()) {
            this.logContext(operation, context);
        }
        if (operation != RelationshipOp.FETCH) {
            this.filterSortPaginateSanityCheck(context);
        }
        switch (operation) {
            case FETCH: {
                return this.fetchObjects(context);
            }
            case UPSERT: {
                return this.upsertObjects(context);
            }
            case UPDATE: {
                return this.updateObjects(context);
            }
            case DELETE: {
                return this.deleteObjects(context);
            }
            case REMOVE: {
                return this.removeObjects(context);
            }
            case REPLACE: {
                return this.replaceObjects(context);
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + (Object)((Object)operation));
    }

    private void filterSortPaginateSanityCheck(Environment environment) {
        if (environment.filters.isPresent() || environment.sort.isPresent() || environment.offset.isPresent() || environment.first.isPresent()) {
            throw new BadRequestException("Pagination/Filtering/Sorting is only supported with FETCH operation");
        }
    }

    private void logContext(RelationshipOp operation, Environment environment) {
        List children = environment.field.getSelectionSet() != null ? environment.field.getSelectionSet().getChildren() : new ArrayList();
        ArrayList fieldName = new ArrayList();
        if (children.size() > 0) {
            children.stream().forEach(i -> {
                if (i.getClass().equals(Field.class)) {
                    fieldName.add(((Field)i).getName());
                } else if (i.getClass().equals(FragmentSpread.class)) {
                    fieldName.add(((FragmentSpread)i).getName());
                } else {
                    log.debug("A new type of Selection, other than Field and FragmentSpread was encountered, {}", i.getClass());
                }
            });
        }
        String requestedFields = environment.field.getName() + ((Object)fieldName).toString();
        GraphQLType parent = environment.parentType;
        if (log.isDebugEnabled()) {
            log.debug("{} {} fields with parent {}<{}>", new Object[]{operation, requestedFields, EntityDictionary.getSimpleName(parent.getClass()), parent.getName()});
        }
    }

    private Object fetchObjects(Environment context) {
        if (context.data.isPresent()) {
            throw new BadRequestException("FETCH must not include data");
        }
        return context.container.processFetch(context, this);
    }

    public ConnectionContainer fetchObject(Environment context, RequestScope requestScope, Class<?> entityClass, Optional<List<String>> ids, Optional<String> sort, Optional<String> offset, Optional<String> first, Optional<String> filters, boolean generateTotals) {
        EntityDictionary dictionary = requestScope.getDictionary();
        String typeName = dictionary.getJsonAliasFor(entityClass);
        Optional<Pagination> pagination = this.buildPagination(first, offset, generateTotals);
        Optional<Sorting> sorting = this.buildSorting(sort);
        Optional<FilterExpression> filter = this.buildFilter(typeName, filters, requestScope);
        Set records = ids.map(idList -> {
            if (idList.isEmpty()) {
                throw new BadRequestException("Empty list passed to ids");
            }
            return PersistentResource.loadRecords((Class)entityClass, (List)idList, (Optional)filter, (Optional)sorting, (Optional)pagination, (RequestScope)requestScope);
        }).orElseGet(() -> PersistentResource.loadRecords((Class)entityClass, new ArrayList(), (Optional)filter, (Optional)sorting, (Optional)pagination, (RequestScope)requestScope));
        return new ConnectionContainer(records, pagination, typeName);
    }

    public Object fetchRelationship(Environment context, PersistentResource<?> parentResource, String fieldName, Optional<List<String>> ids, Optional<String> offset, Optional<String> first, Optional<String> sort, Optional<String> filters, boolean generateTotals) {
        EntityDictionary dictionary = parentResource.getRequestScope().getDictionary();
        Class entityClass = dictionary.getParameterizedType(parentResource.getObject(), fieldName);
        String typeName = dictionary.getJsonAliasFor(entityClass);
        Optional<Pagination> pagination = this.buildPagination(first, offset, generateTotals);
        Optional<Sorting> sorting = this.buildSorting(sort);
        Optional<FilterExpression> filter = this.buildFilter(typeName, filters, parentResource.getRequestScope());
        Set relations = ids.isPresent() ? parentResource.getRelation(fieldName, ids.get(), filter, sorting, pagination) : parentResource.getRelationCheckedFiltered(fieldName, filter, sorting, pagination);
        return new ConnectionContainer(relations, pagination, typeName);
    }

    private ConnectionContainer upsertObjects(Environment context) {
        return this.upsertOrUpdateObjects(context, entityObject -> this.upsertObject(context, entityObject), RelationshipOp.UPSERT);
    }

    private ConnectionContainer updateObjects(Environment context) {
        return this.upsertOrUpdateObjects(context, entityObject -> this.updateObject(context, entityObject), RelationshipOp.UPDATE);
    }

    private ConnectionContainer upsertOrUpdateObjects(Environment context, Executor<?> updateFunc, RelationshipOp operation) {
        if (context.ids.isPresent()) {
            throw new BadRequestException((Object)((Object)operation) + " must not include ids");
        }
        if (!context.data.isPresent()) {
            throw new BadRequestException((Object)((Object)operation) + " must include data argument");
        }
        EntityDictionary dictionary = context.requestScope.getDictionary();
        Class entityClass = context.isRoot() ? dictionary.getEntityClass(context.field.getName()) : dictionary.getParameterizedType(context.parentResource.getResourceClass(), context.field.getName());
        Optional<Entity> parentEntity = !context.isRoot() ? Optional.of(new Entity(Optional.empty(), null, context.parentResource.getResourceClass(), context.requestScope)) : Optional.empty();
        LinkedHashSet<Entity> entitySet = new LinkedHashSet<Entity>();
        for (Map<String, Object> input : context.data.get()) {
            entitySet.add(new Entity(parentEntity, input, entityClass, context.requestScope));
        }
        for (Entity entity : entitySet) {
            this.graphWalker(entity, updateFunc);
        }
        for (Entity entity : entitySet) {
            this.graphWalker(entity, this::updateRelationship);
            PersistentResource childResource = entity.toPersistentResource();
            if (context.isRoot()) continue;
            context.parentResource.addRelation(context.field.getName(), childResource);
        }
        String entityName = dictionary.getJsonAliasFor(entityClass);
        Set resources = entitySet.stream().map(Entity::toPersistentResource).collect(Collectors.toCollection(LinkedHashSet::new));
        return new ConnectionContainer(resources, Optional.empty(), entityName);
    }

    private void graphWalker(Entity entity, Executor<?> function) {
        ArrayDeque<Entity> toVisit = new ArrayDeque<Entity>();
        LinkedHashSet<Entity> visited = new LinkedHashSet<Entity>();
        toVisit.add(entity);
        while (!toVisit.isEmpty()) {
            Entity currentEntity = (Entity)toVisit.remove();
            if (visited.contains(currentEntity)) continue;
            visited.add(currentEntity);
            function.execute(currentEntity);
            Set<Entity.Relationship> relationshipEntities = currentEntity.getRelationships();
            for (Entity.Relationship relationship : relationshipEntities) {
                toVisit.addAll(relationship.getValue());
            }
        }
    }

    private PersistentResource<?> updateRelationship(Entity entity) {
        Set<Entity.Relationship> relationshipEntities = entity.getRelationships();
        PersistentResource resource = entity.toPersistentResource();
        for (Entity.Relationship relationship : relationshipEntities) {
            LinkedHashSet<PersistentResource> toUpdate = new LinkedHashSet<PersistentResource>();
            for (Entity relation : relationship.getValue()) {
                toUpdate.add(relation.toPersistentResource());
            }
            resource.updateRelation(relationship.getName(), toUpdate);
        }
        return resource;
    }

    private PersistentResource<?> upsertObject(Environment context, Entity entity) {
        PersistentResource upsertedResource;
        Set<Entity.Attribute> attributes = entity.getAttributes();
        Optional<String> id = entity.getId();
        RequestScope requestScope = entity.getRequestScope();
        EntityDictionary dictionary = requestScope.getDictionary();
        PersistentResource parentResource = !entity.getParentResource().isPresent() ? null : entity.getParentResource().get().toPersistentResource();
        if (!id.isPresent()) {
            if (dictionary.isIdGenerated(entity.getEntityClass())) {
                entity.setId();
                id = entity.getId();
            }
            upsertedResource = PersistentResource.createObject((PersistentResource)parentResource, entity.getEntityClass(), (RequestScope)requestScope, id);
        } else {
            try {
                Set<PersistentResource> loadedResource = this.fetchObject(context, requestScope, entity.getEntityClass(), Optional.of(Arrays.asList(id.get())), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false).getPersistentResources();
                upsertedResource = (PersistentResource)IterableUtils.first(loadedResource);
            }
            catch (InvalidObjectIdentifierException | InvalidValueException e) {
                upsertedResource = PersistentResource.createObject((PersistentResource)parentResource, entity.getEntityClass(), (RequestScope)requestScope, id);
            }
        }
        return this.updateAttributes(upsertedResource, entity, attributes);
    }

    private PersistentResource<?> updateObject(Environment context, Entity entity) {
        Set<Entity.Attribute> attributes = entity.getAttributes();
        Optional<String> id = entity.getId();
        RequestScope requestScope = entity.getRequestScope();
        if (!id.isPresent()) {
            throw new BadRequestException("UPDATE data objects must include ids");
        }
        Set<PersistentResource> loadedResource = this.fetchObject(context, requestScope, entity.getEntityClass(), Optional.of(Arrays.asList(id.get())), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false).getPersistentResources();
        PersistentResource updatedResource = (PersistentResource)IterableUtils.first(loadedResource);
        return this.updateAttributes(updatedResource, entity, attributes);
    }

    private PersistentResource<?> updateAttributes(PersistentResource<?> toUpdate, Entity entity, Set<Entity.Attribute> attributes) {
        EntityDictionary dictionary = entity.getRequestScope().getDictionary();
        Class<?> entityClass = entity.getEntityClass();
        String idFieldName = dictionary.getIdFieldName(entityClass);
        for (Entity.Attribute attribute : attributes) {
            if (dictionary.isAttribute(entityClass, attribute.getName())) {
                Class attributeType = dictionary.getType(entityClass, attribute.getName());
                Object attributeValue = Map.class.isAssignableFrom(attributeType) ? MapEntryContainer.translateFromGraphQLMap(attribute) : attribute.getValue();
                toUpdate.updateAttribute(attribute.getName(), attributeValue);
                continue;
            }
            if (Objects.equals(attribute.getName(), idFieldName)) continue;
            throw new IllegalStateException("Unrecognized attribute passed to 'data': " + attribute.getName());
        }
        return toUpdate;
    }

    private Object deleteObjects(Environment context) {
        if (context.data.isPresent()) {
            throw new BadRequestException("DELETE must not include data argument");
        }
        if (!context.ids.isPresent()) {
            throw new BadRequestException("DELETE must include ids argument");
        }
        ConnectionContainer connection = (ConnectionContainer)this.fetchObjects(context);
        Set<PersistentResource> toDelete = connection.getPersistentResources();
        toDelete.forEach(PersistentResource::deleteResource);
        return new ConnectionContainer(Collections.emptySet(), Optional.empty(), connection.getTypeName());
    }

    private Object removeObjects(Environment context) {
        if (context.data.isPresent()) {
            throw new BadRequestException("REPLACE must not include data argument");
        }
        if (!context.ids.isPresent()) {
            throw new BadRequestException("REPLACE must include ids argument");
        }
        ConnectionContainer connection = (ConnectionContainer)this.fetchObjects(context);
        Set<PersistentResource> toRemove = connection.getPersistentResources();
        if (!context.isRoot()) {
            toRemove.forEach(item -> context.parentResource.removeRelation(context.field.getName(), item));
        } else {
            toRemove.forEach(PersistentResource::deleteResource);
        }
        return new ConnectionContainer(Collections.emptySet(), Optional.empty(), connection.getTypeName());
    }

    private ConnectionContainer replaceObjects(Environment context) {
        if (!context.data.isPresent()) {
            throw new BadRequestException("REPLACE must include data argument");
        }
        if (context.ids.isPresent()) {
            throw new BadRequestException("REPLACE must not include ids argument");
        }
        ConnectionContainer existingObjects = (ConnectionContainer)context.container.processFetch(context, this);
        ConnectionContainer upsertedObjects = this.upsertObjects(context);
        Sets.SetView toDelete = Sets.difference(existingObjects.getPersistentResources(), upsertedObjects.getPersistentResources());
        if (!context.isRoot()) {
            toDelete.forEach(item -> context.parentResource.removeRelation(context.field.getName(), item));
        } else {
            toDelete.forEach(PersistentResource::deleteResource);
        }
        return upsertedObjects;
    }

    private Optional<Pagination> buildPagination(Optional<String> first, Optional<String> offset, boolean generateTotals) {
        return Pagination.fromOffsetAndFirst(first, offset, (boolean)generateTotals, (ElideSettings)this.settings);
    }

    private Optional<Sorting> buildSorting(Optional<String> sort) {
        return sort.map(Sorting::parseSortRule);
    }

    private MultivaluedHashMap<String, String> getQueryParams(final Optional<String> typeName, final String filterStr) {
        return new MultivaluedHashMap<String, String>(){
            {
                String filterKey = "filter";
                if (typeName.isPresent()) {
                    filterKey = filterKey + "[" + typeName + "]";
                }
                this.put(filterKey, Arrays.asList(filterStr));
            }
        };
    }

    private Optional<FilterExpression> buildFilter(String typeName, Optional<String> filter, RequestScope requestScope) {
        return filter.map(filterStr -> {
            String errorMessage = "";
            try {
                return requestScope.getFilterDialect().parseGlobalExpression(typeName, this.getQueryParams(Optional.empty(), (String)filterStr));
            }
            catch (ParseException e) {
                errorMessage = e.getMessage();
                try {
                    return (FilterExpression)requestScope.getFilterDialect().parseTypedExpression(typeName, this.getQueryParams(Optional.of(typeName), (String)filterStr)).get(typeName);
                }
                catch (ParseException e2) {
                    throw new BadRequestException(errorMessage + "\n" + e2.getMessage());
                }
            }
        });
    }

    public NonEntityDictionary getNonEntityDictionary() {
        return this.nonEntityDictionary;
    }

    @FunctionalInterface
    private static interface Executor<T> {
        public T execute(Entity var1);
    }
}

