/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.ErrorObjects;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.CustomErrorException;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.graphql.ExecutionResultSerializer;
import com.yahoo.elide.graphql.GraphQLErrorSerializer;
import com.yahoo.elide.graphql.GraphQLRequestScope;
import com.yahoo.elide.graphql.ModelBuilder;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.PersistentResourceFetcher;
import com.yahoo.elide.security.User;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRunner {
    private static final Logger log = LoggerFactory.getLogger(QueryRunner.class);
    private final Elide elide;
    private GraphQL api;
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String MUTATION = "mutation";

    public QueryRunner(Elide elide) {
        this.elide = elide;
        NonEntityDictionary nonEntityDictionary = new NonEntityDictionary();
        PersistentResourceFetcher fetcher = new PersistentResourceFetcher(elide.getElideSettings(), nonEntityDictionary);
        ModelBuilder builder = new ModelBuilder(elide.getElideSettings().getDictionary(), nonEntityDictionary, fetcher);
        this.api = new GraphQL(builder.build());
        GraphQLErrorSerializer errorSerializer = new GraphQLErrorSerializer(elide.getElideSettings().isEncodeErrorResponses());
        SimpleModule module = new SimpleModule("ExecutionResultSerializer", Version.unknownVersion());
        module.addSerializer(ExecutionResult.class, (JsonSerializer)new ExecutionResultSerializer(errorSerializer));
        module.addSerializer(GraphQLError.class, (JsonSerializer)errorSerializer);
        elide.getElideSettings().getMapper().getObjectMapper().registerModule((Module)module);
    }

    public ElideResponse run(String baseUrlEndPoint, String graphQLDocument, Object user) {
        JsonNode topLevel;
        ObjectMapper mapper = this.elide.getMapper().getObjectMapper();
        try {
            topLevel = mapper.readTree(graphQLDocument);
        }
        catch (IOException e) {
            log.debug("Invalid json body provided to GraphQL", (Throwable)e);
            return this.buildErrorResponse((HttpStatusException)new InvalidEntityBodyException(graphQLDocument), false);
        }
        Function<JsonNode, ElideResponse> executeRequest = node -> this.executeGraphQLRequest(baseUrlEndPoint, mapper, user, graphQLDocument, (JsonNode)node);
        if (topLevel.isArray()) {
            Iterator nodeIterator = topLevel.iterator();
            Iterable nodeIterable = () -> nodeIterator;
            Stream<JsonNode> nodeStream = StreamSupport.stream(nodeIterable.spliterator(), false);
            ArrayNode result = nodeStream.map(executeRequest).map(response -> {
                try {
                    return mapper.readTree(response.getBody());
                }
                catch (IOException e) {
                    log.debug("Caught an IO exception while trying to read response body");
                    return JsonNodeFactory.instance.objectNode();
                }
            }).reduce(JsonNodeFactory.instance.arrayNode(), (arrayNode, node) -> arrayNode.add(node), (left, right) -> left.addAll(right));
            try {
                return ElideResponse.builder().responseCode(200).body(mapper.writeValueAsString((Object)result)).build();
            }
            catch (IOException e) {
                log.error("An unexpected error occurred trying to serialize array response.", (Throwable)e);
                return ElideResponse.builder().responseCode(500).build();
            }
        }
        return executeRequest.apply(topLevel);
    }

    /*
     * Loose catch block
     */
    private ElideResponse executeGraphQLRequest(String baseUrlEndPoint, ObjectMapper mapper, Object principal, String graphQLDocument, JsonNode jsonDocument) {
        boolean isVerbose = false;
        try {
            ElideResponse elideResponse;
            Object object;
            DataStoreTransaction tx;
            block40: {
                block41: {
                    GraphQLRequestScope requestScope;
                    block37: {
                        ElideResponse elideResponse2;
                        block38: {
                            block39: {
                                tx = this.elide.getDataStore().beginTransaction();
                                object = null;
                                User user = tx.accessUser(principal);
                                requestScope = new GraphQLRequestScope(baseUrlEndPoint, tx, user, this.elide.getElideSettings());
                                isVerbose = requestScope.getPermissionExecutor().isVerbose();
                                if (jsonDocument.has(QUERY)) break block37;
                                elideResponse2 = ElideResponse.builder().responseCode(400).body("A `query` key is required.").build();
                                if (tx == null) break block38;
                                if (object == null) break block39;
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                break block38;
                            }
                            tx.close();
                        }
                        return elideResponse2;
                    }
                    String query = jsonDocument.get(QUERY).asText();
                    log.info("Processing GraphQL query:\n{}", (Object)query);
                    ExecutionInput.Builder executionInput = new ExecutionInput.Builder().context((Object)requestScope).query(query);
                    if (jsonDocument.has(OPERATION_NAME) && !jsonDocument.get(OPERATION_NAME).isNull()) {
                        executionInput.operationName(jsonDocument.get(OPERATION_NAME).asText());
                    }
                    if (jsonDocument.has(VARIABLES) && !jsonDocument.get(VARIABLES).isNull()) {
                        Map variables = (Map)mapper.convertValue((Object)jsonDocument.get(VARIABLES), Map.class);
                        executionInput.variables(variables);
                    }
                    final ExecutionResult result = this.api.execute(executionInput);
                    tx.preCommit();
                    requestScope.runQueuedPreSecurityTriggers();
                    requestScope.getPermissionExecutor().executeCommitChecks();
                    if (query.trim().startsWith(MUTATION)) {
                        if (!result.getErrors().isEmpty()) {
                            HashMap<String, Object> abortedResponseObject = new HashMap<String, Object>(){
                                {
                                    this.put("errors", result.getErrors());
                                    this.put("data", null);
                                }
                            };
                            throw new WebApplicationException(Response.ok((Object)mapper.writeValueAsString((Object)abortedResponseObject)).build());
                        }
                        requestScope.saveOrCreateObjects();
                    }
                    tx.flush((RequestScope)requestScope);
                    requestScope.runQueuedPreCommitTriggers();
                    this.elide.getAuditLogger().commit((RequestScope)requestScope);
                    tx.commit((RequestScope)requestScope);
                    requestScope.runQueuedPostCommitTriggers();
                    if (log.isTraceEnabled()) {
                        requestScope.getPermissionExecutor().printCheckStats();
                    }
                    elideResponse = ElideResponse.builder().responseCode(200).body(mapper.writeValueAsString((Object)result)).build();
                    if (tx == null) break block40;
                    if (object == null) break block41;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block40;
                }
                tx.close();
            }
            return elideResponse;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (tx != null) {
                            if (object != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (JsonProcessingException e) {
                    log.debug("Invalid json body provided to GraphQL", (Throwable)e);
                    object = this.buildErrorResponse((HttpStatusException)new InvalidEntityBodyException(graphQLDocument), isVerbose);
                    return object;
                }
                catch (IOException e) {
                    log.error("Uncaught IO Exception by Elide in GraphQL", (Throwable)e);
                    object = this.buildErrorResponse((HttpStatusException)new TransactionException((Throwable)e), isVerbose);
                    return object;
                }
                catch (WebApplicationException e) {
                    log.debug("WebApplicationException", (Throwable)e);
                    String body = e.getResponse().getEntity() != null ? e.getResponse().getEntity().toString() : e.getMessage();
                    ElideResponse elideResponse3 = ElideResponse.builder().responseCode(e.getResponse().getStatus()).body(body).build();
                    return elideResponse3;
                }
                catch (HttpStatusException e) {
                    if (e instanceof ForbiddenAccessException) {
                        if (log.isDebugEnabled()) {
                            log.debug("{}", (Object)((ForbiddenAccessException)e).getLoggedMessage());
                        }
                    } else {
                        log.debug("Caught HTTP status exception {}", (Object)e.getStatus(), (Object)e);
                    }
                    object = this.buildErrorResponse(new HttpStatusException(200, ""){

                        public int getStatus() {
                            return 200;
                        }

                        public Pair<Integer, JsonNode> getErrorResponse(boolean encodeResponse) {
                            return e.getErrorResponse(encodeResponse);
                        }

                        public Pair<Integer, JsonNode> getVerboseErrorResponse(boolean encodeResponse) {
                            return e.getVerboseErrorResponse(encodeResponse);
                        }

                        public String getVerboseMessage() {
                            return e.getVerboseMessage();
                        }

                        public String toString() {
                            return e.toString();
                        }
                    }, isVerbose);
                    return object;
                }
                catch (Error | Exception e) {
                    log.debug("Unhandled error or exception.", e);
                    throw e;
                }
            }
        }
        finally {
            this.elide.getAuditLogger().clear();
        }
    }

    private ElideResponse buildErrorResponse(HttpStatusException error, boolean isVerbose) {
        String errorBody;
        JsonNode errorNode;
        ObjectMapper mapper = this.elide.getMapper().getObjectMapper();
        boolean encodeErrorResponses = this.elide.getElideSettings().isEncodeErrorResponses();
        if (!(error instanceof CustomErrorException) && this.elide.getElideSettings().isReturnErrorObjects()) {
            String errorMessage;
            String string = errorMessage = isVerbose ? error.getVerboseMessage() : error.toString();
            if (encodeErrorResponses) {
                errorMessage = Encode.forHtml((String)errorMessage);
            }
            ErrorObjects errors = ErrorObjects.builder().addError().with("message", (Object)errorMessage).build();
            errorNode = (JsonNode)mapper.convertValue((Object)errors, JsonNode.class);
        } else {
            errorNode = isVerbose ? (JsonNode)error.getVerboseErrorResponse(encodeErrorResponses).getRight() : (JsonNode)error.getErrorResponse(encodeErrorResponses).getRight();
        }
        try {
            errorBody = mapper.writeValueAsString((Object)errorNode);
        }
        catch (JsonProcessingException e) {
            errorBody = errorNode.toString();
        }
        return ElideResponse.builder().responseCode(error.getStatus()).body(errorBody).build();
    }
}

