/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.containers;

import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.graphql.Entity;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.PersistentResourceFetcher;
import com.yahoo.elide.graphql.containers.GraphQLContainer;
import com.yahoo.elide.graphql.containers.NonEntityContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MapEntryContainer
implements GraphQLContainer {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private final Map.Entry entry;

    public MapEntryContainer(Map.Entry entry) {
        this.entry = entry;
    }

    @Override
    public Object processFetch(Environment context, PersistentResourceFetcher fetcher) {
        Object returnObject;
        NonEntityDictionary nonEntityDictionary = fetcher.getNonEntityDictionary();
        String fieldName = context.field.getName();
        if (KEY.equalsIgnoreCase(fieldName)) {
            returnObject = this.entry.getKey();
        } else if (VALUE.equalsIgnoreCase(fieldName)) {
            returnObject = this.entry.getValue();
        } else {
            throw new BadRequestException("Invalid field: '" + fieldName + "'. Maps only contain fields 'key' and 'value'");
        }
        if (nonEntityDictionary.hasBinding(returnObject.getClass())) {
            return new NonEntityContainer(returnObject);
        }
        return returnObject;
    }

    public static Map translateFromGraphQLMap(Entity.Attribute attribute) {
        HashMap returnMap = new HashMap();
        Object collection = attribute.getValue();
        if (collection == null) {
            return null;
        }
        if (!(collection instanceof Collection)) {
            throw new BadRequestException("Invalid map format for GraphQL request");
        }
        ((Collection)collection).stream().forEach(entry -> {
            if (!(entry instanceof Map)) {
                throw new BadRequestException("Invalid map format for GraphQL request");
            }
            if (!((Map)entry).containsKey(KEY) && ((Map)entry).containsKey(VALUE)) {
                throw new BadRequestException("Invalid map format for GraphQL request");
            }
            returnMap.put(((Map)entry).get(KEY), ((Map)entry).get(VALUE));
        });
        return returnMap;
    }
}

