/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.containers;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.graphql.DeferredId;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.PersistentResourceFetcher;
import com.yahoo.elide.graphql.containers.GraphQLContainer;
import com.yahoo.elide.graphql.containers.MapEntryContainer;
import com.yahoo.elide.graphql.containers.NonEntityContainer;
import com.yahoo.elide.graphql.containers.PersistentResourceContainer;
import com.yahoo.elide.graphql.containers.RootContainer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class NodeContainer
implements PersistentResourceContainer,
GraphQLContainer {
    private final PersistentResource persistentResource;

    @Override
    public Object processFetch(Environment context, PersistentResourceFetcher fetcher) {
        EntityDictionary entityDictionary = context.requestScope.getDictionary();
        NonEntityDictionary nonEntityDictionary = fetcher.getNonEntityDictionary();
        Class parentClass = context.parentResource.getResourceClass();
        String fieldName = context.field.getName();
        String idFieldName = entityDictionary.getIdFieldName(parentClass);
        if (entityDictionary.isAttribute(parentClass, fieldName)) {
            Class innerType;
            Object attribute = context.parentResource.getAttribute(fieldName);
            if (attribute != null && nonEntityDictionary.hasBinding(attribute.getClass())) {
                return new NonEntityContainer(attribute);
            }
            if (attribute instanceof Map) {
                return ((Map)attribute).entrySet().stream().map(MapEntryContainer::new).collect(Collectors.toList());
            }
            if (attribute instanceof Collection && nonEntityDictionary.hasBinding(innerType = entityDictionary.getParameterizedType(parentClass, fieldName))) {
                return ((Collection)attribute).stream().map(NonEntityContainer::new).collect(Collectors.toList());
            }
            return attribute;
        }
        if (entityDictionary.isRelation(parentClass, fieldName)) {
            boolean generateTotals = RootContainer.requestContainsPageInfo(context.field);
            return fetcher.fetchRelationship(context, context.parentResource, fieldName, context.ids, context.offset, context.first, context.sort, context.filters, generateTotals);
        }
        if (Objects.equals(idFieldName, fieldName)) {
            return new DeferredId(context.parentResource);
        }
        throw new BadRequestException("Unrecognized object: " + fieldName + " for: " + parentClass.getName() + " in node");
    }

    public NodeContainer(PersistentResource persistentResource) {
        this.persistentResource = persistentResource;
    }

    @Override
    public PersistentResource getPersistentResource() {
        return this.persistentResource;
    }
}

