/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.containers;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.PersistentResourceFetcher;
import com.yahoo.elide.graphql.containers.ConnectionContainer;
import com.yahoo.elide.graphql.containers.GraphQLContainer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PageInfoContainer
implements GraphQLContainer {
    private final ConnectionContainer connectionContainer;
    private static final String PAGE_INFO_HAS_NEXT_PAGE_KEYWORD = "hasNextPage";
    private static final String PAGE_INFO_START_CURSOR_KEYWORD = "startCursor";
    private static final String PAGE_INFO_END_CURSOR_KEYWORD = "endCursor";
    private static final String PAGE_INFO_TOTAL_RECORDS_KEYWORD = "totalRecords";

    public PageInfoContainer(ConnectionContainer connectionContainer) {
        this.connectionContainer = connectionContainer;
    }

    @Override
    public Object processFetch(Environment context, PersistentResourceFetcher fetcher) {
        String fieldName = context.field.getName();
        ConnectionContainer connectionContainer = this.getConnectionContainer();
        Optional<Pagination> pagination = connectionContainer.getPagination();
        List ids = connectionContainer.getPersistentResources().stream().map(PersistentResource::getId).sorted().collect(Collectors.toList());
        return pagination.map(pageValue -> {
            switch (fieldName) {
                case "hasNextPage": {
                    int numResults = ids.size();
                    int nextOffset = numResults + pageValue.getOffset();
                    return Boolean.valueOf((long)nextOffset < pageValue.getPageTotals());
                }
                case "startCursor": {
                    return Integer.valueOf(pageValue.getOffset());
                }
                case "endCursor": {
                    return Integer.valueOf(pageValue.getOffset() + ids.size());
                }
                case "totalRecords": {
                    return Long.valueOf(pageValue.getPageTotals());
                }
            }
            throw new BadRequestException("Invalid request. Looking for field: " + fieldName + " in an pageInfo object.");
        }).orElseThrow(() -> new BadRequestException("Could not generate pagination information for type: " + connectionContainer.getTypeName()));
    }

    public ConnectionContainer getConnectionContainer() {
        return this.connectionContainer;
    }
}

