/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.yahoo.elide.graphql.GraphQLErrorDeserializer;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionResultDeserializer
extends StdDeserializer<ExecutionResult> {
    private static final Logger log = LoggerFactory.getLogger(ExecutionResultDeserializer.class);
    ObjectMapper mapper = new ObjectMapper();
    GraphQLErrorDeserializer errorDeserializer = new GraphQLErrorDeserializer();

    public ExecutionResultDeserializer() {
        super(ExecutionResult.class);
    }

    public ExecutionResult deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode root = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode dataNode = root.get("data");
        JsonNode errorsNode = root.get("errors");
        ArrayList<GraphQLError> errors = null;
        if (errorsNode != null) {
            errors = new ArrayList<GraphQLError>();
            for (JsonNode errorNode : errorsNode) {
                errors.add(this.errorDeserializer.deserialize(errorNode.traverse(parser.getCodec()), context));
            }
        }
        Map data = (Map)this.mapper.convertValue((Object)dataNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return ExecutionResultImpl.newExecutionResult().errors(errors).data((Object)data).build();
    }
}

