/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.yahoo.elide.graphql.GraphQLErrorSerializer;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionResultSerializer
extends StdSerializer<ExecutionResult> {
    private static final Logger log = LoggerFactory.getLogger(ExecutionResultSerializer.class);
    private final GraphQLErrorSerializer errorSerializer;

    public ExecutionResultSerializer() {
        this(new GraphQLErrorSerializer());
    }

    public ExecutionResultSerializer(GraphQLErrorSerializer errorSerializer) {
        super(ExecutionResult.class);
        this.errorSerializer = errorSerializer;
    }

    public void serialize(ExecutionResult value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        Map spec = value.toSpecification();
        if (spec.containsKey("data")) {
            gen.writeObjectField("data", spec.get("data"));
        }
        if (spec.containsKey("errors")) {
            List errors = value.getErrors();
            gen.writeArrayFieldStart("errors");
            for (GraphQLError error : errors) {
                this.errorSerializer.serialize(error, gen, provider);
            }
            gen.writeEndArray();
        }
        if (spec.containsKey("extensions")) {
            gen.writeObjectField("extensions", spec.get("extensions"));
        }
        gen.writeEndObject();
    }
}

