/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.jsonapi.resources.SecurityContextUser;
import com.yahoo.elide.utils.HeaderUtils;
import com.yahoo.elide.utils.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Produces(value={"application/json"})
@Path(value="/")
public class GraphQLEndpoint {
    private static final Logger log = LoggerFactory.getLogger(GraphQLEndpoint.class);
    private final Map<String, QueryRunner> runners;
    private final Elide elide;
    private final HeaderUtils.HeaderProcessor headerProcessor;

    @Inject
    public GraphQLEndpoint(@Named(value="elide") Elide elide) {
        log.debug("Started ~~");
        this.elide = elide;
        this.headerProcessor = elide.getElideSettings().getHeaderProcessor();
        this.runners = new HashMap<String, QueryRunner>();
        for (String apiVersion : elide.getElideSettings().getDictionary().getApiVersions()) {
            this.runners.put(apiVersion, new QueryRunner(elide, apiVersion));
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response post(@Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext, String graphQLDocument) {
        String apiVersion = HeaderUtils.resolveApiVersion((Map)headers.getRequestHeaders());
        Map requestHeaders = this.headerProcessor.process((Map)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        QueryRunner runner = this.runners.getOrDefault(apiVersion, null);
        ElideResponse response = runner == null ? QueryRunner.buildErrorResponse(this.elide.getMapper().getObjectMapper(), (HttpStatusException)new InvalidOperationException("Invalid API Version"), false) : runner.run(this.getBaseUrlEndpoint(uriInfo), graphQLDocument, (User)user, UUID.randomUUID(), requestHeaders);
        return Response.status((int)response.getResponseCode()).entity((Object)response.getBody()).build();
    }

    protected String getBaseUrlEndpoint(UriInfo uriInfo) {
        String baseUrl = this.elide.getElideSettings().getBaseUrl();
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ResourceUtils.resolveBaseUrl((UriInfo)uriInfo);
        }
        return baseUrl;
    }
}

