/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GraphQLErrorDeserializer
extends StdDeserializer<GraphQLError> {
    public GraphQLErrorDeserializer() {
        super(GraphQLError.class);
    }

    public GraphQLError deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode root = (JsonNode)parser.getCodec().readTree(parser);
        final JsonNode messageNode = root.get("message");
        final JsonNode pathNode = root.get("path");
        final JsonNode sourceLocations = root.get("locations");
        GraphQLError error = new GraphQLError(){

            public String toString() {
                return String.format("{ \"message\": \"%s\", \"locations\": %s, \"path\": %s}", this.getMessage(), this.getLocations(), this.getPath());
            }

            public String getMessage() {
                return messageNode == null ? null : messageNode.textValue();
            }

            public List<SourceLocation> getLocations() {
                if (sourceLocations != null) {
                    ArrayList<SourceLocation> result = new ArrayList<SourceLocation>();
                    sourceLocations.forEach(sourceLocation -> result.add(new SourceLocation(sourceLocation.get("line").asInt(), sourceLocation.get("column").asInt())));
                    return result;
                }
                return null;
            }

            public ErrorClassification getErrorType() {
                return ErrorType.ExecutionAborted;
            }

            public List<Object> getPath() {
                if (pathNode != null) {
                    ArrayList<Object> paths = new ArrayList<Object>();
                    pathNode.forEach(path -> paths.add(path.asText()));
                    return paths;
                }
                return null;
            }
        };
        return error;
    }
}

