/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.Type;
import org.apache.commons.lang3.StringUtils;

public class GraphQLNameUtils {
    private static final String MAP_SUFFIX = "Map";
    private static final String INPUT_SUFFIX = "Input";
    private static final String CONNECTION_SUFFIX = "Connection";
    private static final String EDGE_SUFFIX = "Edge";
    private final EntityDictionary dictionary;

    public GraphQLNameUtils(EntityDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public String toOutputTypeName(Type<?> clazz) {
        Object typeName = this.dictionary.hasBinding(clazz) ? StringUtils.capitalize((String)this.dictionary.getJsonAliasFor(clazz)) : clazz.getSimpleName();
        if (clazz.getPackage().getName().startsWith("com.yahoo.elide")) {
            typeName = "Elide" + (String)typeName;
        }
        return typeName;
    }

    public String toInputTypeName(Type<?> clazz) {
        return this.toOutputTypeName(clazz) + INPUT_SUFFIX;
    }

    public String toMapEntryOutputName(Type<?> keyClazz, Type<?> valueClazz) {
        return this.toOutputTypeName(keyClazz) + this.toOutputTypeName(valueClazz) + MAP_SUFFIX;
    }

    public String toMapEntryInputName(Type<?> keyClazz, Type<?> valueClazz) {
        return this.toMapEntryOutputName(keyClazz, valueClazz) + INPUT_SUFFIX;
    }

    public String toEdgesName(Type<?> clazz) {
        return this.toOutputTypeName(clazz) + EDGE_SUFFIX;
    }

    public String toNodeName(Type<?> clazz) {
        return this.toOutputTypeName(clazz);
    }

    public String toConnectionName(Type<?> clazz) {
        return this.toOutputTypeName(clazz) + CONNECTION_SUFFIX;
    }

    public String toNonElideOutputTypeName(Type<?> clazz) {
        return StringUtils.uncapitalize((String)this.toOutputTypeName(clazz));
    }

    public String toTopicName(Type<?> clazz) {
        return this.toOutputTypeName(clazz) + "Topic";
    }

    public String toNonElideInputTypeName(Type<?> clazz) {
        return StringUtils.uncapitalize((String)this.toInputTypeName(clazz));
    }
}

