/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.apollographql.federation.graphqljava.Federation;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.graphql.GraphQLConversionUtils;
import com.yahoo.elide.graphql.GraphQLNameUtils;
import com.yahoo.elide.graphql.GraphQLScalars;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.RelationshipOp;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelBuilder {
    private static final Logger log = LoggerFactory.getLogger(ModelBuilder.class);
    public static final String ARGUMENT_DATA = "data";
    public static final String ARGUMENT_IDS = "ids";
    public static final String ARGUMENT_FILTER = "filter";
    public static final String ARGUMENT_SORT = "sort";
    public static final String ARGUMENT_FIRST = "first";
    public static final String ARGUMENT_AFTER = "after";
    public static final String ARGUMENT_OPERATION = "op";
    public static final String OBJECT_PAGE_INFO = "PageInfo";
    public static final String OBJECT_MUTATION = "Mutation";
    public static final String OBJECT_QUERY = "Query";
    private EntityDictionary entityDictionary;
    private DataFetcher dataFetcher;
    private GraphQLArgument relationshipOpArg;
    private GraphQLArgument idArgument;
    private GraphQLArgument filterArgument;
    private GraphQLArgument pageOffsetArgument;
    private GraphQLArgument pageFirstArgument;
    private GraphQLArgument sortArgument;
    private GraphQLConversionUtils generator;
    private GraphQLNameUtils nameUtils;
    private GraphQLObjectType pageInfoObject;
    private final String apiVersion;
    private Map<Type<?>, GraphQLInputObjectType> inputObjectRegistry;
    private Map<Type<?>, GraphQLObjectType> queryObjectRegistry;
    private Map<Type<?>, GraphQLObjectType> connectionObjectRegistry;
    private Set<Type<?>> excludedEntities;
    private Set<GraphQLObjectType> objectTypes = new HashSet<GraphQLObjectType>();
    private boolean enableFederation;

    public ModelBuilder(EntityDictionary entityDictionary, NonEntityDictionary nonEntityDictionary, ElideSettings settings, DataFetcher dataFetcher, String apiVersion) {
        this.generator = new GraphQLConversionUtils(entityDictionary, nonEntityDictionary);
        this.entityDictionary = entityDictionary;
        this.nameUtils = new GraphQLNameUtils(entityDictionary);
        this.dataFetcher = dataFetcher;
        this.apiVersion = apiVersion;
        this.enableFederation = settings.isEnableGraphQLFederation();
        this.relationshipOpArg = GraphQLArgument.newArgument().name(ARGUMENT_OPERATION).type((GraphQLInputType)this.generator.classToEnumType((Type<?>)ClassType.of(RelationshipOp.class))).defaultValue((Object)RelationshipOp.FETCH).build();
        this.idArgument = GraphQLArgument.newArgument().name(ARGUMENT_IDS).type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build();
        this.filterArgument = GraphQLArgument.newArgument().name(ARGUMENT_FILTER).type((GraphQLInputType)Scalars.GraphQLString).build();
        this.sortArgument = GraphQLArgument.newArgument().name(ARGUMENT_SORT).type((GraphQLInputType)Scalars.GraphQLString).build();
        this.pageFirstArgument = GraphQLArgument.newArgument().name(ARGUMENT_FIRST).type((GraphQLInputType)Scalars.GraphQLString).build();
        this.pageOffsetArgument = GraphQLArgument.newArgument().name(ARGUMENT_AFTER).type((GraphQLInputType)Scalars.GraphQLString).build();
        this.pageInfoObject = GraphQLObjectType.newObject().name(OBJECT_PAGE_INFO).field(GraphQLFieldDefinition.newFieldDefinition().name("hasNextPage").type((GraphQLOutputType)Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("startCursor").type((GraphQLOutputType)Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("endCursor").type((GraphQLOutputType)Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("totalRecords").type((GraphQLOutputType)Scalars.GraphQLInt)).build();
        this.objectTypes.add(this.pageInfoObject);
        this.inputObjectRegistry = new HashMap();
        this.queryObjectRegistry = new HashMap();
        this.connectionObjectRegistry = new HashMap();
        this.excludedEntities = new HashSet();
    }

    public void withExcludedEntities(Set<Type<?>> excludedEntities) {
        this.excludedEntities = excludedEntities;
    }

    public GraphQLSchema build() {
        Set allClasses = this.entityDictionary.getBoundClassesByVersion(this.apiVersion);
        if (allClasses.isEmpty()) {
            throw new IllegalArgumentException("None of the provided classes are exported by Elide");
        }
        Set rootClasses = allClasses.stream().filter(arg_0 -> ((EntityDictionary)this.entityDictionary).isRoot(arg_0)).collect(Collectors.toSet());
        this.entityDictionary.walkEntityGraph(rootClasses, this::buildInputObjectStub);
        GraphQLObjectType.Builder root = GraphQLObjectType.newObject().name(OBJECT_QUERY);
        for (Type clazz : rootClasses) {
            String entityName = this.entityDictionary.getJsonAliasFor(clazz);
            root.field(GraphQLFieldDefinition.newFieldDefinition().name(entityName).description(EntityDictionary.getEntityDescription((Type)clazz)).argument(this.relationshipOpArg).argument(this.idArgument).argument(this.filterArgument).argument(this.sortArgument).argument(this.pageFirstArgument).argument(this.pageOffsetArgument).argument(this.buildInputObjectArgument(clazz, true)).arguments(this.generator.entityArgumentToQueryObject(clazz, this.entityDictionary)).type((GraphQLOutputType)this.buildConnectionObject(clazz)));
        }
        GraphQLObjectType queryRoot = root.build();
        GraphQLObjectType mutationRoot = root.name(OBJECT_MUTATION).build();
        this.objectTypes.add(queryRoot);
        this.objectTypes.add(mutationRoot);
        this.entityDictionary.walkEntityGraph(rootClasses, this::buildConnectionObject);
        GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry();
        this.objectTypes.addAll(this.generator.getObjectTypes());
        for (GraphQLObjectType objectType : this.objectTypes) {
            String objectName = objectType.getName();
            for (GraphQLFieldDefinition fieldDefinition : objectType.getFieldDefinitions()) {
                codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)objectName, (String)fieldDefinition.getName()), this.dataFetcher);
            }
        }
        GraphQLSchema schema = GraphQLSchema.newSchema().query(queryRoot).mutation(mutationRoot).codeRegistry(codeRegistry.build()).additionalTypes(new HashSet(CollectionUtils.union(this.connectionObjectRegistry.values(), this.inputObjectRegistry.values()))).build();
        schema = this.enableFederation ? Federation.transform((GraphQLSchema)schema).build() : schema;
        return schema;
    }

    private GraphQLObjectType buildConnectionObject(Type<?> entityClass) {
        if (this.connectionObjectRegistry.containsKey(entityClass)) {
            return this.connectionObjectRegistry.get(entityClass);
        }
        String entityName = this.nameUtils.toConnectionName(entityClass);
        GraphQLObjectType connectionObject = GraphQLObjectType.newObject().name(entityName).field(GraphQLFieldDefinition.newFieldDefinition().name("edges").type((GraphQLOutputType)this.buildEdgesObject(entityClass, (GraphQLOutputType)this.buildQueryObject(entityClass)))).field(GraphQLFieldDefinition.newFieldDefinition().name("pageInfo").type((GraphQLOutputType)this.pageInfoObject)).build();
        this.objectTypes.add(connectionObject);
        this.connectionObjectRegistry.put(entityClass, connectionObject);
        return connectionObject;
    }

    private GraphQLObjectType buildQueryObject(Type<?> entityClass) {
        if (this.queryObjectRegistry.containsKey(entityClass)) {
            return this.queryObjectRegistry.get(entityClass);
        }
        log.trace("Building query object for {}", (Object)entityClass.getName());
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(this.nameUtils.toNodeName(entityClass)).description(EntityDictionary.getEntityDescription(entityClass));
        String id = this.entityDictionary.getIdFieldName(entityClass);
        builder.field(GraphQLFieldDefinition.newFieldDefinition().name(id).type((GraphQLOutputType)GraphQLScalars.GRAPHQL_DEFERRED_ID));
        for (String attribute : this.entityDictionary.getAttributes(entityClass)) {
            Type attributeClass = this.entityDictionary.getType(entityClass, attribute);
            if (this.excludedEntities.contains(attributeClass)) continue;
            log.trace("Building query attribute {} {} with arguments {} for entity {}", new Object[]{attribute, attributeClass.getName(), this.entityDictionary.getAttributeArguments(attributeClass, attribute).toString(), entityClass.getName()});
            GraphQLOutputType attributeType = this.generator.attributeToQueryObject(entityClass, attributeClass, attribute, this.dataFetcher);
            if (attributeType == null) continue;
            builder.field(GraphQLFieldDefinition.newFieldDefinition().name(attribute).arguments(this.generator.attributeArgumentToQueryObject(entityClass, attribute, this.dataFetcher)).type(attributeType));
        }
        for (String relationship : this.entityDictionary.getElideBoundRelationships(entityClass)) {
            Type relationshipClass = this.entityDictionary.getParameterizedType(entityClass, relationship);
            if (this.excludedEntities.contains(relationshipClass)) continue;
            String relationshipEntityName = this.nameUtils.toConnectionName(relationshipClass);
            RelationshipType type = this.entityDictionary.getRelationshipType(entityClass, relationship);
            if (type.isToOne()) {
                builder.field(GraphQLFieldDefinition.newFieldDefinition().name(relationship).argument(this.relationshipOpArg).argument(this.buildInputObjectArgument(relationshipClass, false)).arguments(this.generator.entityArgumentToQueryObject(relationshipClass, this.entityDictionary)).type((GraphQLOutputType)new GraphQLTypeReference(relationshipEntityName)));
                continue;
            }
            builder.field(GraphQLFieldDefinition.newFieldDefinition().name(relationship).argument(this.relationshipOpArg).argument(this.filterArgument).argument(this.sortArgument).argument(this.pageOffsetArgument).argument(this.pageFirstArgument).argument(this.idArgument).argument(this.buildInputObjectArgument(relationshipClass, true)).arguments(this.generator.entityArgumentToQueryObject(relationshipClass, this.entityDictionary)).type((GraphQLOutputType)new GraphQLTypeReference(relationshipEntityName)));
        }
        GraphQLObjectType queryObject = builder.build();
        this.objectTypes.add(queryObject);
        this.queryObjectRegistry.put(entityClass, queryObject);
        return queryObject;
    }

    private GraphQLList buildEdgesObject(Type<?> relationClass, GraphQLOutputType entityType) {
        GraphQLObjectType edgesObject = GraphQLObjectType.newObject().name(this.nameUtils.toEdgesName(relationClass)).field(GraphQLFieldDefinition.newFieldDefinition().name("node").type(entityType)).build();
        this.objectTypes.add(edgesObject);
        return new GraphQLList((GraphQLType)edgesObject);
    }

    private GraphQLArgument buildInputObjectArgument(Type<?> entityClass, boolean asList) {
        GraphQLInputType argumentType = (GraphQLInputType)this.inputObjectRegistry.get(entityClass);
        if (asList) {
            return GraphQLArgument.newArgument().name(ARGUMENT_DATA).type((GraphQLInputType)new GraphQLList((GraphQLType)argumentType)).build();
        }
        return GraphQLArgument.newArgument().name(ARGUMENT_DATA).type(argumentType).build();
    }

    private GraphQLInputType buildInputObjectStub(Type<?> clazz) {
        log.trace("Building input object for {}", (Object)clazz.getName());
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.name(this.nameUtils.toInputTypeName(clazz));
        String id = this.entityDictionary.getIdFieldName(clazz);
        if (id != null) {
            builder.field(GraphQLInputObjectField.newInputObjectField().name(id).type((GraphQLInputType)Scalars.GraphQLID));
        }
        for (String attribute : this.entityDictionary.getAttributes(clazz)) {
            Type attributeClass = this.entityDictionary.getType(clazz, attribute);
            if (this.excludedEntities.contains(attributeClass)) continue;
            log.trace("Building input attribute {} {} for entity {}", new Object[]{attribute, attributeClass.getName(), clazz.getName()});
            GraphQLInputType attributeType = this.generator.attributeToInputObject(clazz, attributeClass, attribute);
            builder.field(GraphQLInputObjectField.newInputObjectField().name(attribute).type(attributeType));
        }
        for (String relationship : this.entityDictionary.getElideBoundRelationships(clazz)) {
            log.trace("Resolving relationship {} for {}", (Object)relationship, (Object)clazz.getName());
            Type relationshipClass = this.entityDictionary.getParameterizedType(clazz, relationship);
            if (this.excludedEntities.contains(relationshipClass)) continue;
            RelationshipType type = this.entityDictionary.getRelationshipType(clazz, relationship);
            String relationshipEntityName = this.nameUtils.toInputTypeName(relationshipClass);
            if (type.isToOne()) {
                builder.field(GraphQLInputObjectField.newInputObjectField().name(relationship).type((GraphQLInputType)new GraphQLTypeReference(relationshipEntityName)).build());
                continue;
            }
            builder.field(GraphQLInputObjectField.newInputObjectField().name(relationship).type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(relationshipEntityName))).build());
        }
        GraphQLInputObjectType constructed = builder.build();
        this.inputObjectRegistry.put(clazz, constructed);
        return constructed;
    }
}

