/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.core.dictionary.EntityBinding;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.DuplicateMappingException;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import java.util.Collections;
import java.util.function.Function;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonEntityDictionary
extends EntityDictionary {
    private static final Logger log = LoggerFactory.getLogger(NonEntityDictionary.class);

    public NonEntityDictionary(ClassScanner scanner, Function<Class, Serde> serdeLookup) {
        super(Collections.emptyMap(), Collections.emptyMap(), DEFAULT_INJECTOR, serdeLookup, Collections.emptySet(), scanner);
    }

    public void bindEntity(Type<?> cls) {
        String type = WordUtils.uncapitalize((String)cls.getSimpleName());
        Type<?> duplicate = this.bindJsonApiToEntity.put(Pair.of((Object)type, (Object)""), cls);
        if (duplicate != null && !duplicate.equals(cls)) {
            log.error("Duplicate binding {} for {}, {}", new Object[]{type, cls, duplicate});
            throw new DuplicateMappingException(type + " " + cls.getName() + ":" + duplicate.getName());
        }
        this.entityBindings.put(cls, new EntityBinding(this.getInjector(), cls, type));
    }
}

