/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.RelationshipOp;
import graphql.language.Field;
import graphql.language.FragmentSpread;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;

public interface QueryLogger {
    default public void logContext(Logger log, RelationshipOp operation, Environment environment) {
        List children = environment.field.getSelectionSet() != null ? environment.field.getSelectionSet().getChildren() : new ArrayList();
        ArrayList fieldName = new ArrayList();
        if (CollectionUtils.isNotEmpty(children)) {
            children.stream().forEach(i -> {
                if (i.getClass().equals(Field.class)) {
                    fieldName.add(((Field)i).getName());
                } else if (i.getClass().equals(FragmentSpread.class)) {
                    fieldName.add(((FragmentSpread)i).getName());
                } else {
                    log.debug("A new type of Selection, other than Field and FragmentSpread was encountered, {}", i.getClass());
                }
            });
        }
        String requestedFields = environment.field.getName() + fieldName;
        GraphQLType parent = environment.parentType;
        if (log.isDebugEnabled()) {
            String typeName = parent instanceof GraphQLNamedType ? ((GraphQLNamedType)parent).getName() : parent.toString();
            log.debug("{} {} fields with parent {}<{}>", new Object[]{operation, requestedFields, EntityDictionary.getSimpleName((Type)EntityDictionary.getType((Object)parent)), typeName});
        }
    }
}

