/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.CustomErrorException;
import com.yahoo.elide.core.exceptions.ErrorObjects;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.ExecutionResultSerializer;
import com.yahoo.elide.graphql.GraphQLErrorSerializer;
import com.yahoo.elide.graphql.GraphQLRequestScope;
import com.yahoo.elide.graphql.ModelBuilder;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.PersistentResourceFetcher;
import com.yahoo.elide.graphql.parser.GraphQLEntityProjectionMaker;
import com.yahoo.elide.graphql.parser.GraphQLProjectionInfo;
import com.yahoo.elide.graphql.parser.GraphQLQuery;
import com.yahoo.elide.graphql.parser.QueryParser;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRunner {
    private static final Logger log = LoggerFactory.getLogger(QueryRunner.class);
    private final Elide elide;
    private GraphQL api;
    private ObjectMapper mapper;
    private String apiVersion;
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String MUTATION = "mutation";

    public QueryRunner(Elide elide, String apiVersion) {
        this.elide = elide;
        this.apiVersion = apiVersion;
        this.mapper = elide.getMapper().getObjectMapper();
        EntityDictionary dictionary = elide.getElideSettings().getDictionary();
        NonEntityDictionary nonEntityDictionary = new NonEntityDictionary(dictionary.getScanner(), dictionary.getSerdeLookup());
        PersistentResourceFetcher fetcher = new PersistentResourceFetcher(nonEntityDictionary);
        ModelBuilder builder = new ModelBuilder(elide.getElideSettings().getDictionary(), nonEntityDictionary, elide.getElideSettings(), fetcher, apiVersion);
        this.api = GraphQL.newGraphQL((GraphQLSchema)builder.build()).queryExecutionStrategy((ExecutionStrategy)new AsyncSerialExecutionStrategy()).build();
        GraphQLErrorSerializer errorSerializer = new GraphQLErrorSerializer();
        SimpleModule module = new SimpleModule("ExecutionResultSerializer", Version.unknownVersion());
        module.addSerializer(ExecutionResult.class, (JsonSerializer)new ExecutionResultSerializer(errorSerializer));
        module.addSerializer(GraphQLError.class, (JsonSerializer)errorSerializer);
        elide.getElideSettings().getMapper().getObjectMapper().registerModule((Module)module);
    }

    public ElideResponse run(String baseUrlEndPoint, String graphQLDocument, User user) {
        return this.run(baseUrlEndPoint, graphQLDocument, user, UUID.randomUUID());
    }

    public static boolean isMutation(String query) {
        if (query == null) {
            return false;
        }
        String[] lines = query.split("\n");
        StringBuilder withoutComments = new StringBuilder();
        for (String line : lines) {
            if (line.matches("^(\\s*)#.*")) continue;
            withoutComments.append(line);
            withoutComments.append("\n");
        }
        query = withoutComments.toString().trim();
        return query.startsWith(MUTATION);
    }

    public static JsonNode getTopLevelNode(ObjectMapper mapper, String graphQLDocument) throws IOException {
        return mapper.readTree(graphQLDocument);
    }

    public ElideResponse run(String baseUrlEndPoint, String graphQLDocument, User user, UUID requestId) {
        return this.run(baseUrlEndPoint, graphQLDocument, user, requestId, null);
    }

    public ElideResponse run(String baseUrlEndPoint, String graphQLDocument, User user, UUID requestId, Map<String, List<String>> requestHeaders) {
        List<GraphQLQuery> queries;
        ObjectMapper mapper = this.elide.getMapper().getObjectMapper();
        try {
            queries = new QueryParser(){}.parseDocument(graphQLDocument, mapper);
        }
        catch (IOException e) {
            log.debug("Invalid json body provided to GraphQL", (Throwable)e);
            return QueryRunner.buildErrorResponse(mapper, (HttpStatusException)new InvalidEntityBodyException(graphQLDocument), false);
        }
        ArrayList<ElideResponse> responses = new ArrayList<ElideResponse>();
        for (GraphQLQuery query : queries) {
            responses.add(this.executeGraphQLRequest(baseUrlEndPoint, mapper, user, graphQLDocument, query, requestId, requestHeaders));
        }
        if (responses.size() == 1) {
            return (ElideResponse)responses.get(0);
        }
        ArrayNode result = responses.stream().map(response -> {
            try {
                return mapper.readTree(response.getBody());
            }
            catch (IOException e) {
                log.debug("Caught an IO exception while trying to read response body");
                return JsonNodeFactory.instance.objectNode();
            }
        }).reduce(JsonNodeFactory.instance.arrayNode(), (arrayNode, node) -> arrayNode.add(node), (left, right) -> left.addAll(right));
        try {
            return ElideResponse.builder().responseCode(200).body(mapper.writeValueAsString((Object)result)).build();
        }
        catch (IOException e) {
            log.error("An unexpected error occurred trying to serialize array response.", (Throwable)e);
            return ElideResponse.builder().responseCode(500).build();
        }
    }

    public static String extractQuery(JsonNode jsonDocument) {
        return jsonDocument.has(QUERY) ? jsonDocument.get(QUERY).asText() : null;
    }

    public static Map<String, Object> extractVariables(ObjectMapper mapper, JsonNode jsonDocument) {
        Map<String, Object> variables = new HashMap<String, Object>();
        if (jsonDocument.has(VARIABLES) && !jsonDocument.get(VARIABLES).isNull()) {
            variables = (Map)mapper.convertValue((Object)jsonDocument.get(VARIABLES), Map.class);
        }
        return variables;
    }

    public static String extractOperation(JsonNode jsonDocument) {
        if (jsonDocument.has(OPERATION_NAME) && !jsonDocument.get(OPERATION_NAME).isNull()) {
            return jsonDocument.get(OPERATION_NAME).asText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElideResponse executeGraphQLRequest(String baseUrlEndPoint, ObjectMapper mapper, User principal, String graphQLDocument, GraphQLQuery query, UUID requestId, Map<String, List<String>> requestHeaders) {
        boolean isVerbose = false;
        String queryText = query.getQuery();
        boolean isMutation = QueryRunner.isMutation(queryText);
        try {
            ElideResponse elideResponse;
            block21: {
                DataStoreTransaction tx;
                block19: {
                    ElideResponse elideResponse2;
                    block20: {
                        tx = isMutation ? this.elide.getDataStore().beginTransaction() : this.elide.getDataStore().beginReadTransaction();
                        try {
                            this.elide.getTransactionRegistry().addRunningTransaction(requestId, tx);
                            if (query.getQuery() != null && !query.getQuery().isEmpty()) break block19;
                            elideResponse2 = ElideResponse.builder().responseCode(400).body("A `query` key is required.").build();
                            if (tx == null) break block20;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (tx != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                ElideResponse elideResponse3 = QueryRunner.handleNonRuntimeException(this.elide, e, graphQLDocument, isVerbose);
                                return elideResponse3;
                            }
                            catch (RuntimeException e) {
                                ElideResponse elideResponse4 = QueryRunner.handleRuntimeException(this.elide, e, isVerbose);
                                return elideResponse4;
                            }
                        }
                        tx.close();
                    }
                    return elideResponse2;
                }
                Map<String, Object> variables = query.getVariables();
                GraphQLProjectionInfo projectionInfo = new GraphQLEntityProjectionMaker(this.elide.getElideSettings(), variables, this.apiVersion).make(queryText);
                GraphQLRequestScope requestScope = new GraphQLRequestScope(baseUrlEndPoint, tx, principal, this.apiVersion, this.elide.getElideSettings(), projectionInfo, requestId, requestHeaders);
                isVerbose = requestScope.getPermissionExecutor().isVerbose();
                log.info("Processing GraphQL query:\n{}", (Object)queryText);
                ExecutionInput.Builder executionInput = new ExecutionInput.Builder().localContext((Object)requestScope).query(queryText);
                if (query.getOperationName() != null) {
                    executionInput.operationName(query.getOperationName());
                }
                executionInput.variables(variables);
                ExecutionResult result = this.api.execute(executionInput);
                tx.preCommit((RequestScope)requestScope);
                requestScope.getPermissionExecutor().executeCommitChecks();
                if (isMutation) {
                    if (!result.getErrors().isEmpty()) {
                        HashMap<String, List> abortedResponseObject = new HashMap<String, List>();
                        abortedResponseObject.put("errors", result.getErrors());
                        abortedResponseObject.put("data", null);
                        throw new WebApplicationException(Response.ok((Object)mapper.writeValueAsString(abortedResponseObject)).build());
                    }
                    requestScope.saveOrCreateObjects();
                }
                tx.flush((RequestScope)requestScope);
                requestScope.runQueuedPreCommitTriggers();
                this.elide.getAuditLogger().commit();
                tx.commit((RequestScope)requestScope);
                requestScope.runQueuedPostCommitTriggers();
                if (log.isTraceEnabled()) {
                    requestScope.getPermissionExecutor().logCheckStats();
                }
                elideResponse = ElideResponse.builder().responseCode(200).body(mapper.writeValueAsString((Object)result)).build();
                if (tx == null) break block21;
                tx.close();
            }
            return elideResponse;
        }
        finally {
            this.elide.getTransactionRegistry().removeRunningTransaction(requestId);
            this.elide.getAuditLogger().clear();
        }
    }

    public static ElideResponse handleNonRuntimeException(Elide elide, Exception error, String graphQLDocument, boolean isVerbose) {
        CustomErrorException mappedException = elide.mapError(error);
        ObjectMapper mapper = elide.getMapper().getObjectMapper();
        if (mappedException != null) {
            return QueryRunner.buildErrorResponse(mapper, (HttpStatusException)mappedException, isVerbose);
        }
        if (error instanceof JsonProcessingException) {
            log.debug("Invalid json body provided to GraphQL", (Throwable)error);
            return QueryRunner.buildErrorResponse(mapper, (HttpStatusException)new InvalidEntityBodyException(graphQLDocument), isVerbose);
        }
        if (error instanceof IOException) {
            log.error("Uncaught IO Exception by Elide in GraphQL", (Throwable)error);
            return QueryRunner.buildErrorResponse(mapper, (HttpStatusException)new TransactionException((Throwable)error), isVerbose);
        }
        log.error("Error or exception uncaught by Elide", (Throwable)error);
        throw new RuntimeException(error);
    }

    public static ElideResponse handleRuntimeException(Elide elide, RuntimeException error, boolean isVerbose) {
        CustomErrorException mappedException = elide.mapError((Exception)error);
        ObjectMapper mapper = elide.getMapper().getObjectMapper();
        if (mappedException != null) {
            return QueryRunner.buildErrorResponse(mapper, (HttpStatusException)mappedException, isVerbose);
        }
        if (error instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)error;
            log.debug("WebApplicationException", (Throwable)e);
            String body = e.getResponse().getEntity() != null ? e.getResponse().getEntity().toString() : e.getMessage();
            return ElideResponse.builder().responseCode(e.getResponse().getStatus()).body(body).build();
        }
        if (error instanceof HttpStatusException) {
            final HttpStatusException e = (HttpStatusException)error;
            if (e instanceof ForbiddenAccessException) {
                if (log.isDebugEnabled()) {
                    log.debug("{}", (Object)((ForbiddenAccessException)e).getLoggedMessage());
                }
            } else {
                log.debug("Caught HTTP status exception {}", (Object)e.getStatus(), (Object)e);
            }
            return QueryRunner.buildErrorResponse(mapper, new HttpStatusException(200, e.getMessage()){

                public int getStatus() {
                    return 200;
                }

                public Pair<Integer, JsonNode> getErrorResponse() {
                    return e.getErrorResponse();
                }

                public Pair<Integer, JsonNode> getVerboseErrorResponse() {
                    return e.getVerboseErrorResponse();
                }

                public String getVerboseMessage() {
                    return e.getVerboseMessage();
                }

                public String toString() {
                    return e.toString();
                }
            }, isVerbose);
        }
        if (error instanceof ConstraintViolationException) {
            ConstraintViolationException e = (ConstraintViolationException)error;
            log.debug("Constraint violation exception caught", (Throwable)e);
            String message = "Constraint violation";
            ErrorObjects.ErrorObjectsBuilder errorObjectsBuilder = ErrorObjects.builder();
            for (ConstraintViolation constraintViolation : e.getConstraintViolations()) {
                errorObjectsBuilder.addError().withDetail(constraintViolation.getMessage());
                String propertyPathString = constraintViolation.getPropertyPath().toString();
                if (propertyPathString.isEmpty()) continue;
                HashMap<String, String> source = new HashMap<String, String>(1);
                source.put("property", propertyPathString);
                errorObjectsBuilder.with("source", source);
            }
            return QueryRunner.buildErrorResponse(mapper, (HttpStatusException)new CustomErrorException(200, message, errorObjectsBuilder.build()), isVerbose);
        }
        log.error("Error or exception uncaught by Elide", (Throwable)error);
        throw new RuntimeException(error);
    }

    public static ElideResponse buildErrorResponse(ObjectMapper mapper, HttpStatusException error, boolean isVerbose) {
        String errorBody;
        JsonNode errorNode;
        if (!(error instanceof CustomErrorException)) {
            String errorMessage = isVerbose ? error.getVerboseMessage() : error.getMessage();
            errorMessage = Encode.forHtml((String)errorMessage);
            ErrorObjects errors = ErrorObjects.builder().addError().with("message", (Object)errorMessage).build();
            errorNode = (JsonNode)mapper.convertValue((Object)errors, JsonNode.class);
        } else {
            errorNode = isVerbose ? (JsonNode)error.getVerboseErrorResponse().getRight() : (JsonNode)error.getErrorResponse().getRight();
        }
        try {
            errorBody = mapper.writeValueAsString((Object)errorNode);
        }
        catch (JsonProcessingException e) {
            errorBody = errorNode.toString();
        }
        return ElideResponse.builder().responseCode(error.getStatus()).body(errorBody).build();
    }

    public Elide getElide() {
        return this.elide;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

