/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.parser;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.dictionary.ArgumentType;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.graphql.FilterDialect;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.PaginationImpl;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.sort.SortingImpl;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.graphql.GraphQLNameUtils;
import com.yahoo.elide.graphql.KeyWord;
import com.yahoo.elide.graphql.parser.FragmentResolver;
import com.yahoo.elide.graphql.parser.GraphQLProjectionInfo;
import com.yahoo.elide.graphql.parser.VariableResolver;
import graphql.language.Argument;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.SourceLocation;
import graphql.parser.Parser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLEntityProjectionMaker {
    private static final Logger log = LoggerFactory.getLogger(GraphQLEntityProjectionMaker.class);
    protected final ElideSettings elideSettings;
    protected final EntityDictionary entityDictionary;
    protected final FilterDialect filterDialect;
    protected final VariableResolver variableResolver;
    protected final FragmentResolver fragmentResolver;
    protected final Map<SourceLocation, Relationship> relationshipMap = new HashMap<SourceLocation, Relationship>();
    protected final Map<String, EntityProjection> rootProjections = new HashMap<String, EntityProjection>();
    protected final Map<SourceLocation, Attribute> attributeMap = new HashMap<SourceLocation, Attribute>();
    protected final GraphQLNameUtils nameUtils;
    protected final String apiVersion;

    public GraphQLEntityProjectionMaker(ElideSettings elideSettings, Map<String, Object> variables, String apiVersion) {
        this.elideSettings = elideSettings;
        this.entityDictionary = elideSettings.getDictionary();
        this.filterDialect = elideSettings.getGraphqlDialect();
        this.variableResolver = new VariableResolver(variables);
        this.fragmentResolver = new FragmentResolver();
        this.nameUtils = new GraphQLNameUtils(this.entityDictionary);
        this.apiVersion = apiVersion;
    }

    public GraphQLEntityProjectionMaker(ElideSettings elideSettings) {
        this(elideSettings, new HashMap<String, Object>(), "");
    }

    public GraphQLProjectionInfo make(String query) {
        Document parsedDocument;
        Parser parser = new Parser();
        try {
            parsedDocument = parser.parseDocument(query);
        }
        catch (Exception e) {
            throw new InvalidEntityBodyException("Can't parse query: " + query);
        }
        this.fragmentResolver.addFragments(parsedDocument);
        parsedDocument.getDefinitions().forEach(definition -> {
            if (definition instanceof OperationDefinition) {
                OperationDefinition operationDefinition = (OperationDefinition)definition;
                if (!this.supportsOperationType(operationDefinition.getOperation())) {
                    return;
                }
                this.variableResolver.newScope(operationDefinition);
                this.addRootProjection(operationDefinition.getSelectionSet());
            } else if (!(definition instanceof FragmentDefinition)) {
                throw new InvalidEntityBodyException(String.format("Unsupported definition type {%s}.", definition.getClass()));
            }
        });
        return new GraphQLProjectionInfo(this.rootProjections, this.relationshipMap, this.attributeMap);
    }

    private void addRootProjection(SelectionSet selectionSet) {
        List selections = selectionSet.getSelections();
        selections.stream().forEach(rootSelection -> {
            if (!(rootSelection instanceof Field)) {
                throw new InvalidEntityBodyException("Entity selection must be a graphQL field.");
            }
            Field rootSelectionField = (Field)rootSelection;
            String entityName = rootSelectionField.getName();
            String aliasName = rootSelectionField.getAlias();
            if ("_service".equals(entityName) || KeyWord.SCHEMA.hasName(entityName) || KeyWord.TYPE.hasName(entityName)) {
                return;
            }
            Type<?> entityType = this.getRootEntity(rootSelectionField.getName(), this.apiVersion);
            if (entityType == null) {
                throw new InvalidEntityBodyException(String.format("Unknown entity {%s}.", rootSelectionField.getName()));
            }
            String keyName = GraphQLProjectionInfo.computeProjectionKey(aliasName, entityName);
            if (this.rootProjections.containsKey(keyName)) {
                throw new InvalidEntityBodyException(String.format("Found two root level query for Entity {%s} with same alias name", entityName));
            }
            this.rootProjections.put(keyName, this.createProjection(entityType, rootSelectionField));
        });
    }

    private EntityProjection createProjection(Type<?> entityType, Field entityField) {
        EntityProjection.EntityProjectionBuilder projectionBuilder = EntityProjection.builder().type(entityType).pagination(this.getDefaultPagination(entityType));
        projectionBuilder.arguments(new HashSet<com.yahoo.elide.core.request.Argument>(this.getArguments(entityField, this.entityDictionary.getEntityArguments(entityType))));
        if (entityField.getSelectionSet() != null) {
            entityField.getSelectionSet().getSelections().forEach(selection -> this.addSelection((Selection)selection, projectionBuilder));
        }
        if (entityField.getArguments() != null) {
            entityField.getArguments().forEach(argument -> this.addArgument((Argument)argument, projectionBuilder));
        }
        return projectionBuilder.build();
    }

    private void addSelection(Selection fieldSelection, EntityProjection.EntityProjectionBuilder projectionBuilder) {
        if (fieldSelection instanceof FragmentSpread) {
            this.addFragment((FragmentSpread)fieldSelection, projectionBuilder);
        } else if (fieldSelection instanceof Field) {
            if (KeyWord.EDGES.hasName(((Field)fieldSelection).getName()) || KeyWord.NODE.hasName(((Field)fieldSelection).getName())) {
                ((Field)fieldSelection).getSelectionSet().getSelections().forEach(selection -> this.addSelection((Selection)selection, projectionBuilder));
            } else {
                this.addField((Field)fieldSelection, projectionBuilder);
            }
        } else {
            throw new InvalidEntityBodyException(String.format("Unsupported selection type {%s}.", fieldSelection.getClass()));
        }
    }

    private void addFragment(FragmentSpread fragment, EntityProjection.EntityProjectionBuilder projectionBuilder) {
        String fragmentName = fragment.getName();
        FragmentDefinition fragmentDefinition = this.fragmentResolver.get(fragmentName);
        String fragmentTypeName = fragmentDefinition.getTypeCondition().getName();
        if (fragmentTypeName.equals(this.nameUtils.toConnectionName(projectionBuilder.getType())) || fragmentTypeName.equals(this.nameUtils.toEdgesName(projectionBuilder.getType())) || fragmentTypeName.equals(this.nameUtils.toNodeName(projectionBuilder.getType()))) {
            fragmentDefinition.getSelectionSet().getSelections().forEach(selection -> this.addSelection((Selection)selection, projectionBuilder));
        }
    }

    private void addField(Field field, EntityProjection.EntityProjectionBuilder projectionBuilder) {
        String fieldName;
        Type parentType = projectionBuilder.getType();
        if (this.entityDictionary.getRelationshipType(parentType, fieldName = field.getName()) != RelationshipType.NONE) {
            this.addRelationship(field, projectionBuilder);
        } else if (!KeyWord.TYPENAME.hasName(fieldName)) {
            if (KeyWord.PAGE_INFO.hasName(fieldName)) {
                if (field.getSelectionSet().getSelections().stream().anyMatch(selection -> selection instanceof Field && KeyWord.PAGE_INFO_TOTAL_RECORDS.hasName(((Field)selection).getName()))) {
                    this.addPageTotal(projectionBuilder);
                }
            } else {
                this.addAttributeField(field, projectionBuilder);
            }
        }
    }

    private void addRelationship(Field relationshipField, EntityProjection.EntityProjectionBuilder projectionBuilder) {
        Type parentType = projectionBuilder.getType();
        String relationshipName = relationshipField.getName();
        String relationshipAlias = relationshipField.getAlias() == null ? relationshipName : relationshipField.getAlias();
        Type relationshipType = this.entityDictionary.getParameterizedType(parentType, relationshipName);
        EntityProjection relationshipProjection = this.createProjection(relationshipType, relationshipField);
        Relationship relationship = Relationship.builder().name(relationshipName).alias(relationshipAlias).projection(relationshipProjection).build();
        this.relationshipMap.put(relationshipField.getSourceLocation(), relationship);
        projectionBuilder.relationship(relationship);
    }

    private void addAttributeField(Field attributeField, EntityProjection.EntityProjectionBuilder projectionBuilder) {
        Type parentType = projectionBuilder.getType();
        String attributeName = attributeField.getName();
        String attributeAlias = attributeField.getAlias() == null ? attributeName : attributeField.getAlias();
        Type attributeType = this.entityDictionary.getType(parentType, attributeName);
        if (attributeType == null) {
            throw new InvalidEntityBodyException(String.format("Unknown attribute field {%s.%s}.", this.entityDictionary.getJsonAliasFor(projectionBuilder.getType()), attributeName));
        }
        Attribute attribute = Attribute.builder().type(attributeType).name(attributeName).alias(attributeAlias).arguments(this.getArguments(attributeField, this.entityDictionary.getAttributeArguments(parentType, attributeName))).build();
        projectionBuilder.attribute(attribute);
        this.attributeMap.put(attributeField.getSourceLocation(), attribute);
    }

    private void addArgument(Argument argument, EntityProjection.EntityProjectionBuilder projectionBuilder) {
        Type entityType;
        Type attributeType;
        String argumentName = argument.getName();
        if (GraphQLEntityProjectionMaker.isPaginationArgument(argumentName)) {
            this.addPagination(argument, projectionBuilder);
        } else if (GraphQLEntityProjectionMaker.isSortingArgument(argumentName)) {
            this.addSorting(argument, projectionBuilder);
        } else if ("filter".equals(argumentName)) {
            this.addFilter(argument, projectionBuilder);
        } else if (!("op".equals(argumentName) || "ids".equals(argumentName) || "data".equals(argumentName) || GraphQLEntityProjectionMaker.isEntityArgument(argumentName, this.entityDictionary, projectionBuilder.getType()) || (attributeType = this.entityDictionary.getType(entityType = projectionBuilder.getType(), argumentName)) != null)) {
            throw new InvalidEntityBodyException(String.format("Invalid attribute field/alias for argument: {%s}.{%s}", entityType, argumentName));
        }
    }

    private static boolean isEntityArgument(String argumentName, EntityDictionary dictionary, Type<?> cls) {
        return dictionary.getEntityArguments(cls).stream().anyMatch(a -> a.getName().equals(argumentName));
    }

    private static boolean isPaginationArgument(String argumentName) {
        return "first".equals(argumentName) || "after".equals(argumentName);
    }

    private void addPagination(Argument argument, EntityProjection.EntityProjectionBuilder projectionBuilder) {
        int value;
        Pagination pagination = projectionBuilder.getPagination() == null ? PaginationImpl.getDefaultPagination((Type)projectionBuilder.getType(), (ElideSettings)this.elideSettings) : projectionBuilder.getPagination();
        Object argumentValue = this.variableResolver.resolveValue(argument.getValue());
        int n = value = argumentValue instanceof BigInteger ? ((BigInteger)argumentValue).intValue() : Integer.parseInt((String)argumentValue);
        if ("first".equals(argument.getName())) {
            pagination = new PaginationImpl(projectionBuilder.getType(), Integer.valueOf(pagination.getOffset()), Integer.valueOf(value), this.elideSettings.getDefaultPageSize(), this.elideSettings.getDefaultMaxPageSize(), Boolean.valueOf(pagination.returnPageTotals()), Boolean.valueOf(false));
        } else if ("after".equals(argument.getName())) {
            pagination = new PaginationImpl(projectionBuilder.getType(), Integer.valueOf(value), Integer.valueOf(pagination.getLimit()), this.elideSettings.getDefaultPageSize(), this.elideSettings.getDefaultMaxPageSize(), Boolean.valueOf(pagination.returnPageTotals()), Boolean.valueOf(false));
        }
        projectionBuilder.pagination(pagination);
    }

    private void addPageTotal(EntityProjection.EntityProjectionBuilder projectionBuilder) {
        PaginationImpl pagination = projectionBuilder.getPagination() == null ? new PaginationImpl(projectionBuilder.getType(), null, null, this.elideSettings.getDefaultPageSize(), this.elideSettings.getDefaultMaxPageSize(), Boolean.valueOf(true), Boolean.valueOf(false)) : new PaginationImpl(projectionBuilder.getType(), Integer.valueOf(projectionBuilder.getPagination().getOffset()), Integer.valueOf(projectionBuilder.getPagination().getLimit()), this.elideSettings.getDefaultPageSize(), this.elideSettings.getDefaultMaxPageSize(), Boolean.valueOf(true), Boolean.valueOf(false));
        projectionBuilder.pagination((Pagination)pagination);
    }

    private static boolean isSortingArgument(String argumentName) {
        return "sort".equals(argumentName);
    }

    private void addSorting(Argument argument, EntityProjection.EntityProjectionBuilder projectionBuilder) {
        String sortRule = (String)this.variableResolver.resolveValue(argument.getValue());
        try {
            Sorting sorting = SortingImpl.parseSortRule((String)sortRule, (Type)projectionBuilder.getType(), (Set)projectionBuilder.getAttributes(), (EntityDictionary)this.entityDictionary);
            projectionBuilder.sorting(sorting);
        }
        catch (InvalidValueException e) {
            throw new BadRequestException("Invalid sorting clause " + sortRule + " for type " + this.entityDictionary.getJsonAliasFor(projectionBuilder.getType()));
        }
    }

    private void addFilter(Argument argument, EntityProjection.EntityProjectionBuilder projectionBuilder) {
        FilterExpression filter = this.buildFilter(projectionBuilder, this.entityDictionary.getJsonAliasFor(projectionBuilder.getType()), this.variableResolver.resolveValue(argument.getValue()));
        if (projectionBuilder.getFilterExpression() != null) {
            projectionBuilder.filterExpression((FilterExpression)new AndFilterExpression(projectionBuilder.getFilterExpression(), filter));
        } else {
            projectionBuilder.filterExpression(filter);
        }
    }

    private FilterExpression buildFilter(EntityProjection.EntityProjectionBuilder builder, String typeName, Object filterString) {
        if (!(filterString instanceof String)) {
            throw new BadRequestException("Filter of type " + typeName + " is not StringValue.");
        }
        try {
            return this.filterDialect.parse(builder.getType(), builder.getAttributes(), (String)filterString, this.apiVersion);
        }
        catch (ParseException e) {
            throw new BadRequestException(e.getMessage() + "\n" + e.getMessage());
        }
    }

    private List<com.yahoo.elide.core.request.Argument> getArguments(Field attributeField, Set<ArgumentType> availableArguments) {
        ArrayList<com.yahoo.elide.core.request.Argument> arguments = new ArrayList<com.yahoo.elide.core.request.Argument>();
        availableArguments.forEach(argumentType -> {
            Optional<Argument> clientArgument = attributeField.getArguments().stream().filter(arg -> arg.getName().equals(argumentType.getName())).findFirst();
            if (clientArgument.isPresent()) {
                arguments.add(com.yahoo.elide.core.request.Argument.builder().name(clientArgument.get().getName()).value(this.variableResolver.resolveValue(clientArgument.get().getValue(), Optional.of(argumentType.getType()))).build());
            } else if (argumentType.getDefaultValue() != null) {
                arguments.add(com.yahoo.elide.core.request.Argument.builder().name(argumentType.getName()).value(argumentType.getDefaultValue()).build());
            }
        });
        return arguments;
    }

    protected Type<?> getRootEntity(String entityName, String apiVersion) {
        return this.entityDictionary.getEntityClass(entityName, apiVersion);
    }

    protected boolean supportsOperationType(OperationDefinition.Operation operation) {
        return operation != OperationDefinition.Operation.SUBSCRIPTION;
    }

    protected Pagination getDefaultPagination(Type<?> entityType) {
        return PaginationImpl.getDefaultPagination(entityType, (ElideSettings)this.elideSettings);
    }
}

