/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.parser;

import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import graphql.language.SourceLocation;
import java.util.Map;

public class GraphQLProjectionInfo {
    private final Map<String, EntityProjection> projections;
    private final Map<SourceLocation, Relationship> relationshipMap;
    private final Map<SourceLocation, Attribute> attributeMap;

    public EntityProjection getProjection(String aliasName, String entityName) {
        return this.projections.get(GraphQLProjectionInfo.computeProjectionKey(aliasName, entityName));
    }

    public static String computeProjectionKey(String aliasName, String entityName) {
        return (aliasName == null ? "" : aliasName) + ":" + entityName;
    }

    public GraphQLProjectionInfo(Map<String, EntityProjection> projections, Map<SourceLocation, Relationship> relationshipMap, Map<SourceLocation, Attribute> attributeMap) {
        this.projections = projections;
        this.relationshipMap = relationshipMap;
        this.attributeMap = attributeMap;
    }

    public Map<String, EntityProjection> getProjections() {
        return this.projections;
    }

    public Map<SourceLocation, Relationship> getRelationshipMap() {
        return this.relationshipMap;
    }

    public Map<SourceLocation, Attribute> getAttributeMap() {
        return this.attributeMap;
    }
}

