/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.parser;

import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class VariableResolver {
    private final Map<String, Object> requestVariables;
    private final Map<String, Object> scopeVariables = new HashMap<String, Object>();

    VariableResolver(Map<String, Object> variables) {
        this.requestVariables = new HashMap<String, Object>(variables);
    }

    public void newScope(OperationDefinition operation) {
        this.scopeVariables.clear();
        this.scopeVariables.putAll(this.requestVariables);
        operation.getVariableDefinitions().forEach(this::addVariable);
    }

    private void addVariable(VariableDefinition definition) {
        graphql.language.Type variableType = definition.getType();
        String variableName = definition.getName();
        Value defaultValue = definition.getDefaultValue();
        if (defaultValue == null) {
            if (variableType instanceof NonNullType && this.scopeVariables.get(variableName) == null) {
                throw new BadRequestException("Undefined non-null variable " + variableName);
            }
            this.scopeVariables.put(variableName, this.scopeVariables.get(variableName));
        } else if (!this.scopeVariables.containsKey(variableName)) {
            this.scopeVariables.put(variableName, this.resolveValue(defaultValue));
        }
    }

    public Object resolveValue(Value value) {
        return this.resolveValue(value, Optional.empty());
    }

    public Object resolveValue(Value value, Optional<Type<?>> resolveTo) {
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof EnumValue) {
            if (resolveTo.isPresent()) {
                return CoerceUtil.coerce((Object)((EnumValue)value).getName().toUpperCase(Locale.ROOT), resolveTo.get());
            }
            throw new BadRequestException("Enum value is not supported.");
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue();
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof NullValue) {
            return null;
        }
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        if (value instanceof ObjectValue) {
            return ((ObjectValue)value).getObjectFields().stream().collect(Collectors.toMap(ObjectField::getName, ObjectField::getValue));
        }
        if (value instanceof ArrayValue) {
            return ((ArrayValue)value).getValues().stream().map(this::resolveValue).collect(Collectors.toList());
        }
        if (value instanceof VariableReference) {
            String variableName = ((VariableReference)value).getName();
            if (!this.scopeVariables.containsKey(variableName)) {
                throw new BadRequestException("Can't resolve variable reference " + variableName);
            }
            return this.scopeVariables.get(variableName);
        }
        throw new BadRequestException("Unknown variable value type " + value.getClass());
    }
}

