/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.QueryLogger;
import com.yahoo.elide.graphql.RelationshipOp;
import com.yahoo.elide.graphql.subscriptions.containers.SubscriptionNodeContainer;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionDataFetcher
implements DataFetcher<Object>,
QueryLogger {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionDataFetcher.class);
    private final NonEntityDictionary nonEntityDictionary;
    private final Integer bufferSize;

    public SubscriptionDataFetcher(NonEntityDictionary nonEntityDictionary) {
        this(nonEntityDictionary, 100);
    }

    public SubscriptionDataFetcher(NonEntityDictionary nonEntityDictionary, int bufferSize) {
        this.nonEntityDictionary = nonEntityDictionary;
        this.bufferSize = bufferSize;
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        OperationDefinition.Operation op = environment.getOperationDefinition().getOperation();
        if (op != OperationDefinition.Operation.SUBSCRIPTION) {
            throw new InvalidEntityBodyException(String.format("%s not supported for subscription models.", op));
        }
        Environment context = new Environment(environment, this.nonEntityDictionary);
        if (log.isDebugEnabled()) {
            this.logContext(log, RelationshipOp.FETCH, context);
        }
        if (context.isRoot()) {
            String entityName = context.field.getName();
            String aliasName = context.field.getAlias();
            EntityProjection projection = context.requestScope.getProjectionInfo().getProjection(aliasName, entityName);
            Flowable recordPublisher = PersistentResource.loadRecords((EntityProjection)projection, new ArrayList(), (RequestScope)context.requestScope).toFlowable(BackpressureStrategy.BUFFER).onBackpressureBuffer(this.bufferSize.intValue(), true, false);
            return recordPublisher.map(SubscriptionNodeContainer::new);
        }
        return context.container.processFetch(context);
    }
}

