/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions.hooks;

import com.google.gson.Gson;
import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.lifecycle.CRUDEvent;
import com.yahoo.elide.core.lifecycle.LifeCycleHook;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.RequestScope;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.graphql.subscriptions.hooks.TopicType;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyTopicLifeCycleHook<T>
implements LifeCycleHook<T> {
    private static final Logger log = LoggerFactory.getLogger(NotifyTopicLifeCycleHook.class);
    @Inject
    private ConnectionFactory connectionFactory;
    @Inject
    private Function<JMSContext, JMSProducer> createProducer;
    private Gson gson;

    public NotifyTopicLifeCycleHook(ConnectionFactory connectionFactory, Function<JMSContext, JMSProducer> createProducer, Gson gson) {
        this.connectionFactory = connectionFactory;
        this.createProducer = createProducer;
        this.gson = gson;
    }

    public void execute(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, CRUDEvent event) {
        PersistentResource resource = (PersistentResource)event.getResource();
        Type modelType = resource.getResourceType();
        TopicType topicType = TopicType.fromOperation(operation);
        String topicName = topicType.toTopicName(modelType, resource.getDictionary());
        this.publish(resource.getObject(), topicName);
    }

    public void execute(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, T elideEntity, RequestScope requestScope, Optional<ChangeSpec> changes) {
    }

    public void publish(T object, String topicName) {
        try (JMSContext context = this.connectionFactory.createContext();){
            JMSProducer producer = this.createProducer.apply(context);
            Topic destination = context.createTopic(topicName);
            String message = this.gson.toJson(object);
            log.debug("Serializing {}", (Object)message);
            producer.send((Destination)destination, message);
        }
    }

    public NotifyTopicLifeCycleHook() {
    }
}

