/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions.hooks;

import com.google.common.base.Preconditions;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.graphql.subscriptions.annotations.Subscription;
import com.yahoo.elide.graphql.subscriptions.annotations.SubscriptionField;
import com.yahoo.elide.graphql.subscriptions.hooks.NotifyTopicLifeCycleHook;
import com.yahoo.elide.graphql.subscriptions.hooks.SubscriptionExclusionStrategy;
import com.yahoo.elide.graphql.subscriptions.hooks.SubscriptionFieldSerde;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;

public class SubscriptionScanner {
    private ConnectionFactory connectionFactory;
    private EntityDictionary dictionary;
    private ClassScanner scanner;
    private long timeToLive;
    private int deliveryMode;
    private long deliveryDelay;
    private int messagePriority;

    public void bindLifecycleHooks() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        CoerceUtil.getSerdes().forEach((cls, serde) -> gsonBuilder.registerTypeAdapter((Type)cls, new SubscriptionFieldSerde(serde)));
        gsonBuilder.addSerializationExclusionStrategy((ExclusionStrategy)new SubscriptionExclusionStrategy()).serializeNulls();
        Gson gson = gsonBuilder.create();
        Function<JMSContext, JMSProducer> producerFactory = context -> {
            JMSProducer producer = context.createProducer();
            producer.setTimeToLive(this.timeToLive);
            producer.setDeliveryMode(this.deliveryMode);
            producer.setDeliveryDelay(this.deliveryDelay);
            producer.setPriority(this.messagePriority);
            return producer;
        };
        this.scanner.getAnnotatedClasses(new Class[]{Subscription.class}).forEach(modelType -> {
            Subscription.Operation[] operations;
            Subscription subscription = modelType.getAnnotation(Subscription.class);
            Preconditions.checkNotNull((Object)subscription);
            block5: for (Subscription.Operation operation : operations = subscription.operations()) {
                switch (operation) {
                    case UPDATE: {
                        this.addUpdateHooks((com.yahoo.elide.core.type.Type<?>)ClassType.of((Class)modelType), this.dictionary, producerFactory, gson);
                        continue block5;
                    }
                    case DELETE: {
                        this.dictionary.bindTrigger(modelType, LifeCycleHookBinding.Operation.DELETE, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, new NotifyTopicLifeCycleHook(this.connectionFactory, producerFactory, gson), false);
                        continue block5;
                    }
                    case CREATE: {
                        this.dictionary.bindTrigger(modelType, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, new NotifyTopicLifeCycleHook(this.connectionFactory, producerFactory, gson), false);
                    }
                }
            }
        });
    }

    protected void addUpdateHooks(com.yahoo.elide.core.type.Type<?> model, EntityDictionary dictionary, Function<JMSContext, JMSProducer> producerFactory, Gson gson) {
        dictionary.getAllExposedFields(model).stream().forEach(fieldName -> {
            SubscriptionField subscriptionField = (SubscriptionField)dictionary.getAttributeOrRelationAnnotation(model, SubscriptionField.class, fieldName);
            if (subscriptionField != null) {
                dictionary.bindTrigger(model, fieldName, LifeCycleHookBinding.Operation.UPDATE, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, new NotifyTopicLifeCycleHook(this.connectionFactory, producerFactory, gson));
            }
        });
    }

    private static long $default$timeToLive() {
        return 0L;
    }

    private static int $default$deliveryMode() {
        return 2;
    }

    private static long $default$deliveryDelay() {
        return 0L;
    }

    private static int $default$messagePriority() {
        return 4;
    }

    SubscriptionScanner(ConnectionFactory connectionFactory, EntityDictionary dictionary, ClassScanner scanner, long timeToLive, int deliveryMode, long deliveryDelay, int messagePriority) {
        this.connectionFactory = connectionFactory;
        this.dictionary = dictionary;
        this.scanner = scanner;
        this.timeToLive = timeToLive;
        this.deliveryMode = deliveryMode;
        this.deliveryDelay = deliveryDelay;
        this.messagePriority = messagePriority;
    }

    public static SubscriptionScannerBuilder builder() {
        return new SubscriptionScannerBuilder();
    }

    public static class SubscriptionScannerBuilder {
        private ConnectionFactory connectionFactory;
        private EntityDictionary dictionary;
        private ClassScanner scanner;
        private boolean timeToLive$set;
        private long timeToLive$value;
        private boolean deliveryMode$set;
        private int deliveryMode$value;
        private boolean deliveryDelay$set;
        private long deliveryDelay$value;
        private boolean messagePriority$set;
        private int messagePriority$value;

        SubscriptionScannerBuilder() {
        }

        public SubscriptionScannerBuilder connectionFactory(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            return this;
        }

        public SubscriptionScannerBuilder dictionary(EntityDictionary dictionary) {
            this.dictionary = dictionary;
            return this;
        }

        public SubscriptionScannerBuilder scanner(ClassScanner scanner) {
            this.scanner = scanner;
            return this;
        }

        public SubscriptionScannerBuilder timeToLive(long timeToLive) {
            this.timeToLive$value = timeToLive;
            this.timeToLive$set = true;
            return this;
        }

        public SubscriptionScannerBuilder deliveryMode(int deliveryMode) {
            this.deliveryMode$value = deliveryMode;
            this.deliveryMode$set = true;
            return this;
        }

        public SubscriptionScannerBuilder deliveryDelay(long deliveryDelay) {
            this.deliveryDelay$value = deliveryDelay;
            this.deliveryDelay$set = true;
            return this;
        }

        public SubscriptionScannerBuilder messagePriority(int messagePriority) {
            this.messagePriority$value = messagePriority;
            this.messagePriority$set = true;
            return this;
        }

        public SubscriptionScanner build() {
            long timeToLive$value = this.timeToLive$value;
            if (!this.timeToLive$set) {
                timeToLive$value = SubscriptionScanner.$default$timeToLive();
            }
            int deliveryMode$value = this.deliveryMode$value;
            if (!this.deliveryMode$set) {
                deliveryMode$value = SubscriptionScanner.$default$deliveryMode();
            }
            long deliveryDelay$value = this.deliveryDelay$value;
            if (!this.deliveryDelay$set) {
                deliveryDelay$value = SubscriptionScanner.$default$deliveryDelay();
            }
            int messagePriority$value = this.messagePriority$value;
            if (!this.messagePriority$set) {
                messagePriority$value = SubscriptionScanner.$default$messagePriority();
            }
            return new SubscriptionScanner(this.connectionFactory, this.dictionary, this.scanner, timeToLive$value, deliveryMode$value, deliveryDelay$value, messagePriority$value);
        }

        public String toString() {
            return "SubscriptionScanner.SubscriptionScannerBuilder(connectionFactory=" + this.connectionFactory + ", dictionary=" + this.dictionary + ", scanner=" + this.scanner + ", timeToLive$value=" + this.timeToLive$value + ", deliveryMode$value=" + this.deliveryMode$value + ", deliveryDelay$value=" + this.deliveryDelay$value + ", messagePriority$value=" + this.messagePriority$value + ")";
        }
    }
}

