/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions.hooks;

import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.graphql.subscriptions.annotations.Subscription;

public enum TopicType {
    ADDED("Added", LifeCycleHookBinding.Operation.CREATE),
    DELETED("Deleted", LifeCycleHookBinding.Operation.DELETE),
    UPDATED("Updated", LifeCycleHookBinding.Operation.UPDATE),
    CUSTOM("", null);

    private final String topicSuffix;
    private final LifeCycleHookBinding.Operation operation;

    private TopicType(String topicSuffix, LifeCycleHookBinding.Operation operation) {
        this.topicSuffix = topicSuffix;
        this.operation = operation;
    }

    public String toTopicName(Type<?> type, EntityDictionary dictionary) {
        return dictionary.getJsonAliasFor(type) + this.topicSuffix;
    }

    public static TopicType fromOperation(LifeCycleHookBinding.Operation op) {
        switch (op) {
            case CREATE: {
                return ADDED;
            }
            case DELETE: {
                return DELETED;
            }
        }
        return UPDATED;
    }

    public static TopicType fromOperation(Subscription.Operation op) {
        switch (op) {
            case CREATE: {
                return ADDED;
            }
            case DELETE: {
                return DELETED;
            }
        }
        return UPDATED;
    }

    public String getTopicSuffix() {
        return this.topicSuffix;
    }

    public LifeCycleHookBinding.Operation getOperation() {
        return this.operation;
    }
}

