/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.graphql.GraphQLRequestScope;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.graphql.parser.GraphQLProjectionInfo;
import com.yahoo.elide.graphql.parser.SubscriptionEntityProjectionMaker;
import com.yahoo.elide.graphql.subscriptions.websocket.ConnectionInfo;
import com.yahoo.elide.graphql.subscriptions.websocket.SessionHandler;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.Complete;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.Error;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.Next;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.Ping;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.Subscribe;
import graphql.ErrorClassification;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RequestHandler.class);
    protected DataStore topicStore;
    protected DataStoreTransaction transaction;
    protected Elide elide;
    protected GraphQL api;
    protected UUID requestID;
    protected String protocolID;
    protected SessionHandler sessionHandler;
    protected ConnectionInfo connectionInfo;
    protected boolean sendPingOnSubscribe;
    protected AtomicBoolean isOpen = new AtomicBoolean(true);
    protected boolean verboseErrors = false;

    public RequestHandler(SessionHandler sessionHandler, DataStore topicStore, Elide elide, GraphQL api, String protocolID, UUID requestID, ConnectionInfo connectionInfo, boolean sendPingOnSubscribe, boolean verboseErrors) {
        this.sessionHandler = sessionHandler;
        this.topicStore = topicStore;
        this.elide = elide;
        this.api = api;
        this.requestID = requestID;
        this.protocolID = protocolID;
        this.connectionInfo = connectionInfo;
        this.transaction = null;
        this.sendPingOnSubscribe = sendPingOnSubscribe;
        this.verboseErrors = verboseErrors;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isOpen.compareAndExchange(true, false)) {
            return;
        }
        if (this.transaction != null) {
            this.transaction.close();
            this.elide.getTransactionRegistry().removeRunningTransaction(this.requestID);
        }
        this.sessionHandler.close(this.protocolID);
        log.debug("Closed Request Handler");
    }

    public void handleRequest(Subscribe subscribeRequest) {
        ExecutionResult executionResult = null;
        try {
            executionResult = this.executeRequest(subscribeRequest);
        }
        catch (RuntimeException e) {
            log.error("UNEXPECTED RuntimeException: {}", (Object)e.getMessage());
            ElideResponse response = QueryRunner.handleRuntimeException(this.elide, e, this.verboseErrors);
            this.safeSendError(response.getBody());
            this.safeClose();
        }
        if (!(executionResult.getData() instanceof Publisher)) {
            this.safeSendNext(executionResult);
            this.safeSendComplete();
            this.safeClose();
            return;
        }
        Publisher resultPublisher = (Publisher)executionResult.getData();
        if (resultPublisher == null) {
            this.safeSendError((GraphQLError[])executionResult.getErrors().toArray(GraphQLError[]::new));
            this.safeClose();
            return;
        }
        resultPublisher.subscribe((Subscriber)new ExecutionResultSubscriber());
    }

    public synchronized ExecutionResult executeRequest(Subscribe subscribeRequest) {
        if (this.transaction != null) {
            throw new IllegalStateException("Already handling an active request.");
        }
        this.transaction = this.topicStore.beginReadTransaction();
        this.elide.getTransactionRegistry().addRunningTransaction(this.requestID, this.transaction);
        ElideSettings settings = this.elide.getElideSettings();
        GraphQLProjectionInfo projectionInfo = new SubscriptionEntityProjectionMaker(settings, subscribeRequest.getPayload().getVariables(), this.connectionInfo.getGetApiVersion()).make(subscribeRequest.getPayload().getQuery());
        GraphQLRequestScope requestScope = new GraphQLRequestScope(this.connectionInfo.getBaseUrl(), this.transaction, this.connectionInfo.getUser(), this.connectionInfo.getGetApiVersion(), settings, projectionInfo, this.requestID, this.connectionInfo.getParameters());
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(subscribeRequest.getPayload().getQuery()).operationName(subscribeRequest.getPayload().getOperationName()).variables(subscribeRequest.getPayload().getVariables()).localContext((Object)requestScope).build();
        log.info("Processing GraphQL query:\n{}", (Object)subscribeRequest.getPayload().getQuery());
        return this.api.execute(executionInput);
    }

    protected void sendMessage(String message) {
        if (this.isOpen.get()) {
            this.sessionHandler.sendMessage(message);
            return;
        }
        log.debug("UNEXPECTED Sending message on closed handler: {}", (Object)message);
    }

    protected void safeSendPing() {
        ObjectMapper mapper = this.elide.getElideSettings().getMapper().getObjectMapper();
        Ping ping = new Ping();
        try {
            this.sendMessage(mapper.writeValueAsString((Object)ping));
        }
        catch (JsonProcessingException e) {
            log.error("UNEXPECTED Json Serialization Error {}", (Object)e.getMessage());
            this.safeClose();
        }
    }

    protected void safeSendNext(ExecutionResult result) {
        log.debug("Sending Next {}", (Object)result);
        ObjectMapper mapper = this.elide.getElideSettings().getMapper().getObjectMapper();
        Next next = Next.builder().result(result).id(this.protocolID).build();
        try {
            this.sendMessage(mapper.writeValueAsString((Object)next));
        }
        catch (JsonProcessingException e) {
            log.error("UNEXPECTED Json Serialization Error {}", (Object)e.getMessage());
            this.safeClose();
        }
    }

    protected void safeSendComplete() {
        log.debug("Sending Complete");
        ObjectMapper mapper = this.elide.getElideSettings().getMapper().getObjectMapper();
        Complete complete = Complete.builder().id(this.protocolID).build();
        try {
            this.sendMessage(mapper.writeValueAsString((Object)complete));
        }
        catch (JsonProcessingException e) {
            log.error("UNEXPECTED Json Serialization Error {}", (Object)e.getMessage());
            this.safeClose();
        }
    }

    protected void safeSendError(GraphQLError[] errors) {
        log.debug("Sending Error {}", (Object[])errors);
        ObjectMapper mapper = this.elide.getElideSettings().getMapper().getObjectMapper();
        Error error = Error.builder().id(this.protocolID).payload(errors).build();
        try {
            this.sendMessage(mapper.writeValueAsString((Object)error));
        }
        catch (JsonProcessingException e) {
            log.error("UNEXPECTED Json Serialization Error {}", (Object)e.getMessage());
            this.safeClose();
        }
    }

    protected void safeSendError(final String message) {
        GraphQLError error = new GraphQLError(){

            public String getMessage() {
                return message;
            }

            public List<SourceLocation> getLocations() {
                return null;
            }

            public ErrorClassification getErrorType() {
                return null;
            }
        };
        GraphQLError[] errors = new GraphQLError[]{error};
        this.safeSendError(errors);
    }

    protected void safeClose() {
        try {
            this.close();
        }
        catch (Exception e) {
            log.error("UNEXPECTED Exception during close {}", (Object)e.getMessage());
        }
    }

    private class ExecutionResultSubscriber
    implements Subscriber<ExecutionResult> {
        AtomicReference<Subscription> subscriptionRef = new AtomicReference();

        private ExecutionResultSubscriber() {
        }

        public void onSubscribe(Subscription subscription) {
            this.subscriptionRef.set(subscription);
            if (RequestHandler.this.sendPingOnSubscribe) {
                RequestHandler.this.safeSendPing();
            }
            subscription.request(1L);
        }

        public void onNext(ExecutionResult executionResult) {
            log.debug("Next Result");
            RequestHandler.this.safeSendNext(executionResult);
            this.subscriptionRef.get().request(1L);
        }

        public void onError(Throwable t) {
            log.error("UNEXPECTED Topic Error {}", (Object)t.getMessage());
            RequestHandler.this.safeSendError(t.getMessage());
            RequestHandler.this.safeClose();
        }

        public void onComplete() {
            log.debug("Topic was terminated");
            RequestHandler.this.safeSendComplete();
            RequestHandler.this.safeClose();
        }
    }
}

