/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions.websocket;

import com.yahoo.elide.Elide;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.DefaultClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.subscriptions.SubscriptionDataFetcher;
import com.yahoo.elide.graphql.subscriptions.SubscriptionModelBuilder;
import com.yahoo.elide.graphql.subscriptions.websocket.ConnectionInfo;
import com.yahoo.elide.graphql.subscriptions.websocket.SessionHandler;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.WebSocketCloseReasons;
import graphql.GraphQL;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.schema.GraphQLSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/", subprotocols={"graphql-transport-ws"})
public class SubscriptionWebSocket {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionWebSocket.class);
    private Elide elide;
    private ExecutorService executorService;
    private int connectTimeoutMs;
    private int maxSubscriptions;
    private UserFactory userFactory;
    private long maxIdleTimeoutMs;
    private int maxMessageSize;
    private boolean sendPingOnSubscribe;
    private boolean verboseErrors;
    private final Map<String, GraphQL> apis = new HashMap<String, GraphQL>();
    private final ConcurrentMap<Session, SessionHandler> openSessions = new ConcurrentHashMap<Session, SessionHandler>();
    public static final UserFactory DEFAULT_USER_FACTORY = session -> new User(session.getUserPrincipal());

    protected SubscriptionWebSocket(Elide elide, ExecutorService executorService, int connectTimeoutMs, int maxSubscriptions, UserFactory userFactory, long maxIdleTimeoutMs, int maxMessageSize, boolean sendPingOnSubscribe, boolean verboseErrors) {
        this.elide = elide;
        this.executorService = executorService;
        this.connectTimeoutMs = connectTimeoutMs;
        this.maxSubscriptions = maxSubscriptions;
        this.userFactory = userFactory;
        this.sendPingOnSubscribe = sendPingOnSubscribe;
        this.maxIdleTimeoutMs = maxIdleTimeoutMs;
        this.maxMessageSize = maxMessageSize;
        this.verboseErrors = verboseErrors;
        EntityDictionary dictionary = elide.getElideSettings().getDictionary();
        for (String apiVersion : dictionary.getApiVersions()) {
            NonEntityDictionary nonEntityDictionary = new NonEntityDictionary((ClassScanner)DefaultClassScanner.getInstance(), CoerceUtil::lookup);
            SubscriptionModelBuilder builder = new SubscriptionModelBuilder(dictionary, nonEntityDictionary, new SubscriptionDataFetcher(nonEntityDictionary), "");
            GraphQL api = GraphQL.newGraphQL((GraphQLSchema)builder.build()).queryExecutionStrategy((ExecutionStrategy)new AsyncSerialExecutionStrategy()).subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy()).build();
            this.apis.put(apiVersion, api);
        }
    }

    @OnOpen
    public void onOpen(Session session) throws IOException {
        log.debug("Session Opening: {}", (Object)session.getId());
        SessionHandler subscriptionSession = this.createSessionHandler(session);
        session.setMaxIdleTimeout(this.maxIdleTimeoutMs);
        session.setMaxTextMessageBufferSize(this.maxMessageSize);
        session.setMaxBinaryMessageBufferSize(this.maxMessageSize);
        this.openSessions.put(session, subscriptionSession);
    }

    @OnMessage
    public void onMessage(Session session, String message) throws IOException {
        log.debug("Session Message: {} {}", (Object)session.getId(), (Object)message);
        SessionHandler handler = this.findSession(session);
        if (handler == null) {
            throw new IllegalStateException("Cannot locate session: " + session.getId());
        }
        handler.handleRequest(message);
    }

    @OnClose
    public void onClose(Session session) throws IOException {
        log.debug("Session Closing: {}", (Object)session.getId());
        SessionHandler handler = this.findSession(session);
        if (handler != null) {
            handler.safeClose(WebSocketCloseReasons.NORMAL_CLOSE);
            this.openSessions.remove(session);
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        log.error("Session Error: {} {}", (Object)session.getId(), (Object)throwable.getMessage());
        SessionHandler handler = this.findSession(session);
        if (handler != null) {
            handler.safeClose(WebSocketCloseReasons.INTERNAL_ERROR);
            this.openSessions.remove(session);
        }
    }

    private SessionHandler findSession(Session wrappedSession) {
        SessionHandler sessionHandler = this.openSessions.getOrDefault(wrappedSession, null);
        String message = "Unable to locate active session: " + wrappedSession.getId();
        if (sessionHandler == null) {
            log.error(message);
        }
        return sessionHandler;
    }

    protected SessionHandler createSessionHandler(Session session) {
        String apiVersion = session.getRequestParameterMap().getOrDefault("ApiVersion", List.of("")).get(0);
        User user = this.userFactory.create(session);
        return new SessionHandler(session, this.elide.getDataStore(), this.elide, this.apis.get(apiVersion), this.connectTimeoutMs, this.maxSubscriptions, ConnectionInfo.builder().user(user).baseUrl(session.getRequestURI().getPath()).parameters(session.getRequestParameterMap()).getApiVersion(apiVersion).build(), this.sendPingOnSubscribe, this.verboseErrors, this.executorService);
    }

    private static int $default$connectTimeoutMs() {
        return 5000;
    }

    private static int $default$maxSubscriptions() {
        return 30;
    }

    private static UserFactory $default$userFactory() {
        return DEFAULT_USER_FACTORY;
    }

    private static long $default$maxIdleTimeoutMs() {
        return 300000L;
    }

    private static int $default$maxMessageSize() {
        return 10000;
    }

    private static boolean $default$sendPingOnSubscribe() {
        return false;
    }

    private static boolean $default$verboseErrors() {
        return false;
    }

    public static SubscriptionWebSocketBuilder builder() {
        return new SubscriptionWebSocketBuilder();
    }

    public static class SubscriptionWebSocketBuilder {
        private Elide elide;
        private ExecutorService executorService;
        private boolean connectTimeoutMs$set;
        private int connectTimeoutMs$value;
        private boolean maxSubscriptions$set;
        private int maxSubscriptions$value;
        private boolean userFactory$set;
        private UserFactory userFactory$value;
        private boolean maxIdleTimeoutMs$set;
        private long maxIdleTimeoutMs$value;
        private boolean maxMessageSize$set;
        private int maxMessageSize$value;
        private boolean sendPingOnSubscribe$set;
        private boolean sendPingOnSubscribe$value;
        private boolean verboseErrors$set;
        private boolean verboseErrors$value;

        SubscriptionWebSocketBuilder() {
        }

        public SubscriptionWebSocketBuilder elide(Elide elide) {
            this.elide = elide;
            return this;
        }

        public SubscriptionWebSocketBuilder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public SubscriptionWebSocketBuilder connectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs$value = connectTimeoutMs;
            this.connectTimeoutMs$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder maxSubscriptions(int maxSubscriptions) {
            this.maxSubscriptions$value = maxSubscriptions;
            this.maxSubscriptions$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder userFactory(UserFactory userFactory) {
            this.userFactory$value = userFactory;
            this.userFactory$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder maxIdleTimeoutMs(long maxIdleTimeoutMs) {
            this.maxIdleTimeoutMs$value = maxIdleTimeoutMs;
            this.maxIdleTimeoutMs$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize$value = maxMessageSize;
            this.maxMessageSize$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder sendPingOnSubscribe(boolean sendPingOnSubscribe) {
            this.sendPingOnSubscribe$value = sendPingOnSubscribe;
            this.sendPingOnSubscribe$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder verboseErrors(boolean verboseErrors) {
            this.verboseErrors$value = verboseErrors;
            this.verboseErrors$set = true;
            return this;
        }

        public SubscriptionWebSocket build() {
            int connectTimeoutMs$value = this.connectTimeoutMs$value;
            if (!this.connectTimeoutMs$set) {
                connectTimeoutMs$value = SubscriptionWebSocket.$default$connectTimeoutMs();
            }
            int maxSubscriptions$value = this.maxSubscriptions$value;
            if (!this.maxSubscriptions$set) {
                maxSubscriptions$value = SubscriptionWebSocket.$default$maxSubscriptions();
            }
            UserFactory userFactory$value = this.userFactory$value;
            if (!this.userFactory$set) {
                userFactory$value = SubscriptionWebSocket.$default$userFactory();
            }
            long maxIdleTimeoutMs$value = this.maxIdleTimeoutMs$value;
            if (!this.maxIdleTimeoutMs$set) {
                maxIdleTimeoutMs$value = SubscriptionWebSocket.$default$maxIdleTimeoutMs();
            }
            int maxMessageSize$value = this.maxMessageSize$value;
            if (!this.maxMessageSize$set) {
                maxMessageSize$value = SubscriptionWebSocket.$default$maxMessageSize();
            }
            boolean sendPingOnSubscribe$value = this.sendPingOnSubscribe$value;
            if (!this.sendPingOnSubscribe$set) {
                sendPingOnSubscribe$value = SubscriptionWebSocket.$default$sendPingOnSubscribe();
            }
            boolean verboseErrors$value = this.verboseErrors$value;
            if (!this.verboseErrors$set) {
                verboseErrors$value = SubscriptionWebSocket.$default$verboseErrors();
            }
            return new SubscriptionWebSocket(this.elide, this.executorService, connectTimeoutMs$value, maxSubscriptions$value, userFactory$value, maxIdleTimeoutMs$value, maxMessageSize$value, sendPingOnSubscribe$value, verboseErrors$value);
        }

        public String toString() {
            return "SubscriptionWebSocket.SubscriptionWebSocketBuilder(elide=" + this.elide + ", executorService=" + this.executorService + ", connectTimeoutMs$value=" + this.connectTimeoutMs$value + ", maxSubscriptions$value=" + this.maxSubscriptions$value + ", userFactory$value=" + this.userFactory$value + ", maxIdleTimeoutMs$value=" + this.maxIdleTimeoutMs$value + ", maxMessageSize$value=" + this.maxMessageSize$value + ", sendPingOnSubscribe$value=" + this.sendPingOnSubscribe$value + ", verboseErrors$value=" + this.verboseErrors$value + ")";
        }
    }

    @FunctionalInterface
    public static interface UserFactory {
        public User create(Session var1);
    }
}

