/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions.websocket.protocol;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.AbstractProtocolMessageWithID;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.MessageType;
import java.util.HashMap;
import java.util.Map;

@JsonPropertyOrder(value={"type", "id", "payload"})
public final class Subscribe
extends AbstractProtocolMessageWithID {
    private final Payload payload;

    @JsonCreator
    public Subscribe(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="payload", required=true) Payload payload) {
        super(id, MessageType.SUBSCRIBE);
        this.payload = payload;
    }

    public static SubscribeBuilder builder() {
        return new SubscribeBuilder();
    }

    public Payload getPayload() {
        return this.payload;
    }

    public String toString() {
        return "Subscribe(payload=" + this.getPayload() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscribe)) {
            return false;
        }
        Subscribe other = (Subscribe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Payload this$payload = this.getPayload();
        Payload other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Subscribe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Payload $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        return result;
    }

    public static class SubscribeBuilder {
        private String id;
        private Payload payload;

        SubscribeBuilder() {
        }

        @JsonProperty(value="id", required=true)
        public SubscribeBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="payload", required=true)
        public SubscribeBuilder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public Subscribe build() {
            return new Subscribe(this.id, this.payload);
        }

        public String toString() {
            return "Subscribe.SubscribeBuilder(id=" + this.id + ", payload=" + this.payload + ")";
        }
    }

    @JsonPropertyOrder(value={"operationName", "query", "variables"})
    public static final class Payload {
        private final String operationName;
        @JsonProperty(required=true)
        private final String query;
        private final Map<String, Object> variables;

        @JsonCreator
        public Payload(@JsonProperty(value="operationName") String operationName, @JsonProperty(value="query", required=true) String query, @JsonProperty(value="variables") Map<String, Object> variables) {
            this.operationName = operationName;
            this.query = query;
            this.variables = variables == null ? new HashMap<String, Object>() : variables;
        }

        public static PayloadBuilder builder() {
            return new PayloadBuilder();
        }

        public String getOperationName() {
            return this.operationName;
        }

        public String getQuery() {
            return this.query;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public String toString() {
            return "Subscribe.Payload(operationName=" + this.getOperationName() + ", query=" + this.getQuery() + ", variables=" + this.getVariables() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payload)) {
                return false;
            }
            Payload other = (Payload)o;
            String this$operationName = this.getOperationName();
            String other$operationName = other.getOperationName();
            if (this$operationName == null ? other$operationName != null : !this$operationName.equals(other$operationName)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            Map<String, Object> this$variables = this.getVariables();
            Map<String, Object> other$variables = other.getVariables();
            return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $operationName = this.getOperationName();
            result = result * 59 + ($operationName == null ? 43 : $operationName.hashCode());
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            Map<String, Object> $variables = this.getVariables();
            result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
            return result;
        }

        public static class PayloadBuilder {
            private String operationName;
            private String query;
            private Map<String, Object> variables;

            PayloadBuilder() {
            }

            @JsonProperty(value="operationName")
            public PayloadBuilder operationName(String operationName) {
                this.operationName = operationName;
                return this;
            }

            @JsonProperty(value="query", required=true)
            public PayloadBuilder query(String query) {
                this.query = query;
                return this;
            }

            @JsonProperty(value="variables")
            public PayloadBuilder variables(Map<String, Object> variables) {
                this.variables = variables;
                return this;
            }

            public Payload build() {
                return new Payload(this.operationName, this.query, this.variables);
            }

            public String toString() {
                return "Subscribe.Payload.PayloadBuilder(operationName=" + this.operationName + ", query=" + this.query + ", variables=" + this.variables + ")";
            }
        }
    }
}

