/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.yahoo.elide.modelconfig.Config;
import com.yahoo.elide.modelconfig.DynamicConfigHelpers;
import com.yahoo.elide.modelconfig.ElideMetaSchema;
import com.yahoo.elide.modelconfig.InvalidSchemaException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigSchemaValidator.class);
    private final JsonSchema tableSchema;
    private final JsonSchema securitySchema;
    private final JsonSchema variableSchema;
    private final JsonSchema dbConfigSchema;
    private final JsonSchema namespaceConfigSchema;
    private final ObjectMapper objectMapper;

    public DynamicConfigSchemaValidator() {
        this(new ObjectMapper());
    }

    public DynamicConfigSchemaValidator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        JsonMetaSchema jsonMetaSchema = ElideMetaSchema.getInstance();
        JsonSchemaFactory factory = JsonSchemaFactory.builder().defaultMetaSchemaIri(jsonMetaSchema.getIri()).metaSchema(jsonMetaSchema).build();
        this.tableSchema = DynamicConfigSchemaValidator.loadSchema(factory, objectMapper, Config.TABLE.getConfigSchema());
        this.securitySchema = DynamicConfigSchemaValidator.loadSchema(factory, objectMapper, Config.SECURITY.getConfigSchema());
        this.variableSchema = DynamicConfigSchemaValidator.loadSchema(factory, objectMapper, Config.MODELVARIABLE.getConfigSchema());
        this.dbConfigSchema = DynamicConfigSchemaValidator.loadSchema(factory, objectMapper, Config.SQLDBConfig.getConfigSchema());
        this.namespaceConfigSchema = DynamicConfigSchemaValidator.loadSchema(factory, objectMapper, Config.NAMESPACEConfig.getConfigSchema());
    }

    public boolean verifySchema(Config configType, String jsonConfig, String fileName) throws IOException {
        Set results = null;
        switch (configType) {
            case TABLE: {
                results = this.tableSchema.validate(this.objectMapper.readTree(jsonConfig));
                break;
            }
            case SECURITY: {
                results = this.securitySchema.validate(this.objectMapper.readTree(jsonConfig));
                break;
            }
            case MODELVARIABLE: 
            case DBVARIABLE: {
                results = this.variableSchema.validate(this.objectMapper.readTree(jsonConfig));
                break;
            }
            case SQLDBConfig: {
                results = this.dbConfigSchema.validate(this.objectMapper.readTree(jsonConfig));
                break;
            }
            case NAMESPACEConfig: {
                results = this.namespaceConfigSchema.validate(this.objectMapper.readTree(jsonConfig));
                break;
            }
            default: {
                log.error("Not a valid config type :" + configType);
            }
        }
        if (results != null && !results.isEmpty()) {
            throw new InvalidSchemaException(fileName, results);
        }
        return true;
    }

    private static JsonSchema loadSchema(JsonSchemaFactory factory, ObjectMapper objectMapper, String resource) {
        JsonSchema jsonSchema;
        block8: {
            InputStream is = DynamicConfigHelpers.class.getResourceAsStream(resource);
            try {
                SchemaValidatorsConfig config = SchemaValidatorsConfig.builder().formatAssertionsEnabled(Boolean.valueOf(true)).errorMessageKeyword("errorMessage").build();
                jsonSchema = factory.getSchema(objectMapper.readTree(is), config);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Error loading schema file " + resource + " to verify");
                    throw new UncheckedIOException(e.getMessage(), e);
                }
            }
            is.close();
        }
        return jsonSchema;
    }
}

