/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.io;

import com.yahoo.elide.modelconfig.DynamicConfigHelpers;
import com.yahoo.elide.modelconfig.store.models.ConfigFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class FileLoader {
    private static final Logger log = LoggerFactory.getLogger(FileLoader.class);
    private static final Pattern TABLE_FILE = Pattern.compile("models/tables/[^/]+\\.hjson");
    private static final Pattern NAME_SPACE_FILE = Pattern.compile("models/namespaces/[^/]+\\.hjson");
    private static final Pattern DB_FILE = Pattern.compile("db/sql/[^/]+\\.hjson");
    private static final String CLASSPATH_PATTERN = "classpath*:";
    private static final String FILEPATH_PATTERN = "file:";
    private static final String RESOURCEPATH_PATTERN = "resource:";
    private static final String RESOURCES = "resources";
    private static final int RESOURCES_LENGTH = 9;
    private static final String HJSON_EXTN = "**/*.hjson";
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
    private static final Function<Resource, String> CONTENT_PROVIDER = resource -> {
        String string;
        block8: {
            InputStream inputStream = resource.getInputStream();
            try {
                string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Error converting stream to String: {}", (Object)e.getMessage());
                    throw new IllegalStateException(e);
                }
            }
            inputStream.close();
        }
        return string;
    };
    private final String rootPath;
    private final String rootURL;
    private boolean writeable;

    public FileLoader(String rootPath) {
        String pattern = CLASSPATH_PATTERN + DynamicConfigHelpers.formatFilePath(FileLoader.formatClassPath(rootPath));
        boolean classPathExists = false;
        try {
            classPathExists = this.resolver.getResources(pattern).length != 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (classPathExists) {
            this.rootURL = pattern;
            this.writeable = false;
        } else {
            File config = new File(rootPath);
            if (!config.exists()) {
                log.error("Config path does not exist: {}", (Object)config);
                throw new IllegalStateException(rootPath + " : config path does not exist");
            }
            this.writeable = Files.isWritable(config.toPath());
            this.rootURL = FILEPATH_PATTERN + DynamicConfigHelpers.formatFilePath(config.getAbsolutePath());
        }
        this.rootPath = rootPath;
    }

    public Map<String, ConfigFile> loadResources() throws IOException {
        Resource[] hjsonResources;
        LinkedHashMap<String, ConfigFile> resourceMap = new LinkedHashMap<String, ConfigFile>();
        URI configDirURI = this.resolver.getResources(this.rootURL)[0].getURI();
        String configDirURIString = configDirURI.toString();
        int configDirURILength = configDirURIString.length();
        if (configDirURIString.startsWith(FILEPATH_PATTERN) && !configDirURIString.startsWith("file:/")) {
            ++configDirURILength;
        }
        for (Resource resource : hjsonResources = this.resolver.getResources(this.rootURL + HJSON_EXTN)) {
            if (!resource.exists()) {
                log.error("Missing resource during HJSON configuration load: {}", (Object)resource.getURI());
                continue;
            }
            String resourceUri = resource.getURI().toString();
            String path = null;
            if (resourceUri.startsWith(RESOURCEPATH_PATTERN)) {
                int rootLength = resourceUri.indexOf(this.rootPath) + this.rootPath.length() + 1;
                path = resourceUri.substring(rootLength);
            } else {
                path = resourceUri.substring(configDirURILength);
            }
            resourceMap.put(path, ConfigFile.builder().type(FileLoader.toType(path)).contentProvider(() -> CONTENT_PROVIDER.apply(resource)).path(path).version("").build());
        }
        return resourceMap;
    }

    public ConfigFile loadResource(String relativePath) throws IOException {
        Resource[] hjsonResources = this.resolver.getResources(this.rootURL + relativePath);
        if (hjsonResources.length == 0 || !hjsonResources[0].exists()) {
            return null;
        }
        return ConfigFile.builder().type(FileLoader.toType(relativePath)).contentProvider(() -> CONTENT_PROVIDER.apply(hjsonResources[0])).path(relativePath).version("").build();
    }

    static String formatClassPath(String filePath) {
        if (filePath.indexOf("resources/") > -1) {
            return filePath.substring(filePath.indexOf("resources/") + 9 + 1);
        }
        if (filePath.indexOf(RESOURCES) > -1) {
            return filePath.substring(filePath.indexOf(RESOURCES) + 9);
        }
        return filePath;
    }

    public static ConfigFile.ConfigFileType toType(String path) {
        String lowerCasePath = path.toLowerCase(Locale.ROOT);
        if (lowerCasePath.endsWith("db/variables.hjson")) {
            return ConfigFile.ConfigFileType.VARIABLE;
        }
        if (lowerCasePath.endsWith("models/variables.hjson")) {
            return ConfigFile.ConfigFileType.VARIABLE;
        }
        if (lowerCasePath.equals("models/security.hjson")) {
            return ConfigFile.ConfigFileType.SECURITY;
        }
        if (DB_FILE.matcher(lowerCasePath).matches()) {
            return ConfigFile.ConfigFileType.DATABASE;
        }
        if (TABLE_FILE.matcher(lowerCasePath).matches()) {
            return ConfigFile.ConfigFileType.TABLE;
        }
        if (NAME_SPACE_FILE.matcher(lowerCasePath).matches()) {
            return ConfigFile.ConfigFileType.NAMESPACE;
        }
        return ConfigFile.ConfigFileType.UNKNOWN;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public boolean isWriteable() {
        return this.writeable;
    }
}

