/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yahoo.elide.modelconfig.model.Named;
import com.yahoo.elide.modelconfig.model.TableSource;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "description", "type", "values", "tableSource", "default"})
public class Argument
implements Named {
    private static final long serialVersionUID = -6628282044575311784L;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="values")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> values = new LinkedHashSet<String>();
    @JsonProperty(value="tableSource")
    private TableSource tableSource;
    @JsonProperty(value="default")
    private Object defaultValue;

    public String getDescription() {
        return this.description == null ? this.getName() : this.description;
    }

    public static ArgumentBuilder builder() {
        return new ArgumentBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public TableSource getTableSource() {
        return this.tableSource;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="values")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setValues(Set<String> values) {
        this.values = values;
    }

    @JsonProperty(value="tableSource")
    public void setTableSource(TableSource tableSource) {
        this.tableSource = tableSource;
    }

    @JsonProperty(value="default")
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return "Argument(name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", values=" + this.getValues() + ", tableSource=" + this.getTableSource() + ", defaultValue=" + this.getDefaultValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Set<String> this$values = this.getValues();
        Set<String> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        TableSource this$tableSource = this.getTableSource();
        TableSource other$tableSource = other.getTableSource();
        if (this$tableSource == null ? other$tableSource != null : !((Object)this$tableSource).equals(other$tableSource)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Argument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Set<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        TableSource $tableSource = this.getTableSource();
        result = result * 59 + ($tableSource == null ? 43 : ((Object)$tableSource).hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public Argument(String name, String description, String type, Set<String> values, TableSource tableSource, Object defaultValue) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.values = values;
        this.tableSource = tableSource;
        this.defaultValue = defaultValue;
    }

    public Argument() {
    }

    public static class ArgumentBuilder {
        private String name;
        private String description;
        private String type;
        private Set<String> values;
        private TableSource tableSource;
        private Object defaultValue;

        ArgumentBuilder() {
        }

        @JsonProperty(value="name")
        public ArgumentBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="description")
        public ArgumentBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="type")
        public ArgumentBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="values")
        @JsonDeserialize(as=LinkedHashSet.class)
        public ArgumentBuilder values(Set<String> values) {
            this.values = values;
            return this;
        }

        @JsonProperty(value="tableSource")
        public ArgumentBuilder tableSource(TableSource tableSource) {
            this.tableSource = tableSource;
            return this;
        }

        @JsonProperty(value="default")
        public ArgumentBuilder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Argument build() {
            return new Argument(this.name, this.description, this.type, this.values, this.tableSource, this.defaultValue);
        }

        public String toString() {
            return "Argument.ArgumentBuilder(name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", values=" + this.values + ", tableSource=" + this.tableSource + ", defaultValue=" + this.defaultValue + ")";
        }
    }
}

