/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yahoo.elide.modelconfig.model.Named;
import com.yahoo.elide.modelconfig.model.NamespaceConfig;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"namespaces"})
public class ElideNamespaceConfig {
    @JsonProperty(value="namespaces")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<NamespaceConfig> namespaceconfigs = new LinkedHashSet<NamespaceConfig>();

    public boolean hasNamespace(String name, String version) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        if (nameLower.equals(NamespaceConfig.DEFAULT)) {
            return true;
        }
        return this.namespaceconfigs.stream().filter(namespace -> namespace.getApiVersion().equals(version)).map(Named::getName).anyMatch(name::equals);
    }

    public Set<NamespaceConfig> getNamespaceconfigs() {
        return this.namespaceconfigs;
    }

    @JsonProperty(value="namespaces")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setNamespaceconfigs(Set<NamespaceConfig> namespaceconfigs) {
        this.namespaceconfigs = namespaceconfigs;
    }

    public String toString() {
        return "ElideNamespaceConfig(namespaceconfigs=" + this.getNamespaceconfigs() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElideNamespaceConfig)) {
            return false;
        }
        ElideNamespaceConfig other = (ElideNamespaceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<NamespaceConfig> this$namespaceconfigs = this.getNamespaceconfigs();
        Set<NamespaceConfig> other$namespaceconfigs = other.getNamespaceconfigs();
        return !(this$namespaceconfigs == null ? other$namespaceconfigs != null : !((Object)this$namespaceconfigs).equals(other$namespaceconfigs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElideNamespaceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<NamespaceConfig> $namespaceconfigs = this.getNamespaceconfigs();
        result = result * 59 + ($namespaceconfigs == null ? 43 : ((Object)$namespaceconfigs).hashCode());
        return result;
    }

    public ElideNamespaceConfig(Set<NamespaceConfig> namespaceconfigs) {
        this.namespaceconfigs = namespaceconfigs;
    }

    public ElideNamespaceConfig() {
    }
}

