/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yahoo.elide.modelconfig.model.Named;
import com.yahoo.elide.modelconfig.model.Table;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tables"})
public class ElideTableConfig {
    @JsonProperty(value="tables")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<Table> tables = new LinkedHashSet<Table>();

    public boolean hasTable(String name) {
        return this.tables.stream().map(Named::getGlobalName).anyMatch(name::equals);
    }

    public Table getTable(String name) {
        return this.tables.stream().filter(t -> t.getGlobalName().equals(name)).findFirst().orElse(null);
    }

    public Set<Table> getTables() {
        return this.tables;
    }

    @JsonProperty(value="tables")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setTables(Set<Table> tables) {
        this.tables = tables;
    }

    public String toString() {
        return "ElideTableConfig(tables=" + this.getTables() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElideTableConfig)) {
            return false;
        }
        ElideTableConfig other = (ElideTableConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Table> this$tables = this.getTables();
        Set<Table> other$tables = other.getTables();
        return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElideTableConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Table> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        return result;
    }

    public ElideTableConfig(Set<Table> tables) {
        this.tables = tables;
    }

    public ElideTableConfig() {
    }
}

