/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.yahoo.elide.modelconfig.model.Named;
import com.yahoo.elide.modelconfig.model.NamespaceConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "namespace", "to", "type", "kind", "definition"})
public class Join
implements Named {
    private static final long serialVersionUID = -1416294756711914111L;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="namespace")
    private String namespace = NamespaceConfig.DEFAULT;
    @JsonProperty(value="to")
    private String to;
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="kind")
    private Kind kind = Kind.TOONE;
    @JsonProperty(value="definition")
    private String definition;

    public String getTo() {
        if (this.namespace == null || this.namespace.isEmpty() || this.namespace.equals(NamespaceConfig.DEFAULT)) {
            return this.to;
        }
        return this.namespace + "_" + this.to;
    }

    public static JoinBuilder builder() {
        return new JoinBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Type getType() {
        return this.type;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getDefinition() {
        return this.definition;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="to")
    public void setTo(String to) {
        this.to = to;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty(value="kind")
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    @JsonProperty(value="definition")
    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String toString() {
        return "Join(name=" + this.getName() + ", namespace=" + this.getNamespace() + ", to=" + this.getTo() + ", type=" + this.getType() + ", kind=" + this.getKind() + ", definition=" + this.getDefinition() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Join)) {
            return false;
        }
        Join other = (Join)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Kind this$kind = this.getKind();
        Kind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        String this$definition = this.getDefinition();
        String other$definition = other.getDefinition();
        return !(this$definition == null ? other$definition != null : !this$definition.equals(other$definition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Join;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        String $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        return result;
    }

    public Join(String name, String namespace, String to, Type type, Kind kind, String definition) {
        this.name = name;
        this.namespace = namespace;
        this.to = to;
        this.type = type;
        this.kind = kind;
        this.definition = definition;
    }

    public Join() {
    }

    public static class JoinBuilder {
        private String name;
        private String namespace;
        private String to;
        private Type type;
        private Kind kind;
        private String definition;

        JoinBuilder() {
        }

        @JsonProperty(value="name")
        public JoinBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="namespace")
        public JoinBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="to")
        public JoinBuilder to(String to) {
            this.to = to;
            return this;
        }

        @JsonProperty(value="type")
        public JoinBuilder type(Type type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="kind")
        public JoinBuilder kind(Kind kind) {
            this.kind = kind;
            return this;
        }

        @JsonProperty(value="definition")
        public JoinBuilder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public Join build() {
            return new Join(this.name, this.namespace, this.to, this.type, this.kind, this.definition);
        }

        public String toString() {
            return "Join.JoinBuilder(name=" + this.name + ", namespace=" + this.namespace + ", to=" + this.to + ", type=" + this.type + ", kind=" + this.kind + ", definition=" + this.definition + ")";
        }
    }

    public static enum Type {
        LEFT("left"),
        INNER("inner"),
        FULL("full"),
        CROSS("cross");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Kind {
        TOONE("toOne"),
        TOMANY("toMany");

        private final String value;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

