/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yahoo.elide.modelconfig.model.Argument;
import com.yahoo.elide.modelconfig.model.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "friendlyName", "description", "category", "hidden", "readAccess", "definition", "maker", "type", "tags", "arguments", "filterTemplate"})
public class Measure
implements Named {
    private static final long serialVersionUID = 4404642046984907827L;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="friendlyName")
    private String friendlyName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="hidden")
    private Boolean hidden;
    @JsonProperty(value="readAccess")
    private String readAccess;
    @JsonProperty(value="definition")
    private String definition;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="maker")
    private String maker;
    @JsonProperty(value="tags")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> tags = new LinkedHashSet<String>();
    @JsonProperty(value="arguments")
    private List<Argument> arguments = new ArrayList<Argument>();
    @JsonProperty(value="filterTemplate")
    private String filterTemplate;

    public String getDescription() {
        return this.description == null ? this.getName() : this.description;
    }

    public boolean hasArgument(String argName) {
        return this.hasName(this.arguments, argName);
    }

    private static Boolean $default$hidden() {
        return false;
    }

    private static String $default$readAccess() {
        return "Prefab.Role.All";
    }

    public static MeasureBuilder builder() {
        return new MeasureBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getCategory() {
        return this.category;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public String getReadAccess() {
        return this.readAccess;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getType() {
        return this.type;
    }

    public String getMaker() {
        return this.maker;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public String getFilterTemplate() {
        return this.filterTemplate;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="friendlyName")
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @JsonProperty(value="hidden")
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @JsonProperty(value="readAccess")
    public void setReadAccess(String readAccess) {
        this.readAccess = readAccess;
    }

    @JsonProperty(value="definition")
    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="maker")
    public void setMaker(String maker) {
        this.maker = maker;
    }

    @JsonProperty(value="tags")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="arguments")
    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    @JsonProperty(value="filterTemplate")
    public void setFilterTemplate(String filterTemplate) {
        this.filterTemplate = filterTemplate;
    }

    public String toString() {
        return "Measure(name=" + this.getName() + ", friendlyName=" + this.getFriendlyName() + ", description=" + this.getDescription() + ", category=" + this.getCategory() + ", hidden=" + this.getHidden() + ", readAccess=" + this.getReadAccess() + ", definition=" + this.getDefinition() + ", type=" + this.getType() + ", maker=" + this.getMaker() + ", tags=" + this.getTags() + ", arguments=" + this.getArguments() + ", filterTemplate=" + this.getFilterTemplate() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Measure)) {
            return false;
        }
        Measure other = (Measure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$friendlyName = this.getFriendlyName();
        String other$friendlyName = other.getFriendlyName();
        if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$readAccess = this.getReadAccess();
        String other$readAccess = other.getReadAccess();
        if (this$readAccess == null ? other$readAccess != null : !this$readAccess.equals(other$readAccess)) {
            return false;
        }
        String this$definition = this.getDefinition();
        String other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$maker = this.getMaker();
        String other$maker = other.getMaker();
        if (this$maker == null ? other$maker != null : !this$maker.equals(other$maker)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Argument> this$arguments = this.getArguments();
        List<Argument> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        String this$filterTemplate = this.getFilterTemplate();
        String other$filterTemplate = other.getFilterTemplate();
        return !(this$filterTemplate == null ? other$filterTemplate != null : !this$filterTemplate.equals(other$filterTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Measure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $friendlyName = this.getFriendlyName();
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $readAccess = this.getReadAccess();
        result = result * 59 + ($readAccess == null ? 43 : $readAccess.hashCode());
        String $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $maker = this.getMaker();
        result = result * 59 + ($maker == null ? 43 : $maker.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        String $filterTemplate = this.getFilterTemplate();
        result = result * 59 + ($filterTemplate == null ? 43 : $filterTemplate.hashCode());
        return result;
    }

    public Measure(String name, String friendlyName, String description, String category, Boolean hidden, String readAccess, String definition, String type, String maker, Set<String> tags, List<Argument> arguments, String filterTemplate) {
        this.name = name;
        this.friendlyName = friendlyName;
        this.description = description;
        this.category = category;
        this.hidden = hidden;
        this.readAccess = readAccess;
        this.definition = definition;
        this.type = type;
        this.maker = maker;
        this.tags = tags;
        this.arguments = arguments;
        this.filterTemplate = filterTemplate;
    }

    public Measure() {
        this.hidden = Measure.$default$hidden();
        this.readAccess = Measure.$default$readAccess();
    }

    public static class MeasureBuilder {
        private String name;
        private String friendlyName;
        private String description;
        private String category;
        private boolean hidden$set;
        private Boolean hidden$value;
        private boolean readAccess$set;
        private String readAccess$value;
        private String definition;
        private String type;
        private String maker;
        private Set<String> tags;
        private ArrayList<Argument> arguments;
        private String filterTemplate;

        MeasureBuilder() {
        }

        @JsonProperty(value="name")
        public MeasureBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="friendlyName")
        public MeasureBuilder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        @JsonProperty(value="description")
        public MeasureBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="category")
        public MeasureBuilder category(String category) {
            this.category = category;
            return this;
        }

        @JsonProperty(value="hidden")
        public MeasureBuilder hidden(Boolean hidden) {
            this.hidden$value = hidden;
            this.hidden$set = true;
            return this;
        }

        @JsonProperty(value="readAccess")
        public MeasureBuilder readAccess(String readAccess) {
            this.readAccess$value = readAccess;
            this.readAccess$set = true;
            return this;
        }

        @JsonProperty(value="definition")
        public MeasureBuilder definition(String definition) {
            this.definition = definition;
            return this;
        }

        @JsonProperty(value="type")
        public MeasureBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="maker")
        public MeasureBuilder maker(String maker) {
            this.maker = maker;
            return this;
        }

        @JsonProperty(value="tags")
        @JsonDeserialize(as=LinkedHashSet.class)
        public MeasureBuilder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public MeasureBuilder argument(Argument argument) {
            if (this.arguments == null) {
                this.arguments = new ArrayList();
            }
            this.arguments.add(argument);
            return this;
        }

        @JsonProperty(value="arguments")
        public MeasureBuilder arguments(Collection<? extends Argument> arguments) {
            if (arguments == null) {
                throw new NullPointerException("arguments cannot be null");
            }
            if (this.arguments == null) {
                this.arguments = new ArrayList();
            }
            this.arguments.addAll(arguments);
            return this;
        }

        public MeasureBuilder clearArguments() {
            if (this.arguments != null) {
                this.arguments.clear();
            }
            return this;
        }

        @JsonProperty(value="filterTemplate")
        public MeasureBuilder filterTemplate(String filterTemplate) {
            this.filterTemplate = filterTemplate;
            return this;
        }

        public Measure build() {
            List<Argument> arguments = switch (this.arguments == null ? 0 : this.arguments.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.arguments.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Argument>(this.arguments));
            };
            Boolean hidden$value = this.hidden$value;
            if (!this.hidden$set) {
                hidden$value = Measure.$default$hidden();
            }
            String readAccess$value = this.readAccess$value;
            if (!this.readAccess$set) {
                readAccess$value = Measure.$default$readAccess();
            }
            return new Measure(this.name, this.friendlyName, this.description, this.category, hidden$value, readAccess$value, this.definition, this.type, this.maker, this.tags, arguments, this.filterTemplate);
        }

        public String toString() {
            return "Measure.MeasureBuilder(name=" + this.name + ", friendlyName=" + this.friendlyName + ", description=" + this.description + ", category=" + this.category + ", hidden$value=" + this.hidden$value + ", readAccess$value=" + this.readAccess$value + ", definition=" + this.definition + ", type=" + this.type + ", maker=" + this.maker + ", tags=" + this.tags + ", arguments=" + this.arguments + ", filterTemplate=" + this.filterTemplate + ")";
        }
    }
}

