/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Streams;
import com.yahoo.elide.modelconfig.model.Argument;
import com.yahoo.elide.modelconfig.model.Dimension;
import com.yahoo.elide.modelconfig.model.ElideTableConfig;
import com.yahoo.elide.modelconfig.model.Join;
import com.yahoo.elide.modelconfig.model.Measure;
import com.yahoo.elide.modelconfig.model.Named;
import com.yahoo.elide.modelconfig.model.NamespaceConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "friendlyName", "schema", "isFact", "hidden", "description", "cardinality", "readAccess", "namespace", "joins", "measures", "dimensions", "tags", "hints", "arguments", "extend", "sql", "maker", "table", "dbConnectionName", "filterTemplate"})
public class Table
implements Named {
    private static final long serialVersionUID = -7537337382856372741L;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="friendlyName")
    private String friendlyName;
    @JsonProperty(value="schema")
    private String schema;
    @JsonProperty(value="dbConnectionName")
    private String dbConnectionName;
    @JsonProperty(value="isFact")
    private Boolean isFact;
    @JsonProperty(value="hidden")
    private Boolean hidden;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="filterTemplate")
    private String filterTemplate;
    @JsonProperty(value="cardinality")
    private String cardinality;
    @JsonProperty(value="readAccess")
    private String readAccess;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="joins")
    private List<Join> joins = new ArrayList<Join>();
    @JsonProperty(value="measures")
    private List<Measure> measures = new ArrayList<Measure>();
    @JsonProperty(value="dimensions")
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    @JsonProperty(value="tags")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> tags;
    @JsonProperty(value="hints")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> hints;
    @JsonProperty(value="arguments")
    private List<Argument> arguments = new ArrayList<Argument>();
    @JsonProperty(value="extend")
    private String extend;
    @JsonProperty(value="sql")
    private String sql;
    @JsonProperty(value="maker")
    private String maker;
    @JsonProperty(value="table")
    private String table;

    public String getDescription() {
        return this.description == null ? this.getName() : this.description;
    }

    public boolean hasField(String fieldName) {
        return this.hasName(this.dimensions, fieldName) || this.hasName(this.measures, fieldName);
    }

    public Named getField(String fieldName) {
        return Streams.concat((Stream[])new Stream[]{this.dimensions.stream(), this.measures.stream()}).filter(col -> col.getName().equals(fieldName)).findFirst().orElse(null);
    }

    public boolean hasArgument(String argName) {
        return this.hasName(this.arguments, argName);
    }

    public boolean hasJoinField(String joinName) {
        return this.hasName(this.joins, joinName);
    }

    public Join getJoin(String joinName) {
        return this.joins.stream().filter(join -> join.getName().equals(joinName)).findFirst().orElse(null);
    }

    public boolean hasParent() {
        return StringUtils.isNotBlank((CharSequence)this.extend);
    }

    public Table getParent(ElideTableConfig elideTableConfig) {
        return elideTableConfig.getTable(this.getGlobalExtend());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGlobalName() {
        return Table.getModelName(this.name, this.namespace);
    }

    public String getGlobalExtend() {
        if (this.extend == null || this.extend.isEmpty()) {
            return this.extend;
        }
        return Table.getModelName(this.extend, this.namespace);
    }

    public static String getModelName(String tableName, String namespace) {
        if (namespace == null || namespace.isEmpty() || namespace.equals(NamespaceConfig.DEFAULT)) {
            return tableName;
        }
        return namespace + "_" + tableName;
    }

    private static Boolean $default$isFact() {
        return true;
    }

    private static Boolean $default$hidden() {
        return false;
    }

    private static String $default$readAccess() {
        return "Prefab.Role.All";
    }

    private static String $default$namespace() {
        return NamespaceConfig.DEFAULT;
    }

    private static Set<String> $default$tags() {
        return new LinkedHashSet<String>();
    }

    private static Set<String> $default$hints() {
        return new LinkedHashSet<String>();
    }

    public static TableBuilder builder() {
        return new TableBuilder();
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDbConnectionName() {
        return this.dbConnectionName;
    }

    public Boolean getIsFact() {
        return this.isFact;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public String getCategory() {
        return this.category;
    }

    public String getFilterTemplate() {
        return this.filterTemplate;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public String getReadAccess() {
        return this.readAccess;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Set<String> getHints() {
        return this.hints;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public String getExtend() {
        return this.extend;
    }

    public String getSql() {
        return this.sql;
    }

    public String getMaker() {
        return this.maker;
    }

    public String getTable() {
        return this.table;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="friendlyName")
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @JsonProperty(value="dbConnectionName")
    public void setDbConnectionName(String dbConnectionName) {
        this.dbConnectionName = dbConnectionName;
    }

    @JsonProperty(value="isFact")
    public void setIsFact(Boolean isFact) {
        this.isFact = isFact;
    }

    @JsonProperty(value="hidden")
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @JsonProperty(value="filterTemplate")
    public void setFilterTemplate(String filterTemplate) {
        this.filterTemplate = filterTemplate;
    }

    @JsonProperty(value="cardinality")
    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    @JsonProperty(value="readAccess")
    public void setReadAccess(String readAccess) {
        this.readAccess = readAccess;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="joins")
    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    @JsonProperty(value="measures")
    public void setMeasures(List<Measure> measures) {
        this.measures = measures;
    }

    @JsonProperty(value="dimensions")
    public void setDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    @JsonProperty(value="tags")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="hints")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setHints(Set<String> hints) {
        this.hints = hints;
    }

    @JsonProperty(value="arguments")
    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    @JsonProperty(value="extend")
    public void setExtend(String extend) {
        this.extend = extend;
    }

    @JsonProperty(value="sql")
    public void setSql(String sql) {
        this.sql = sql;
    }

    @JsonProperty(value="maker")
    public void setMaker(String maker) {
        this.maker = maker;
    }

    @JsonProperty(value="table")
    public void setTable(String table) {
        this.table = table;
    }

    public String toString() {
        return "Table(name=" + this.getName() + ", friendlyName=" + this.getFriendlyName() + ", schema=" + this.getSchema() + ", dbConnectionName=" + this.getDbConnectionName() + ", isFact=" + this.getIsFact() + ", hidden=" + this.getHidden() + ", description=" + this.getDescription() + ", category=" + this.getCategory() + ", filterTemplate=" + this.getFilterTemplate() + ", cardinality=" + this.getCardinality() + ", readAccess=" + this.getReadAccess() + ", namespace=" + this.getNamespace() + ", joins=" + this.getJoins() + ", measures=" + this.getMeasures() + ", dimensions=" + this.getDimensions() + ", tags=" + this.getTags() + ", hints=" + this.getHints() + ", arguments=" + this.getArguments() + ", extend=" + this.getExtend() + ", sql=" + this.getSql() + ", maker=" + this.getMaker() + ", table=" + this.getTable() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isFact = this.getIsFact();
        Boolean other$isFact = other.getIsFact();
        if (this$isFact == null ? other$isFact != null : !((Object)this$isFact).equals(other$isFact)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$friendlyName = this.getFriendlyName();
        String other$friendlyName = other.getFriendlyName();
        if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$dbConnectionName = this.getDbConnectionName();
        String other$dbConnectionName = other.getDbConnectionName();
        if (this$dbConnectionName == null ? other$dbConnectionName != null : !this$dbConnectionName.equals(other$dbConnectionName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$filterTemplate = this.getFilterTemplate();
        String other$filterTemplate = other.getFilterTemplate();
        if (this$filterTemplate == null ? other$filterTemplate != null : !this$filterTemplate.equals(other$filterTemplate)) {
            return false;
        }
        String this$cardinality = this.getCardinality();
        String other$cardinality = other.getCardinality();
        if (this$cardinality == null ? other$cardinality != null : !this$cardinality.equals(other$cardinality)) {
            return false;
        }
        String this$readAccess = this.getReadAccess();
        String other$readAccess = other.getReadAccess();
        if (this$readAccess == null ? other$readAccess != null : !this$readAccess.equals(other$readAccess)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        List<Join> this$joins = this.getJoins();
        List<Join> other$joins = other.getJoins();
        if (this$joins == null ? other$joins != null : !((Object)this$joins).equals(other$joins)) {
            return false;
        }
        List<Measure> this$measures = this.getMeasures();
        List<Measure> other$measures = other.getMeasures();
        if (this$measures == null ? other$measures != null : !((Object)this$measures).equals(other$measures)) {
            return false;
        }
        List<Dimension> this$dimensions = this.getDimensions();
        List<Dimension> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Set<String> this$hints = this.getHints();
        Set<String> other$hints = other.getHints();
        if (this$hints == null ? other$hints != null : !((Object)this$hints).equals(other$hints)) {
            return false;
        }
        List<Argument> this$arguments = this.getArguments();
        List<Argument> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        String this$extend = this.getExtend();
        String other$extend = other.getExtend();
        if (this$extend == null ? other$extend != null : !this$extend.equals(other$extend)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$maker = this.getMaker();
        String other$maker = other.getMaker();
        if (this$maker == null ? other$maker != null : !this$maker.equals(other$maker)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        return !(this$table == null ? other$table != null : !this$table.equals(other$table));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isFact = this.getIsFact();
        result = result * 59 + ($isFact == null ? 43 : ((Object)$isFact).hashCode());
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $friendlyName = this.getFriendlyName();
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $dbConnectionName = this.getDbConnectionName();
        result = result * 59 + ($dbConnectionName == null ? 43 : $dbConnectionName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $filterTemplate = this.getFilterTemplate();
        result = result * 59 + ($filterTemplate == null ? 43 : $filterTemplate.hashCode());
        String $cardinality = this.getCardinality();
        result = result * 59 + ($cardinality == null ? 43 : $cardinality.hashCode());
        String $readAccess = this.getReadAccess();
        result = result * 59 + ($readAccess == null ? 43 : $readAccess.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        List<Join> $joins = this.getJoins();
        result = result * 59 + ($joins == null ? 43 : ((Object)$joins).hashCode());
        List<Measure> $measures = this.getMeasures();
        result = result * 59 + ($measures == null ? 43 : ((Object)$measures).hashCode());
        List<Dimension> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Set<String> $hints = this.getHints();
        result = result * 59 + ($hints == null ? 43 : ((Object)$hints).hashCode());
        List<Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        String $extend = this.getExtend();
        result = result * 59 + ($extend == null ? 43 : $extend.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $maker = this.getMaker();
        result = result * 59 + ($maker == null ? 43 : $maker.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        return result;
    }

    public Table(String name, String friendlyName, String schema, String dbConnectionName, Boolean isFact, Boolean hidden, String description, String category, String filterTemplate, String cardinality, String readAccess, String namespace, List<Join> joins, List<Measure> measures, List<Dimension> dimensions, Set<String> tags, Set<String> hints, List<Argument> arguments, String extend, String sql, String maker, String table) {
        this.name = name;
        this.friendlyName = friendlyName;
        this.schema = schema;
        this.dbConnectionName = dbConnectionName;
        this.isFact = isFact;
        this.hidden = hidden;
        this.description = description;
        this.category = category;
        this.filterTemplate = filterTemplate;
        this.cardinality = cardinality;
        this.readAccess = readAccess;
        this.namespace = namespace;
        this.joins = joins;
        this.measures = measures;
        this.dimensions = dimensions;
        this.tags = tags;
        this.hints = hints;
        this.arguments = arguments;
        this.extend = extend;
        this.sql = sql;
        this.maker = maker;
        this.table = table;
    }

    public Table() {
        this.isFact = Table.$default$isFact();
        this.hidden = Table.$default$hidden();
        this.readAccess = Table.$default$readAccess();
        this.namespace = Table.$default$namespace();
        this.tags = Table.$default$tags();
        this.hints = Table.$default$hints();
    }

    public static class TableBuilder {
        private String name;
        private String friendlyName;
        private String schema;
        private String dbConnectionName;
        private boolean isFact$set;
        private Boolean isFact$value;
        private boolean hidden$set;
        private Boolean hidden$value;
        private String description;
        private String category;
        private String filterTemplate;
        private String cardinality;
        private boolean readAccess$set;
        private String readAccess$value;
        private boolean namespace$set;
        private String namespace$value;
        private ArrayList<Join> joins;
        private ArrayList<Measure> measures;
        private ArrayList<Dimension> dimensions;
        private boolean tags$set;
        private Set<String> tags$value;
        private boolean hints$set;
        private Set<String> hints$value;
        private ArrayList<Argument> arguments;
        private String extend;
        private String sql;
        private String maker;
        private String table;

        TableBuilder() {
        }

        @JsonProperty(value="name")
        public TableBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="friendlyName")
        public TableBuilder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        @JsonProperty(value="schema")
        public TableBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @JsonProperty(value="dbConnectionName")
        public TableBuilder dbConnectionName(String dbConnectionName) {
            this.dbConnectionName = dbConnectionName;
            return this;
        }

        @JsonProperty(value="isFact")
        public TableBuilder isFact(Boolean isFact) {
            this.isFact$value = isFact;
            this.isFact$set = true;
            return this;
        }

        @JsonProperty(value="hidden")
        public TableBuilder hidden(Boolean hidden) {
            this.hidden$value = hidden;
            this.hidden$set = true;
            return this;
        }

        @JsonProperty(value="description")
        public TableBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="category")
        public TableBuilder category(String category) {
            this.category = category;
            return this;
        }

        @JsonProperty(value="filterTemplate")
        public TableBuilder filterTemplate(String filterTemplate) {
            this.filterTemplate = filterTemplate;
            return this;
        }

        @JsonProperty(value="cardinality")
        public TableBuilder cardinality(String cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        @JsonProperty(value="readAccess")
        public TableBuilder readAccess(String readAccess) {
            this.readAccess$value = readAccess;
            this.readAccess$set = true;
            return this;
        }

        @JsonProperty(value="namespace")
        public TableBuilder namespace(String namespace) {
            this.namespace$value = namespace;
            this.namespace$set = true;
            return this;
        }

        public TableBuilder join(Join join) {
            if (this.joins == null) {
                this.joins = new ArrayList();
            }
            this.joins.add(join);
            return this;
        }

        @JsonProperty(value="joins")
        public TableBuilder joins(Collection<? extends Join> joins) {
            if (joins == null) {
                throw new NullPointerException("joins cannot be null");
            }
            if (this.joins == null) {
                this.joins = new ArrayList();
            }
            this.joins.addAll(joins);
            return this;
        }

        public TableBuilder clearJoins() {
            if (this.joins != null) {
                this.joins.clear();
            }
            return this;
        }

        public TableBuilder measure(Measure measure) {
            if (this.measures == null) {
                this.measures = new ArrayList();
            }
            this.measures.add(measure);
            return this;
        }

        @JsonProperty(value="measures")
        public TableBuilder measures(Collection<? extends Measure> measures) {
            if (measures == null) {
                throw new NullPointerException("measures cannot be null");
            }
            if (this.measures == null) {
                this.measures = new ArrayList();
            }
            this.measures.addAll(measures);
            return this;
        }

        public TableBuilder clearMeasures() {
            if (this.measures != null) {
                this.measures.clear();
            }
            return this;
        }

        public TableBuilder dimension(Dimension dimension) {
            if (this.dimensions == null) {
                this.dimensions = new ArrayList();
            }
            this.dimensions.add(dimension);
            return this;
        }

        @JsonProperty(value="dimensions")
        public TableBuilder dimensions(Collection<? extends Dimension> dimensions) {
            if (dimensions == null) {
                throw new NullPointerException("dimensions cannot be null");
            }
            if (this.dimensions == null) {
                this.dimensions = new ArrayList();
            }
            this.dimensions.addAll(dimensions);
            return this;
        }

        public TableBuilder clearDimensions() {
            if (this.dimensions != null) {
                this.dimensions.clear();
            }
            return this;
        }

        @JsonProperty(value="tags")
        @JsonDeserialize(as=LinkedHashSet.class)
        public TableBuilder tags(Set<String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return this;
        }

        @JsonProperty(value="hints")
        @JsonDeserialize(as=LinkedHashSet.class)
        public TableBuilder hints(Set<String> hints) {
            this.hints$value = hints;
            this.hints$set = true;
            return this;
        }

        public TableBuilder argument(Argument argument) {
            if (this.arguments == null) {
                this.arguments = new ArrayList();
            }
            this.arguments.add(argument);
            return this;
        }

        @JsonProperty(value="arguments")
        public TableBuilder arguments(Collection<? extends Argument> arguments) {
            if (arguments == null) {
                throw new NullPointerException("arguments cannot be null");
            }
            if (this.arguments == null) {
                this.arguments = new ArrayList();
            }
            this.arguments.addAll(arguments);
            return this;
        }

        public TableBuilder clearArguments() {
            if (this.arguments != null) {
                this.arguments.clear();
            }
            return this;
        }

        @JsonProperty(value="extend")
        public TableBuilder extend(String extend) {
            this.extend = extend;
            return this;
        }

        @JsonProperty(value="sql")
        public TableBuilder sql(String sql) {
            this.sql = sql;
            return this;
        }

        @JsonProperty(value="maker")
        public TableBuilder maker(String maker) {
            this.maker = maker;
            return this;
        }

        @JsonProperty(value="table")
        public TableBuilder table(String table) {
            this.table = table;
            return this;
        }

        public Table build() {
            List<Join> joins = switch (this.joins == null ? 0 : this.joins.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.joins.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Join>(this.joins));
            };
            List<Measure> measures = switch (this.measures == null ? 0 : this.measures.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.measures.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Measure>(this.measures));
            };
            List<Dimension> dimensions = switch (this.dimensions == null ? 0 : this.dimensions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.dimensions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Dimension>(this.dimensions));
            };
            List<Argument> arguments = switch (this.arguments == null ? 0 : this.arguments.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.arguments.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Argument>(this.arguments));
            };
            Boolean isFact$value = this.isFact$value;
            if (!this.isFact$set) {
                isFact$value = Table.$default$isFact();
            }
            Boolean hidden$value = this.hidden$value;
            if (!this.hidden$set) {
                hidden$value = Table.$default$hidden();
            }
            String readAccess$value = this.readAccess$value;
            if (!this.readAccess$set) {
                readAccess$value = Table.$default$readAccess();
            }
            String namespace$value = this.namespace$value;
            if (!this.namespace$set) {
                namespace$value = Table.$default$namespace();
            }
            Set<String> tags$value = this.tags$value;
            if (!this.tags$set) {
                tags$value = Table.$default$tags();
            }
            Set<String> hints$value = this.hints$value;
            if (!this.hints$set) {
                hints$value = Table.$default$hints();
            }
            return new Table(this.name, this.friendlyName, this.schema, this.dbConnectionName, isFact$value, hidden$value, this.description, this.category, this.filterTemplate, this.cardinality, readAccess$value, namespace$value, joins, measures, dimensions, tags$value, hints$value, arguments, this.extend, this.sql, this.maker, this.table);
        }

        public String toString() {
            return "Table.TableBuilder(name=" + this.name + ", friendlyName=" + this.friendlyName + ", schema=" + this.schema + ", dbConnectionName=" + this.dbConnectionName + ", isFact$value=" + this.isFact$value + ", hidden$value=" + this.hidden$value + ", description=" + this.description + ", category=" + this.category + ", filterTemplate=" + this.filterTemplate + ", cardinality=" + this.cardinality + ", readAccess$value=" + this.readAccess$value + ", namespace$value=" + this.namespace$value + ", joins=" + this.joins + ", measures=" + this.measures + ", dimensions=" + this.dimensions + ", tags$value=" + this.tags$value + ", hints$value=" + this.hints$value + ", arguments=" + this.arguments + ", extend=" + this.extend + ", sql=" + this.sql + ", maker=" + this.maker + ", table=" + this.table + ")";
        }
    }
}

