/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yahoo.elide.modelconfig.model.NamespaceConfig;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"table", "namespace", "column", "suggestionColumns"})
public class TableSource
implements Serializable {
    private static final long serialVersionUID = 5721654374755116755L;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="namespace")
    private String namespace = NamespaceConfig.DEFAULT;
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="suggestionColumns")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> suggestionColumns = new LinkedHashSet<String>();

    public static TableSourceBuilder builder() {
        return new TableSourceBuilder();
    }

    public String getTable() {
        return this.table;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getColumn() {
        return this.column;
    }

    public Set<String> getSuggestionColumns() {
        return this.suggestionColumns;
    }

    @JsonProperty(value="table")
    public void setTable(String table) {
        this.table = table;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="column")
    public void setColumn(String column) {
        this.column = column;
    }

    @JsonProperty(value="suggestionColumns")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setSuggestionColumns(Set<String> suggestionColumns) {
        this.suggestionColumns = suggestionColumns;
    }

    public String toString() {
        return "TableSource(table=" + this.getTable() + ", namespace=" + this.getNamespace() + ", column=" + this.getColumn() + ", suggestionColumns=" + this.getSuggestionColumns() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableSource)) {
            return false;
        }
        TableSource other = (TableSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        Set<String> this$suggestionColumns = this.getSuggestionColumns();
        Set<String> other$suggestionColumns = other.getSuggestionColumns();
        return !(this$suggestionColumns == null ? other$suggestionColumns != null : !((Object)this$suggestionColumns).equals(other$suggestionColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        Set<String> $suggestionColumns = this.getSuggestionColumns();
        result = result * 59 + ($suggestionColumns == null ? 43 : ((Object)$suggestionColumns).hashCode());
        return result;
    }

    public TableSource(String table, String namespace, String column, Set<String> suggestionColumns) {
        this.table = table;
        this.namespace = namespace;
        this.column = column;
        this.suggestionColumns = suggestionColumns;
    }

    public TableSource() {
    }

    public static class TableSourceBuilder {
        private String table;
        private String namespace;
        private String column;
        private Set<String> suggestionColumns;

        TableSourceBuilder() {
        }

        @JsonProperty(value="table")
        public TableSourceBuilder table(String table) {
            this.table = table;
            return this;
        }

        @JsonProperty(value="namespace")
        public TableSourceBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="column")
        public TableSourceBuilder column(String column) {
            this.column = column;
            return this;
        }

        @JsonProperty(value="suggestionColumns")
        @JsonDeserialize(as=LinkedHashSet.class)
        public TableSourceBuilder suggestionColumns(Set<String> suggestionColumns) {
            this.suggestionColumns = suggestionColumns;
            return this;
        }

        public TableSource build() {
            return new TableSource(this.table, this.namespace, this.column, this.suggestionColumns);
        }

        public String toString() {
            return "TableSource.TableSourceBuilder(table=" + this.table + ", namespace=" + this.namespace + ", column=" + this.column + ", suggestionColumns=" + this.suggestionColumns + ")";
        }
    }
}

