/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.store;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreIterableBuilder;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.modelconfig.io.FileLoader;
import com.yahoo.elide.modelconfig.store.models.ConfigFile;
import com.yahoo.elide.modelconfig.validator.Validator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDataStoreTransaction
implements DataStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(ConfigDataStoreTransaction.class);
    private final FileLoader fileLoader;
    private final Set<Runnable> todo;
    private final Set<ConfigFile> dirty;
    private final Set<String> deleted;
    private final Validator validator;
    private final boolean readOnly;

    public ConfigDataStoreTransaction(FileLoader fileLoader, boolean readOnly, Validator validator) {
        this.fileLoader = fileLoader;
        this.readOnly = readOnly || !fileLoader.isWriteable();
        this.dirty = new LinkedHashSet<ConfigFile>();
        this.deleted = new LinkedHashSet<String>();
        this.todo = new LinkedHashSet<Runnable>();
        this.validator = validator;
    }

    public <T> void save(T entity, RequestScope scope) {
        ConfigFile file = (ConfigFile)entity;
        boolean canWrite = scope.isNewResource((Object)file) ? this.canCreate(file.getPath()) : this.canModify(file.getPath());
        if (this.readOnly || !canWrite) {
            log.error("Attempt to modify a read only configuration");
            throw new UnsupportedOperationException("Configuration is read only.");
        }
        this.dirty.add(file);
        this.todo.add(() -> this.updateFile(file.getPath(), file.getContent()));
    }

    public <T> void delete(T entity, RequestScope scope) {
        ConfigFile file = (ConfigFile)entity;
        if (this.readOnly || !this.canModify(file.getPath())) {
            log.error("Attempt to modify a read only configuration");
            throw new UnsupportedOperationException("Configuration is read only.");
        }
        this.dirty.add(file);
        this.deleted.add(file.getPath());
        this.todo.add(() -> this.deleteFile(file.getPath()));
    }

    public void flush(RequestScope scope) {
        if (!this.readOnly) {
            Map<String, ConfigFile> resources;
            try {
                resources = this.fileLoader.loadResources();
            }
            catch (IOException e) {
                log.error("Error reading configuration resources: {}", (Object)e.getMessage());
                throw new IllegalStateException(e);
            }
            for (ConfigFile file : this.dirty) {
                resources.put(file.getPath(), file);
            }
            for (String path : this.deleted) {
                resources.remove(path);
            }
            try {
                this.validator.validate(resources);
            }
            catch (Exception e) {
                log.error("Error validating configuration: {}", (Object)e.getMessage());
                throw new BadRequestException(e.getMessage());
            }
        }
    }

    public void commit(RequestScope scope) {
        boolean validateOnly;
        boolean bl = validateOnly = scope.getRoute().getHeaders().get("ValidateOnly") != null;
        if (!validateOnly) {
            for (Runnable runnable : this.todo) {
                runnable.run();
            }
        }
    }

    public <T> void createObject(T entity, RequestScope scope) {
        ConfigFile file = (ConfigFile)entity;
        if (this.readOnly || !this.canCreate(file.getPath())) {
            log.error("Attempt to modify a read only configuration");
            throw new UnsupportedOperationException("Configuration is read only.");
        }
        this.dirty.add(file);
        this.todo.add(() -> {
            file.setId(ConfigFile.toId(file.getPath(), file.getVersion()));
            this.createFile(file.getPath());
            this.updateFile(file.getPath(), file.getContent());
        });
    }

    public <T> T loadObject(EntityProjection entityProjection, Serializable id, RequestScope scope) {
        String path = ConfigFile.fromId(id.toString());
        try {
            return (T)this.fileLoader.loadResource(path);
        }
        catch (IOException e) {
            log.error("Error reading configuration resources for {} : {}", (Object)id, (Object)e.getMessage());
            return null;
        }
    }

    public <T> DataStoreIterable<T> loadObjects(EntityProjection entityProjection, RequestScope scope) {
        try {
            Map<String, ConfigFile> resources = this.fileLoader.loadResources();
            return new DataStoreIterableBuilder(resources.values()).allInMemory().build();
        }
        catch (IOException e) {
            log.error("Error reading configuration resources: {}", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    public void cancel(RequestScope scope) {
        this.todo.clear();
        this.dirty.clear();
        this.deleted.clear();
    }

    public void close() throws IOException {
    }

    private boolean canCreate(String filePath) {
        File directory;
        Path path = Path.of(this.fileLoader.getRootPath(), filePath);
        for (directory = path.toFile().getParentFile(); directory != null && !directory.exists(); directory = directory.getParentFile()) {
        }
        return directory != null && Files.isWritable(directory.toPath());
    }

    private boolean canModify(String filePath) {
        Path path = Path.of(this.fileLoader.getRootPath(), filePath);
        File file = path.toFile();
        return !file.exists() || Files.isWritable(file.toPath());
    }

    private void deleteFile(String path) {
        Path deletePath = Path.of(this.fileLoader.getRootPath(), path);
        if (!Files.exists(deletePath, new LinkOption[0])) {
            return;
        }
        try {
            Files.delete(deletePath);
        }
        catch (IOException e) {
            log.error("Error deleting file: {} with message: {}", (Object)deletePath, (Object)e.getMessage());
            throw new IllegalStateException("Unable to delete: " + deletePath, e);
        }
    }

    private void updateFile(String path, String content) {
        Path updatePath = Path.of(this.fileLoader.getRootPath(), path);
        try {
            Files.writeString(updatePath, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Error updating file: {} with message: {}", (Object)updatePath, (Object)e.getMessage());
            throw new IllegalStateException("Unable to update:" + updatePath, e);
        }
    }

    private void createFile(String path) {
        Path createPath = Path.of(this.fileLoader.getRootPath(), path);
        File file = createPath.toFile();
        if (file.exists()) {
            log.debug("File already exits: {}", (Object)file.getPath());
            return;
        }
        try {
            File parentDirectory = file.getParentFile();
            Files.createDirectories(Path.of(parentDirectory.getPath(), new String[0]), new FileAttribute[0]);
            boolean created = file.createNewFile();
            if (!created) {
                log.error("Unable to create file: {}", (Object)file.getPath());
                throw new IllegalStateException("Unable to create file: " + path);
            }
        }
        catch (IOException e) {
            log.error("Error creating file: {} with message: {}", (Object)file.getPath(), (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }
}

