/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.store.models;

import com.yahoo.elide.annotation.ComputedAttribute;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.exceptions.BadRequestException;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Supplier;

@Include(name="config")
@ReadPermission(expression="Can Read Config")
@UpdatePermission(expression="Can Update Config")
@DeletePermission(expression="Can Delete Config")
@CreatePermission(expression="Can Create Config")
public class ConfigFile {
    @Id
    @GeneratedValue
    private String id;
    @UpdatePermission(expression="NONE")
    private String path;
    private String version;
    @Exclude
    private Supplier<String> contentProvider;
    @Exclude
    private String content;
    private ConfigFileType type;

    @ComputedAttribute
    public String getContent() {
        if (this.content == null) {
            if (this.contentProvider == null) {
                return null;
            }
            this.content = this.contentProvider.get();
        }
        return this.content;
    }

    public ConfigFile(String path, String version, ConfigFileType type, Supplier<String> contentProvider) {
        this.id = ConfigFile.toId(path, version);
        this.path = path;
        this.version = version == null ? "" : version;
        this.contentProvider = contentProvider;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigFile that = (ConfigFile)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.version);
    }

    public static String toId(String path, String version) {
        Object id = version == null || version.isEmpty() ? path : path + "-" + version;
        return Base64.getEncoder().encodeToString(((String)id).getBytes());
    }

    public static String fromId(String id) {
        String idString;
        try {
            idString = URLDecoder.decode(id, "UTF-8");
            idString = new String(Base64.getDecoder().decode(idString.getBytes()));
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            throw new BadRequestException("Invalid ID: " + id);
        }
        int hyphenIndex = idString.lastIndexOf(".hjson-");
        String path = hyphenIndex < 0 ? idString : idString.substring(0, idString.lastIndexOf(45));
        return path;
    }

    public static ConfigFileBuilder builder() {
        return new ConfigFileBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public Supplier<String> getContentProvider() {
        return this.contentProvider;
    }

    public ConfigFileType getType() {
        return this.type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setContentProvider(Supplier<String> contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setType(ConfigFileType type) {
        this.type = type;
    }

    public String toString() {
        return "ConfigFile(id=" + this.getId() + ", path=" + this.getPath() + ", version=" + this.getVersion() + ", contentProvider=" + this.getContentProvider() + ", content=" + this.getContent() + ", type=" + this.getType() + ")";
    }

    public ConfigFile() {
    }

    public static enum ConfigFileType {
        NAMESPACE,
        TABLE,
        VARIABLE,
        DATABASE,
        SECURITY,
        UNKNOWN;

    }

    public static class ConfigFileBuilder {
        private String path;
        private String version;
        private ConfigFileType type;
        private Supplier<String> contentProvider;

        ConfigFileBuilder() {
        }

        public ConfigFileBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ConfigFileBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ConfigFileBuilder type(ConfigFileType type) {
            this.type = type;
            return this;
        }

        public ConfigFileBuilder contentProvider(Supplier<String> contentProvider) {
            this.contentProvider = contentProvider;
            return this;
        }

        public ConfigFile build() {
            return new ConfigFile(this.path, this.version, this.type, this.contentProvider);
        }

        public String toString() {
            return "ConfigFile.ConfigFileBuilder(path=" + this.path + ", version=" + this.version + ", type=" + this.type + ", contentProvider=" + this.contentProvider + ")";
        }
    }
}

