/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.validator;

import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.SecurityCheck;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.EntityPermissions;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.security.checks.FilterExpressionCheck;
import com.yahoo.elide.core.security.checks.UserCheck;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.DefaultClassScanner;
import com.yahoo.elide.modelconfig.Config;
import com.yahoo.elide.modelconfig.DynamicConfigHelpers;
import com.yahoo.elide.modelconfig.DynamicConfigSchemaValidator;
import com.yahoo.elide.modelconfig.DynamicConfiguration;
import com.yahoo.elide.modelconfig.io.FileLoader;
import com.yahoo.elide.modelconfig.model.Argument;
import com.yahoo.elide.modelconfig.model.DBConfig;
import com.yahoo.elide.modelconfig.model.Dimension;
import com.yahoo.elide.modelconfig.model.ElideDBConfig;
import com.yahoo.elide.modelconfig.model.ElideNamespaceConfig;
import com.yahoo.elide.modelconfig.model.ElideSQLDBConfig;
import com.yahoo.elide.modelconfig.model.ElideSecurityConfig;
import com.yahoo.elide.modelconfig.model.ElideTableConfig;
import com.yahoo.elide.modelconfig.model.Join;
import com.yahoo.elide.modelconfig.model.Measure;
import com.yahoo.elide.modelconfig.model.Named;
import com.yahoo.elide.modelconfig.model.NamespaceConfig;
import com.yahoo.elide.modelconfig.model.Table;
import com.yahoo.elide.modelconfig.model.TableSource;
import com.yahoo.elide.modelconfig.store.models.ConfigFile;
import com.yahoo.elide.modelconfig.validator.PermissionExpressionVisitor;
import com.yahoo.elide.modelconfig.validator.Validator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;

public class DynamicConfigValidator
implements DynamicConfiguration,
Validator {
    private static final Set<String> SQL_DISALLOWED_WORDS = new HashSet<String>(Arrays.asList("DROP", "TRUNCATE", "DELETE", "INSERT", "UPDATE", "ALTER", "COMMENT", "CREATE", "DESCRIBE", "SHOW", "USE", "GRANT", "REVOKE", "CONNECT", "LOCK", "EXPLAIN", "CALL", "MERGE", "RENAME"));
    private static final String SQL_SPLIT_REGEX = "\\s+";
    private static final String SEMI_COLON = ";";
    private static final Pattern HANDLEBAR_REGEX = Pattern.compile("<%(.*?)%>");
    private final ElideTableConfig elideTableConfig = new ElideTableConfig();
    private ElideSecurityConfig elideSecurityConfig;
    private Map<String, Object> modelVariables;
    private Map<String, Object> dbVariables;
    private final ElideDBConfig elideSQLDBConfig = new ElideSQLDBConfig();
    private final ElideNamespaceConfig elideNamespaceConfig = new ElideNamespaceConfig();
    private final DynamicConfigSchemaValidator schemaValidator = new DynamicConfigSchemaValidator();
    private final EntityDictionary dictionary;
    private final FileLoader fileLoader;
    private static final Pattern FILTER_VARIABLE_PATTERN = Pattern.compile(".*?\\{\\{(\\w+)\\}\\}");

    public DynamicConfigValidator(ClassScanner scanner, String configDir) {
        this.dictionary = EntityDictionary.builder().scanner(scanner).build();
        this.fileLoader = new FileLoader(configDir);
        this.initialize();
    }

    private void initialize() {
        Set annotatedClasses = this.dictionary.getScanner().getAnnotatedClasses(Arrays.asList(Include.class, SecurityCheck.class));
        annotatedClasses.forEach(cls -> {
            if (cls.getAnnotation(Include.class) != null) {
                this.dictionary.bindEntity(cls);
            } else {
                this.dictionary.addSecurityCheck(cls);
            }
        });
    }

    public static void main(String[] args) {
        Options options = DynamicConfigValidator.prepareOptions();
        try {
            CommandLine cli = new DefaultParser().parse(options, args);
            if (cli.hasOption("help")) {
                DynamicConfigValidator.printHelp(options);
                System.exit(0);
            }
            if (!cli.hasOption("configDir")) {
                DynamicConfigValidator.printHelp(options);
                System.err.println("Missing required option");
                System.exit(1);
            }
            String configDir = cli.getOptionValue("configDir");
            DynamicConfigValidator dynamicConfigValidator = new DynamicConfigValidator((ClassScanner)new DefaultClassScanner(), configDir);
            dynamicConfigValidator.readAndValidateConfigs();
            System.out.println("Configs Validation Passed!");
            System.exit(0);
        }
        catch (Exception e) {
            String msg = StringUtils.isBlank((CharSequence)e.getMessage()) ? "Process Failed!" : e.getMessage();
            System.err.println(msg);
            System.exit(2);
        }
    }

    @Override
    public void validate(Map<String, ConfigFile> resourceMap) {
        resourceMap.forEach((path, file) -> {
            if (file.getContent() == null || file.getContent().isEmpty()) {
                throw new BadRequestException(String.format("Null or empty file content for %s", file.getPath()));
            }
            if (file.getType().equals((Object)ConfigFile.ConfigFileType.UNKNOWN)) {
                throw new BadRequestException(String.format("Unrecognized File: %s", file.getPath()));
            }
            if (path.contains("..")) {
                throw new BadRequestException(String.format("Parent directory traversal not allowed: %s", file.getPath()));
            }
            if (!file.getType().equals((Object)FileLoader.toType(path))) {
                throw new BadRequestException(String.format("File type %s does not match file path: %s", new Object[]{file.getType(), file.getPath()}));
            }
        });
        this.readConfigs(resourceMap);
        this.validateConfigs();
    }

    public void readAndValidateConfigs() throws IOException {
        Map<String, ConfigFile> loadedFiles = this.fileLoader.loadResources();
        this.validate(loadedFiles);
    }

    public void readConfigs() throws IOException {
        this.readConfigs(this.fileLoader.loadResources());
    }

    public void readConfigs(Map<String, ConfigFile> resourceMap) {
        this.modelVariables = this.readVariableConfig(Config.MODELVARIABLE, resourceMap);
        this.elideSecurityConfig = this.readSecurityConfig(resourceMap);
        this.dbVariables = this.readVariableConfig(Config.DBVARIABLE, resourceMap);
        this.elideSQLDBConfig.setDbconfigs(this.readDbConfig(resourceMap));
        this.elideTableConfig.setTables(this.readTableConfig(resourceMap));
        this.elideNamespaceConfig.setNamespaceconfigs(this.readNamespaceConfig(resourceMap));
        this.populateInheritance(this.elideTableConfig);
    }

    public void validateConfigs() {
        this.validateSecurityConfig();
        boolean configurationExists = this.validateRequiredConfigsProvided();
        if (configurationExists) {
            DynamicConfigValidator.validateNameUniqueness(this.elideSQLDBConfig.getDbconfigs(), "Multiple DB configs found with the same name: ");
            DynamicConfigValidator.validateNameUniqueness(this.elideTableConfig.getTables(), "Multiple Table configs found with the same name: ");
            this.validateTableConfig();
            DynamicConfigValidator.validateNameUniqueness(this.elideNamespaceConfig.getNamespaceconfigs(), "Multiple Namespace configs found with the same name: ");
            this.validateNamespaceConfig();
            DynamicConfigValidator.validateJoinedTablesDBConnectionName(this.elideTableConfig);
        }
    }

    @Override
    public Set<Table> getTables() {
        return this.elideTableConfig.getTables();
    }

    @Override
    public Set<String> getRoles() {
        return this.elideSecurityConfig.getRoles();
    }

    @Override
    public Set<DBConfig> getDatabaseConfigurations() {
        return this.elideSQLDBConfig.getDbconfigs();
    }

    @Override
    public Set<NamespaceConfig> getNamespaceConfigurations() {
        return this.elideNamespaceConfig.getNamespaceconfigs();
    }

    private static void validateInheritance(ElideTableConfig tables) {
        tables.getTables().stream().forEach(table -> DynamicConfigValidator.validateInheritance(tables, table, new HashSet<Table>()));
    }

    private static void validateInheritance(ElideTableConfig tables, Table table, Set<Table> visited) {
        visited.add(table);
        if (!table.hasParent()) {
            return;
        }
        Table parent = table.getParent(tables);
        if (parent == null) {
            throw new IllegalStateException("Undefined model: " + table.getExtend() + " is used as a Parent(extend) for another model.");
        }
        if (visited.contains(parent)) {
            throw new IllegalStateException(String.format("Inheriting from table '%s' creates an illegal cyclic dependency.", parent.getName()));
        }
        DynamicConfigValidator.validateInheritance(tables, parent, visited);
    }

    private void populateInheritance(ElideTableConfig elideTableConfig) {
        DynamicConfigValidator.validateInheritance(this.elideTableConfig);
        HashSet processed = new HashSet();
        elideTableConfig.getTables().stream().forEach(table -> this.populateInheritance((Table)table, processed));
    }

    private void populateInheritance(Table table, Set<Table> processed) {
        if (processed.contains(table)) {
            return;
        }
        processed.add(table);
        if (!table.hasParent()) {
            return;
        }
        Table parent = table.getParent(this.elideTableConfig);
        if (!processed.contains(parent)) {
            this.populateInheritance(parent, processed);
        }
        Map<String, Measure> measures = this.getInheritedMeasures(parent, this.attributesListToMap(table.getMeasures()));
        table.setMeasures(new ArrayList<Measure>(measures.values()));
        Map<String, Dimension> dimensions = this.getInheritedDimensions(parent, this.attributesListToMap(table.getDimensions()));
        table.setDimensions(new ArrayList<Dimension>(dimensions.values()));
        Map<String, Join> joins = this.getInheritedJoins(parent, this.attributesListToMap(table.getJoins()));
        table.setJoins(new ArrayList<Join>(joins.values()));
        String schema = this.getInheritedSchema(parent, table.getSchema());
        table.setSchema(schema);
        String dbConnectionName = this.getInheritedConnection(parent, table.getDbConnectionName());
        table.setDbConnectionName(dbConnectionName);
        String sql = this.getInheritedSql(parent, table.getSql());
        table.setSql(sql);
        String tableName = this.getInheritedTable(parent, table.getTable());
        table.setTable(tableName);
        List<Argument> arguments = this.getInheritedArguments(parent, table.getArguments());
        table.setArguments(arguments);
    }

    private <T extends Named> Map<String, T> attributesListToMap(List<T> attributes) {
        return attributes.stream().collect(Collectors.toMap(Named::getName, attribute -> attribute));
    }

    private Map<String, Measure> getInheritedMeasures(Table table, Map<String, Measure> measures) {
        Inheritance<Object> action = () -> {
            table.getMeasures().forEach(measure -> {
                if (!measures.containsKey(measure.getName())) {
                    measures.put(measure.getName(), (Measure)measure);
                }
            });
            return measures;
        };
        action.inherit();
        return measures;
    }

    private Map<String, Dimension> getInheritedDimensions(Table table, Map<String, Dimension> dimensions) {
        Inheritance<Object> action = () -> {
            table.getDimensions().forEach(dimension -> {
                if (!dimensions.containsKey(dimension.getName())) {
                    dimensions.put(dimension.getName(), (Dimension)dimension);
                }
            });
            return dimensions;
        };
        action.inherit();
        return dimensions;
    }

    private Map<String, Join> getInheritedJoins(Table table, Map<String, Join> joins) {
        Inheritance<Object> action = () -> {
            table.getJoins().forEach(join -> {
                if (!joins.containsKey(join.getName())) {
                    joins.put(join.getName(), (Join)join);
                }
            });
            return joins;
        };
        action.inherit();
        return joins;
    }

    private <T> T getInheritedAttribute(Inheritance<T> action, T property) {
        return property == null ? action.inherit() : property;
    }

    private <T extends Collection<?>> T getInheritedAttribute(Inheritance<T> action, T property) {
        return (T)(property == null || property.isEmpty() ? (Collection)action.inherit() : property);
    }

    private String getInheritedSchema(Table table, String schema) {
        return this.getInheritedAttribute(table::getSchema, schema);
    }

    private String getInheritedConnection(Table table, String connection) {
        return this.getInheritedAttribute(table::getDbConnectionName, connection);
    }

    private String getInheritedSql(Table table, String sql) {
        return this.getInheritedAttribute(table::getSql, sql);
    }

    private String getInheritedTable(Table table, String tableName) {
        return this.getInheritedAttribute(table::getTable, tableName);
    }

    private List<Argument> getInheritedArguments(Table table, List<Argument> arguments) {
        return this.getInheritedAttribute(table::getArguments, arguments);
    }

    private Map<String, Object> readVariableConfig(Config config, Map<String, ConfigFile> resourceMap) {
        return resourceMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(config.getConfigPath())).map(entry -> {
            try {
                return DynamicConfigHelpers.stringToVariablesPojo((String)entry.getKey(), ((ConfigFile)entry.getValue()).getContent(), this.schemaValidator);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }).findFirst().orElse(new HashMap());
    }

    private ElideSecurityConfig readSecurityConfig(Map<String, ConfigFile> resourceMap) {
        return resourceMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(Config.SECURITY.getConfigPath())).map(entry -> {
            try {
                String content = ((ConfigFile)entry.getValue()).getContent();
                DynamicConfigValidator.validateConfigForMissingVariables(content, this.modelVariables);
                return DynamicConfigHelpers.stringToElideSecurityPojo((String)entry.getKey(), content, this.modelVariables, this.schemaValidator);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }).findAny().orElse(new ElideSecurityConfig());
    }

    private Set<DBConfig> readDbConfig(Map<String, ConfigFile> resourceMap) {
        return resourceMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(Config.SQLDBConfig.getConfigPath())).map(entry -> {
            try {
                String content = ((ConfigFile)entry.getValue()).getContent();
                DynamicConfigValidator.validateConfigForMissingVariables(content, this.dbVariables);
                return DynamicConfigHelpers.stringToElideDBConfigPojo((String)entry.getKey(), content, this.dbVariables, this.schemaValidator);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }).flatMap(dbconfig -> dbconfig.getDbconfigs().stream()).collect(Collectors.toSet());
    }

    private Set<NamespaceConfig> readNamespaceConfig(Map<String, ConfigFile> resourceMap) {
        return resourceMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(Config.NAMESPACEConfig.getConfigPath())).map(entry -> {
            try {
                String content = ((ConfigFile)entry.getValue()).getContent();
                DynamicConfigValidator.validateConfigForMissingVariables(content, this.modelVariables);
                String fileName = (String)entry.getKey();
                return DynamicConfigHelpers.stringToElideNamespaceConfigPojo(fileName, content, this.modelVariables, this.schemaValidator);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }).flatMap(namespaceconfig -> namespaceconfig.getNamespaceconfigs().stream()).collect(Collectors.toSet());
    }

    private Set<Table> readTableConfig(Map<String, ConfigFile> resourceMap) {
        return resourceMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(Config.TABLE.getConfigPath())).map(entry -> {
            try {
                String content = ((ConfigFile)entry.getValue()).getContent();
                DynamicConfigValidator.validateConfigForMissingVariables(content, this.modelVariables);
                return DynamicConfigHelpers.stringToElideTablePojo((String)entry.getKey(), content, this.modelVariables, this.schemaValidator);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }).flatMap(table -> table.getTables().stream()).collect(Collectors.toSet());
    }

    private boolean validateRequiredConfigsProvided() {
        return !this.elideTableConfig.getTables().isEmpty() || !this.elideSQLDBConfig.getDbconfigs().isEmpty();
    }

    private static void validateConfigForMissingVariables(String config, Map<String, Object> variables) {
        Matcher regexMatcher = HANDLEBAR_REGEX.matcher(config);
        while (regexMatcher.find()) {
            String str = regexMatcher.group(1).trim();
            if (variables.containsKey(str)) continue;
            throw new IllegalStateException(str + " is used as a variable in either table or security config files but is not defined in variables config file.");
        }
    }

    private boolean validateTableConfig() {
        HashSet<String> extractedFieldChecks = new HashSet<String>();
        HashSet<String> extractedTableChecks = new HashSet<String>();
        PermissionExpressionVisitor visitor = new PermissionExpressionVisitor();
        for (Table table : this.elideTableConfig.getTables()) {
            DynamicConfigValidator.validateSql(table.getSql());
            this.validateArguments(table, table.getArguments(), table.getFilterTemplate());
            this.validateNamespaceExists(table.getNamespace(), "");
            HashSet tableFields = new HashSet();
            table.getDimensions().forEach(dim -> {
                DynamicConfigValidator.validateFieldNameUniqueness(tableFields, dim.getName(), table.getName());
                DynamicConfigValidator.validateSql(dim.getDefinition());
                this.validateTableSource(dim.getTableSource());
                this.validateArguments(table, dim.getArguments(), dim.getFilterTemplate());
                DynamicConfigValidator.extractChecksFromExpr(dim.getReadAccess(), extractedFieldChecks, visitor);
            });
            table.getMeasures().forEach(measure -> {
                DynamicConfigValidator.validateFieldNameUniqueness(tableFields, measure.getName(), table.getName());
                DynamicConfigValidator.validateSql(measure.getDefinition());
                this.validateArguments(table, measure.getArguments(), measure.getFilterTemplate());
                DynamicConfigValidator.extractChecksFromExpr(measure.getReadAccess(), extractedFieldChecks, visitor);
            });
            table.getJoins().forEach(join -> {
                DynamicConfigValidator.validateFieldNameUniqueness(tableFields, join.getName(), table.getName());
                DynamicConfigValidator.validateSql(join.getDefinition());
                this.validateModelExists(join.getTo());
                this.validateNamespaceExists(join.getNamespace(), "");
            });
            DynamicConfigValidator.extractChecksFromExpr(table.getReadAccess(), extractedTableChecks, visitor);
        }
        this.validateChecks(extractedTableChecks, extractedFieldChecks);
        return true;
    }

    private boolean validateNamespaceConfig() {
        HashSet<String> extractedChecks = new HashSet<String>();
        PermissionExpressionVisitor visitor = new PermissionExpressionVisitor();
        for (NamespaceConfig namespace : this.elideNamespaceConfig.getNamespaceconfigs()) {
            DynamicConfigValidator.extractChecksFromExpr(namespace.getReadAccess(), extractedChecks, visitor);
        }
        this.validateChecks(extractedChecks, Collections.emptySet());
        return true;
    }

    private void validateArguments(Table table, List<Argument> arguments, String requiredFilter) {
        ArrayList<Argument> allArguments = new ArrayList<Argument>(arguments);
        if (requiredFilter != null) {
            Matcher matcher = FILTER_VARIABLE_PATTERN.matcher(requiredFilter);
            while (matcher.find()) {
                allArguments.add(Argument.builder().name(matcher.group(1)).build());
            }
        }
        DynamicConfigValidator.validateNameUniqueness(allArguments, "Multiple Arguments found with the same name: ");
        arguments.forEach(arg -> this.validateTableSource(arg.getTableSource()));
    }

    private void validateChecks(Set<String> tableChecks, Set<String> fieldChecks) {
        if (tableChecks.isEmpty() && fieldChecks.isEmpty()) {
            return;
        }
        Set staticChecks = this.dictionary.getCheckIdentifiers();
        List undefinedChecks = Stream.concat(tableChecks.stream(), fieldChecks.stream()).filter(check -> !this.elideSecurityConfig.hasCheckDefined((String)check) && !staticChecks.contains(check)).sorted().collect(Collectors.toList());
        if (!undefinedChecks.isEmpty()) {
            throw new IllegalStateException("Found undefined security checks: " + undefinedChecks);
        }
        tableChecks.stream().filter(check -> this.dictionary.getCheckMappings().containsKey(check)).forEach(check -> {
            Class checkClass = this.dictionary.getCheck(check);
            if (!UserCheck.class.isAssignableFrom(checkClass) && !FilterExpressionCheck.class.isAssignableFrom(checkClass)) {
                throw new IllegalStateException("Table or Namespace cannot have Operation Checks. Given: " + checkClass);
            }
        });
        fieldChecks.stream().filter(check -> this.dictionary.getCheckMappings().containsKey(check)).forEach(check -> {
            Class checkClass = this.dictionary.getCheck(check);
            if (!UserCheck.class.isAssignableFrom(checkClass)) {
                throw new IllegalStateException("Field can only have User checks or Roles. Given: " + checkClass);
            }
        });
    }

    private static void extractChecksFromExpr(String readAccess, Set<String> extractedChecks, PermissionExpressionVisitor visitor) {
        if (StringUtils.isNotBlank((CharSequence)readAccess)) {
            ParseTree root = EntityPermissions.parseExpression((String)readAccess);
            extractedChecks.addAll((Collection)visitor.visit(root));
        }
    }

    private static void validateFieldNameUniqueness(Set<String> alreadyFoundFields, String fieldName, String tableName) {
        if (!alreadyFoundFields.add(fieldName.toLowerCase(Locale.ENGLISH))) {
            throw new IllegalStateException(String.format("Duplicate!! Field name: %s is not unique for table: %s", fieldName, tableName));
        }
    }

    private void validateTableSource(TableSource tableSource) {
        if (tableSource == null) {
            return;
        }
        String modelName = Table.getModelName(tableSource.getTable(), tableSource.getNamespace());
        if (this.elideTableConfig.hasTable(modelName)) {
            Table lookupTable = this.elideTableConfig.getTable(modelName);
            if (!lookupTable.hasField(tableSource.getColumn())) {
                throw new IllegalStateException("Invalid tableSource : " + tableSource + " . Field : " + tableSource.getColumn() + " is undefined for hjson model: " + tableSource.getTable());
            }
            return;
        }
        if (this.hasStaticModel(modelName, "")) {
            if (!this.hasStaticField(modelName, "", tableSource.getColumn())) {
                throw new IllegalStateException("Invalid tableSource : " + tableSource + " . Field : " + tableSource.getColumn() + " is undefined for non-hjson model: " + tableSource.getTable());
            }
            return;
        }
        throw new IllegalStateException("Invalid tableSource : " + tableSource + " . Undefined model: " + tableSource.getTable());
    }

    private static void validateJoinedTablesDBConnectionName(ElideTableConfig elideTableConfig) {
        for (Table table : elideTableConfig.getTables()) {
            if (table.getJoins().isEmpty()) continue;
            Set joinedTables = table.getJoins().stream().map(Join::getTo).collect(Collectors.toSet());
            Set connections = elideTableConfig.getTables().stream().filter(t -> joinedTables.contains(t.getGlobalName())).map(Table::getDbConnectionName).collect(Collectors.toSet());
            if (connections.size() <= 1 && (connections.size() != 1 || Objects.equals(table.getDbConnectionName(), connections.iterator().next()))) continue;
            throw new IllegalStateException("DBConnection name mismatch between table: " + table.getName() + " and tables in its Join Clause.");
        }
    }

    public static void validateNameUniqueness(Collection<? extends Named> configs, String errorMsg) {
        HashSet names = new HashSet();
        configs.forEach(obj -> {
            if (!names.add(obj.getGlobalName().toLowerCase(Locale.ENGLISH))) {
                throw new IllegalStateException(errorMsg + obj.getGlobalName());
            }
        });
    }

    private static void validateSql(String sqlDefinition) {
        if (StringUtils.isNotBlank((CharSequence)sqlDefinition) && (sqlDefinition.contains(SEMI_COLON) || DynamicConfigValidator.containsDisallowedWords(sqlDefinition, SQL_SPLIT_REGEX, SQL_DISALLOWED_WORDS))) {
            throw new IllegalStateException("sql/definition provided in table config contain either ';' or one of these words: " + Arrays.toString(SQL_DISALLOWED_WORDS.toArray()));
        }
    }

    private boolean validateSecurityConfig() {
        TreeSet alreadyDefinedRoles = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        alreadyDefinedRoles.addAll(this.dictionary.getCheckIdentifiers());
        this.elideSecurityConfig.getRoles().forEach(role -> {
            if (alreadyDefinedRoles.contains(role)) {
                throw new IllegalStateException(String.format("Duplicate!! Role name: '%s' is already defined. Please use different role.", role));
            }
            alreadyDefinedRoles.add(role);
        });
        return true;
    }

    private void validateModelExists(String name) {
        if (!this.elideTableConfig.hasTable(name) && !this.hasStaticModel(name, "")) {
            throw new IllegalStateException("Model: " + name + " is neither included in dynamic models nor in static models");
        }
    }

    private void validateNamespaceExists(String name, String version) {
        if (!this.elideNamespaceConfig.hasNamespace(name, version)) {
            throw new IllegalStateException("Namespace: " + name + " is not included in dynamic configs");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean containsDisallowedWords(String str, String splitter, Set<String> keywords) {
        if (!StringUtils.isNotBlank((CharSequence)str)) return false;
        if (!Arrays.stream(str.trim().toUpperCase(Locale.ENGLISH).split(splitter)).anyMatch(keywords::contains)) return false;
        return true;
    }

    private static final Options prepareOptions() {
        Options options = new Options();
        options.addOption(new Option("h", "help", false, "Print a help message and exit."));
        options.addOption(new Option("c", "configDir", true, "Path for Configs Directory.\nExpected Directory Structure under Configs Directory:\n./models/security.hjson(optional)\n./models/variables.hjson(optional)\n./models/tables/(optional)\n./models/tables/table1.hjson\n./models/tables/table2.hjson\n./models/tables/tableN.hjson\n./db/variables.hjson(optional)\n./db/sql/(optional)\n./db/sql/db1.hjson\n./db/sql/db2.hjson\n./db/sql/dbN.hjson\n"));
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -cp <Jar File> com.yahoo.elide.modelconfig.validator.DynamicConfigValidator", options);
    }

    private boolean hasStaticField(String modelName, String version, String fieldName) {
        Type modelType = this.dictionary.getEntityClass(modelName, version);
        if (modelType == null) {
            return false;
        }
        try {
            return modelType.getDeclaredField(fieldName) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private boolean hasStaticModel(String modelName, String version) {
        Type modelType = this.dictionary.getEntityClass(modelName, version);
        return modelType != null;
    }

    public ElideTableConfig getElideTableConfig() {
        return this.elideTableConfig;
    }

    public ElideSecurityConfig getElideSecurityConfig() {
        return this.elideSecurityConfig;
    }

    public Map<String, Object> getModelVariables() {
        return this.modelVariables;
    }

    public ElideDBConfig getElideSQLDBConfig() {
        return this.elideSQLDBConfig;
    }

    public ElideNamespaceConfig getElideNamespaceConfig() {
        return this.elideNamespaceConfig;
    }

    @FunctionalInterface
    public static interface Inheritance<T> {
        public T inherit();
    }
}

