/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.verify;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Base64;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigVerifier {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigVerifier.class);

    public static void main(String[] args) {
        Options options = DynamicConfigVerifier.prepareOptions();
        try {
            CommandLine cli = new DefaultParser().parse(options, args);
            if (cli.hasOption("help")) {
                DynamicConfigVerifier.printHelp(options);
                return;
            }
            if (!(cli.hasOption("tarFile") && cli.hasOption("signatureFile") && cli.hasOption("publicKeyName"))) {
                DynamicConfigVerifier.printHelp(options);
                System.err.println("Missing required option");
                System.exit(1);
            }
            String modelTarFile = cli.getOptionValue("tarFile");
            String signatureFile = cli.getOptionValue("signatureFile");
            String publicKeyName = cli.getOptionValue("publicKeyName");
            if (DynamicConfigVerifier.verify(DynamicConfigVerifier.readTarContents(modelTarFile), signatureFile, DynamicConfigVerifier.getPublicKey(publicKeyName))) {
                System.out.println("Successfully Validated " + modelTarFile);
            } else {
                System.err.println("Could not verify " + modelTarFile + " with details provided");
                System.exit(2);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
    }

    public static boolean verify(String fileContent, String signature, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature publicSignature = Signature.getInstance("SHA256withRSA");
        publicSignature.initVerify(publicKey);
        publicSignature.update(fileContent.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = Base64.getDecoder().decode(signature);
        return publicSignature.verify(signatureBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTarContents(String archiveFile) throws FileNotFoundException, IOException {
        StringBuffer sb = new StringBuffer();
        try (BufferedReader br = null;
             TarArchiveInputStream archiveInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(archiveFile))));){
            TarArchiveEntry entry = archiveInputStream.getNextTarEntry();
            while (entry != null) {
                String line;
                br = new BufferedReader(new InputStreamReader((InputStream)archiveInputStream));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                entry = archiveInputStream.getNextTarEntry();
            }
        }
        return sb.toString();
    }

    private static PublicKey getPublicKey(String keyName) throws KeyStoreException {
        PublicKey publicKey = null;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Certificate cert = keyStore.getCertificate(keyName);
        publicKey = cert.getPublicKey();
        return publicKey;
    }

    private static final Options prepareOptions() {
        Options options = new Options();
        options.addOption(new Option("h", "help", false, "Print a help message and exit."));
        options.addOption(new Option("t", "tarFile", true, "Path of the tar.gz file"));
        options.addOption(new Option("s", "signatureFile", true, "Path of the file containing the signature"));
        options.addOption(new Option("p", "publicKeyName", true, "Name of public key in keystore"));
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -cp <Jar File> com.yahoo.elide.contrib.dynamicconfighelpers.verify.DynamicConfigVerifier", options);
    }
}

