/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.config;

import com.yahoo.elide.Elide;
import com.yahoo.elide.RefreshableElide;
import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.async.export.formatter.CSVExportFormatter;
import com.yahoo.elide.async.export.formatter.JSONExportFormatter;
import com.yahoo.elide.async.export.formatter.TableExportFormatter;
import com.yahoo.elide.async.hooks.AsyncQueryHook;
import com.yahoo.elide.async.hooks.TableExportHook;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.ResultType;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.service.AsyncCleanerService;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.async.service.dao.AsyncAPIDAO;
import com.yahoo.elide.async.service.dao.DefaultAsyncAPIDAO;
import com.yahoo.elide.async.service.storageengine.FileResultStorageEngine;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.lifecycle.LifeCycleHook;
import com.yahoo.elide.core.security.RequestScope;
import com.yahoo.elide.spring.config.AsyncProperties;
import com.yahoo.elide.spring.config.ElideAutoConfiguration;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EntityScan(basePackageClasses={AsyncQuery.class})
@EnableConfigurationProperties(value={ElideConfigProperties.class})
@ConditionalOnExpression(value="${elide.async.enabled:false}")
public class ElideAsyncConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AsyncExecutorService buildAsyncExecutorService(RefreshableElide elide, ElideConfigProperties settings, AsyncAPIDAO asyncQueryDao, @Autowired(required=false) ResultStorageEngine resultStorageEngine) {
        AsyncProperties asyncProperties = settings.getAsync();
        ExecutorService executor = Executors.newFixedThreadPool(asyncProperties.getThreadPoolSize());
        ExecutorService updater = Executors.newFixedThreadPool(asyncProperties.getThreadPoolSize());
        AsyncExecutorService asyncExecutorService = new AsyncExecutorService(elide.getElide(), executor, updater, asyncQueryDao);
        AsyncQueryHook asyncQueryHook = new AsyncQueryHook(asyncExecutorService, Integer.valueOf(asyncProperties.getMaxAsyncAfterSeconds()));
        EntityDictionary dictionary = elide.getElide().getElideSettings().getDictionary();
        dictionary.bindTrigger(AsyncQuery.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PREFLUSH, (LifeCycleHook)asyncQueryHook, false);
        dictionary.bindTrigger(AsyncQuery.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, (LifeCycleHook)asyncQueryHook, false);
        dictionary.bindTrigger(AsyncQuery.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PRESECURITY, (LifeCycleHook)asyncQueryHook, false);
        boolean exportEnabled = ElideAutoConfiguration.isExportEnabled(asyncProperties);
        if (exportEnabled) {
            boolean skipCSVHeader = asyncProperties.getExport() != null && asyncProperties.getExport().isSkipCSVHeader();
            HashMap<ResultType, TableExportFormatter> supportedFormatters = new HashMap<ResultType, TableExportFormatter>();
            supportedFormatters.put(ResultType.CSV, (TableExportFormatter)new CSVExportFormatter(elide.getElide(), skipCSVHeader));
            supportedFormatters.put(ResultType.JSON, (TableExportFormatter)new JSONExportFormatter(elide.getElide()));
            TableExportHook tableExportHook = this.getTableExportHook(asyncExecutorService, settings, supportedFormatters, resultStorageEngine);
            dictionary.bindTrigger(TableExport.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PREFLUSH, (LifeCycleHook)tableExportHook, false);
            dictionary.bindTrigger(TableExport.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, (LifeCycleHook)tableExportHook, false);
            dictionary.bindTrigger(TableExport.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PRESECURITY, (LifeCycleHook)tableExportHook, false);
        }
        return asyncExecutorService;
    }

    private TableExportHook getTableExportHook(AsyncExecutorService asyncExecutorService, ElideConfigProperties settings, Map<ResultType, TableExportFormatter> supportedFormatters, ResultStorageEngine resultStorageEngine) {
        boolean exportEnabled = ElideAutoConfiguration.isExportEnabled(settings.getAsync());
        TableExportHook tableExportHook = null;
        tableExportHook = exportEnabled ? new TableExportHook(asyncExecutorService, Integer.valueOf(settings.getAsync().getMaxAsyncAfterSeconds()), supportedFormatters, resultStorageEngine) : new TableExportHook(asyncExecutorService, settings.getAsync().getMaxAsyncAfterSeconds(), supportedFormatters, resultStorageEngine){

            public void validateOptions(AsyncAPI export, RequestScope requestScope) {
                throw new InvalidOperationException("TableExport is not supported.");
            }
        };
        return tableExportHook;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="elide.async", name={"cleanupEnabled"}, matchIfMissing=false)
    public AsyncCleanerService buildAsyncCleanerService(RefreshableElide elide, ElideConfigProperties settings, AsyncAPIDAO asyncQueryDao) {
        AsyncCleanerService.init((Elide)elide.getElide(), (Integer)settings.getAsync().getMaxRunTimeSeconds(), (Integer)settings.getAsync().getQueryCleanupDays(), (Integer)settings.getAsync().getQueryCancellationIntervalSeconds(), (AsyncAPIDAO)asyncQueryDao);
        return AsyncCleanerService.getInstance();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="elide.async", name={"defaultAsyncAPIDAO"}, matchIfMissing=true)
    public AsyncAPIDAO buildAsyncAPIDAO(RefreshableElide elide) {
        return new DefaultAsyncAPIDAO(elide.getElide().getElideSettings(), elide.getElide().getDataStore());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="elide.async.export", name={"enabled"}, matchIfMissing=false)
    public ResultStorageEngine buildResultStorageEngine(ElideConfigProperties settings) {
        FileResultStorageEngine resultStorageEngine = new FileResultStorageEngine(settings.getAsync().getExport().getStorageDestination(), settings.getAsync().getExport().isExtensionEnabled());
        return resultStorageEngine;
    }
}

