/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.config;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideSettingsBuilder;
import com.yahoo.elide.RefreshableElide;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.core.TransactionRegistry;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.audit.Slf4jLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.exceptions.ErrorMapper;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.core.security.checks.UserCheck;
import com.yahoo.elide.core.security.checks.prefab.Role;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.DefaultClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.datastores.aggregation.AggregationDataStore;
import com.yahoo.elide.datastores.aggregation.DefaultQueryValidator;
import com.yahoo.elide.datastores.aggregation.QueryEngine;
import com.yahoo.elide.datastores.aggregation.QueryValidator;
import com.yahoo.elide.datastores.aggregation.cache.Cache;
import com.yahoo.elide.datastores.aggregation.cache.CaffeineCache;
import com.yahoo.elide.datastores.aggregation.core.QueryLogger;
import com.yahoo.elide.datastores.aggregation.core.Slf4jQueryLogger;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.DefaultQueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.query.QueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.ConnectionDetails;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.DataSourceConfiguration;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.SQLQueryEngine;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialectFactory;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.AggregateBeforeJoinOptimizer;
import com.yahoo.elide.datastores.aggregation.validator.TemplateConfigValidator;
import com.yahoo.elide.datastores.jpa.JpaDataStore;
import com.yahoo.elide.datastores.jpa.transaction.NonJtaTransaction;
import com.yahoo.elide.datastores.multiplex.MultiplexManager;
import com.yahoo.elide.graphql.QueryRunners;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.links.DefaultJSONApiLinks;
import com.yahoo.elide.jsonapi.links.JSONApiLinks;
import com.yahoo.elide.modelconfig.DBPasswordExtractor;
import com.yahoo.elide.modelconfig.DynamicConfiguration;
import com.yahoo.elide.modelconfig.store.ConfigDataStore;
import com.yahoo.elide.modelconfig.store.models.ConfigChecks;
import com.yahoo.elide.modelconfig.validator.DynamicConfigValidator;
import com.yahoo.elide.modelconfig.validator.Validator;
import com.yahoo.elide.spring.config.AsyncProperties;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.spring.controllers.SwaggerController;
import com.yahoo.elide.swagger.SwaggerBuilder;
import com.yahoo.elide.utils.HeaderUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import io.swagger.models.Info;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@EnableConfigurationProperties(value={ElideConfigProperties.class})
public class ElideAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElideAutoConfiguration.class);
    @Autowired(required=false)
    private MeterRegistry meterRegistry;
    private final Consumer<EntityManager> txCancel = em -> ((Session)em.unwrap(Session.class)).cancelQuery();

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="${elide.aggregation-store.enabled:false} and ${elide.dynamic-config.enabled:false}")
    public DynamicConfiguration buildDynamicConfiguration(ClassScanner scanner, ElideConfigProperties settings) throws IOException {
        DynamicConfigValidator validator = new DynamicConfigValidator(scanner, settings.getDynamicConfig().getPath());
        validator.readAndValidateConfigs();
        return validator;
    }

    @Bean
    @ConditionalOnMissingBean
    public TransactionRegistry createRegistry() {
        return new TransactionRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"elide.aggregation-store.enabled"}, havingValue="true")
    public DBPasswordExtractor getDBPasswordExtractor() {
        return config -> "";
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"elide.aggregation-store.enabled"}, havingValue="true")
    public DataSourceConfiguration getDataSourceConfiguration() {
        return new DataSourceConfiguration(){};
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean
    public RefreshableElide getRefreshableElide(EntityDictionary dictionary, DataStore dataStore, HeaderUtils.HeaderProcessor headerProcessor, TransactionRegistry transactionRegistry, ElideConfigProperties settings, JsonApiMapper mapper, ErrorMapper errorMapper) {
        ElideSettingsBuilder builder = new ElideSettingsBuilder(dataStore).withEntityDictionary(dictionary).withErrorMapper(errorMapper).withJsonApiMapper(mapper).withDefaultMaxPageSize(settings.getMaxPageSize()).withDefaultPageSize(settings.getPageSize()).withJoinFilterDialect((JoinFilterDialect)RSQLFilterDialect.builder().dictionary(dictionary).build()).withSubqueryFilterDialect((SubqueryFilterDialect)RSQLFilterDialect.builder().dictionary(dictionary).build()).withAuditLogger((AuditLogger)new Slf4jLogger()).withBaseUrl(settings.getBaseUrl()).withISO8601Dates("yyyy-MM-dd'T'HH:mm'Z'", TimeZone.getTimeZone("UTC")).withJsonApiPath(settings.getJsonApi().getPath()).withHeaderProcessor(headerProcessor).withGraphQLApiPath(settings.getGraphql().getPath());
        if (settings.isVerboseErrors()) {
            builder.withVerboseErrors();
        }
        if (settings.getAsync() != null && settings.getAsync().getExport() != null && settings.getAsync().getExport().isEnabled()) {
            builder.withExportApiPath(settings.getAsync().getExport().getPath());
        }
        if (settings.getGraphql() != null && settings.getGraphql().enableFederation) {
            builder.withGraphQLFederation(true);
        }
        if (settings.getJsonApi() != null && settings.getJsonApi().isEnabled() && settings.getJsonApi().isEnableLinks()) {
            String baseUrl = settings.getBaseUrl();
            if (StringUtils.isEmpty((CharSequence)baseUrl)) {
                builder.withJSONApiLinks((JSONApiLinks)new DefaultJSONApiLinks());
            } else {
                String jsonApiBaseUrl = baseUrl + settings.getJsonApi().getPath() + "/";
                builder.withJSONApiLinks((JSONApiLinks)new DefaultJSONApiLinks(jsonApiBaseUrl));
            }
        }
        Elide elide = new Elide(builder.build(), transactionRegistry, dictionary.getScanner(), true);
        return new RefreshableElide(elide);
    }

    @Bean
    @ConditionalOnMissingBean
    public HeaderUtils.HeaderProcessor getHeaderProcessor(ElideConfigProperties settings) {
        if (settings.isStripAuthorizatonHeaders()) {
            return HeaderUtils::lowercaseAndRemoveAuthHeaders;
        }
        return a -> a;
    }

    @Bean(name={"entitiesToExclude"})
    @ConditionalOnMissingBean
    public Set<Type<?>> getEntitiesToExclude(ElideConfigProperties settings) {
        boolean exportEnabled;
        HashSet entitiesToExclude = new HashSet();
        AsyncProperties asyncProperties = settings.getAsync();
        if (asyncProperties == null || !asyncProperties.isEnabled()) {
            entitiesToExclude.add((Type<?>)ClassType.of(AsyncQuery.class));
        }
        if (!(exportEnabled = ElideAutoConfiguration.isExportEnabled(asyncProperties))) {
            entitiesToExclude.add((Type<?>)ClassType.of(TableExport.class));
        }
        return entitiesToExclude;
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public Injector buildInjector(final AutowireCapableBeanFactory beanFactory) {
        return new Injector(){

            public void inject(Object entity) {
                beanFactory.autowireBean(entity);
            }

            public <T> T instantiate(Class<T> cls) {
                return (T)beanFactory.createBean(cls);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public EntityDictionary buildDictionary(Injector injector, ClassScanner scanner, @Autowired(required=false) DynamicConfiguration dynamicConfig, ElideConfigProperties settings, @Qualifier(value="entitiesToExclude") Set<Type<?>> entitiesToExclude) {
        HashMap<String, Class> checks = new HashMap<String, Class>();
        if (settings.getDynamicConfig().isConfigApiEnabled()) {
            checks.put("Can Create Config", ConfigChecks.CanNotCreate.class);
            checks.put("Can Read Config", ConfigChecks.CanNotRead.class);
            checks.put("Can Delete Config", ConfigChecks.CanNotDelete.class);
            checks.put("Can Update Config", ConfigChecks.CanNotUpdate.class);
        }
        EntityDictionary dictionary = new EntityDictionary(checks, new HashMap(), injector, CoerceUtil::lookup, entitiesToExclude, scanner);
        if (this.isAggregationStoreEnabled(settings) && this.isDynamicConfigEnabled(settings)) {
            dynamicConfig.getRoles().forEach(role -> dictionary.addRoleCheck(role, (UserCheck)new Role.RoleMemberCheck(role)));
        }
        return dictionary;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"elide.aggregation-store.enabled"}, havingValue="true")
    @Scope(value="prototype")
    public QueryEngine buildQueryEngine(DataSource defaultDataSource, @Autowired(required=false) DynamicConfiguration dynamicConfig, ElideConfigProperties settings, ClassScanner scanner, DataSourceConfiguration dataSourceConfiguration, DBPasswordExtractor dbPasswordExtractor) {
        boolean enableMetaDataStore = settings.getAggregationStore().isEnableMetaDataStore();
        ConnectionDetails defaultConnectionDetails = new ConnectionDetails(defaultDataSource, SQLDialectFactory.getDialect((String)settings.getAggregationStore().getDefaultDialect()));
        if (this.isDynamicConfigEnabled(settings)) {
            MetaDataStore metaDataStore = new MetaDataStore(scanner, (Collection)dynamicConfig.getTables(), (Collection)dynamicConfig.getNamespaceConfigurations(), enableMetaDataStore);
            HashMap connectionDetailsMap = new HashMap();
            dynamicConfig.getDatabaseConfigurations().forEach(dbConfig -> connectionDetailsMap.put(dbConfig.getName(), new ConnectionDetails(dataSourceConfiguration.getDataSource(dbConfig, dbPasswordExtractor), SQLDialectFactory.getDialect((String)dbConfig.getDialect()))));
            Function<String, ConnectionDetails> connectionDetailsLookup = name -> {
                if (StringUtils.isEmpty((CharSequence)name)) {
                    return defaultConnectionDetails;
                }
                return Optional.ofNullable((ConnectionDetails)connectionDetailsMap.get(name)).orElseThrow(() -> new IllegalStateException("ConnectionDetails undefined for connection: " + name));
            };
            return new SQLQueryEngine(metaDataStore, connectionDetailsLookup, new HashSet<AggregateBeforeJoinOptimizer>(Arrays.asList(new AggregateBeforeJoinOptimizer(metaDataStore))), (QueryPlanMerger)new DefaultQueryPlanMerger(metaDataStore), (QueryValidator)new DefaultQueryValidator(metaDataStore.getMetadataDictionary()));
        }
        MetaDataStore metaDataStore = new MetaDataStore(scanner, enableMetaDataStore);
        return new SQLQueryEngine(metaDataStore, unused -> defaultConnectionDetails);
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public DataStore buildDataStore(EntityManagerFactory entityManagerFactory, ClassScanner scanner, @Autowired(required=false) QueryEngine queryEngine, ElideConfigProperties settings, @Autowired(required=false) Cache cache, @Autowired(required=false) QueryLogger querylogger) {
        ArrayList<Object> stores = new ArrayList<Object>();
        JpaDataStore jpaDataStore = new JpaDataStore(() -> ((EntityManagerFactory)entityManagerFactory).createEntityManager(), em -> new NonJtaTransaction(em, this.txCancel, JpaDataStore.DEFAULT_LOGGER, settings.getJpaStore().isDelegateToInMemoryStore(), true), new Type[0]);
        stores.add(jpaDataStore);
        if (this.isAggregationStoreEnabled(settings)) {
            AggregationDataStore.AggregationDataStoreBuilder aggregationDataStoreBuilder = AggregationDataStore.builder().queryEngine(queryEngine);
            if (this.isDynamicConfigEnabled(settings)) {
                aggregationDataStoreBuilder.dynamicCompiledClasses(queryEngine.getMetaDataStore().getDynamicTypes());
                if (settings.getDynamicConfig().isConfigApiEnabled()) {
                    stores.add(new ConfigDataStore(settings.getDynamicConfig().getPath(), (Validator)new TemplateConfigValidator(scanner, settings.getDynamicConfig().getPath())));
                }
            }
            aggregationDataStoreBuilder.cache(cache);
            aggregationDataStoreBuilder.queryLogger(querylogger);
            AggregationDataStore aggregationDataStore = aggregationDataStoreBuilder.build();
            stores.add(queryEngine.getMetaDataStore());
            stores.add(aggregationDataStore);
            return new MultiplexManager(stores.toArray(new DataStore[0]));
        }
        return jpaDataStore;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"elide.aggregation-store.enabled"}, havingValue="true")
    public Cache buildQueryCache(ElideConfigProperties settings) {
        CaffeineCache cache = null;
        int maxCacheItems = settings.getAggregationStore().getQueryCacheMaximumEntries();
        if (maxCacheItems > 0) {
            cache = new CaffeineCache(maxCacheItems, settings.getAggregationStore().getDefaultCacheExpirationMinutes());
            if (this.meterRegistry != null) {
                CaffeineCacheMetrics.monitor((MeterRegistry)this.meterRegistry, (com.github.benmanes.caffeine.cache.Cache)cache.getImplementation(), (String)"elideQueryCache", (String[])new String[0]);
            }
        }
        return cache;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"elide.aggregation-store.enabled"}, havingValue="true")
    public QueryLogger buildQueryLogger() {
        return new Slf4jQueryLogger();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"elide.swagger.enabled"}, havingValue="true")
    @RefreshScope
    public SwaggerController.SwaggerRegistrations buildSwagger(RefreshableElide elide, ElideConfigProperties settings) {
        EntityDictionary dictionary = elide.getElide().getElideSettings().getDictionary();
        Info info = new Info().title(settings.getSwagger().getName()).version(settings.getSwagger().getVersion());
        SwaggerBuilder builder = new SwaggerBuilder(dictionary, info).withLegacyFilterDialect(false);
        return new SwaggerController.SwaggerRegistrations(builder.build().basePath(settings.getJsonApi().getPath()));
    }

    @Bean
    @ConditionalOnMissingBean
    public ClassScanner getClassScanner() {
        return new DefaultClassScanner();
    }

    @Bean
    @ConditionalOnMissingBean
    public ErrorMapper getErrorMapper() {
        return error -> null;
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public JsonApiMapper mapper() {
        return new JsonApiMapper();
    }

    private boolean isDynamicConfigEnabled(ElideConfigProperties settings) {
        boolean enabled = false;
        if (settings.getDynamicConfig() != null) {
            enabled = settings.getDynamicConfig().isEnabled();
        }
        return enabled;
    }

    private boolean isAggregationStoreEnabled(ElideConfigProperties settings) {
        boolean enabled = false;
        if (settings.getAggregationStore() != null) {
            enabled = settings.getAggregationStore().isEnabled();
        }
        return enabled;
    }

    public static boolean isExportEnabled(AsyncProperties asyncProperties) {
        return asyncProperties != null && asyncProperties.getExport() != null && asyncProperties.getExport().isEnabled();
    }

    @Configuration
    @ConditionalOnProperty(name={"elide.graphql.enabled"}, havingValue="true")
    public static class GraphQLConfiguration {
        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public QueryRunners getQueryRunners(RefreshableElide refreshableElide) {
            return new QueryRunners(refreshableElide);
        }
    }
}

