/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.config;

import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.audit.Slf4jLogger;
import com.yahoo.elide.core.exceptions.ErrorMapper;
import com.yahoo.elide.datastores.jms.websocket.SubscriptionWebSocketConfigurator;
import com.yahoo.elide.graphql.subscriptions.websocket.SubscriptionWebSocket;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import javax.jms.ConnectionFactory;
import javax.websocket.server.ServerEndpointConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
@ConditionalOnProperty(name={"elide.graphql.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ElideConfigProperties.class})
public class ElideSubscriptionConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="${elide.subscription.enabled:false}")
    ServerEndpointConfig serverEndpointConfig(ElideConfigProperties config, SubscriptionWebSocket.UserFactory userFactory, ConnectionFactory connectionFactory, ErrorMapper errorMapper) {
        return ServerEndpointConfig.Builder.create(SubscriptionWebSocket.class, (String)config.getSubscription().getPath()).configurator((ServerEndpointConfig.Configurator)SubscriptionWebSocketConfigurator.builder().baseUrl(config.getSubscription().getPath()).sendPingOnSubscribe(config.getSubscription().isSendPingOnSubscribe()).connectionTimeoutMs(config.getSubscription().getConnectionTimeoutMs()).maxSubscriptions(config.getSubscription().maxSubscriptions).maxMessageSize(config.getSubscription().maxMessageSize).maxIdleTimeoutMs(config.getSubscription().idleTimeoutMs).connectionFactory(connectionFactory).userFactory(userFactory).auditLogger((AuditLogger)new Slf4jLogger()).verboseErrors(config.isVerboseErrors()).errorMapper(errorMapper).build()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="${elide.subscription.enabled:false}")
    ServerEndpointExporter serverEndpointExporter() {
        ServerEndpointExporter exporter = new ServerEndpointExporter();
        return exporter;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="${elide.subscription.enabled:false}")
    SubscriptionWebSocket.UserFactory getUserFactory() {
        return SubscriptionWebSocket.DEFAULT_USER_FACTORY;
    }
}

