/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.graphql.QueryRunners;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.spring.security.AuthenticationUser;
import com.yahoo.elide.utils.HeaderUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Configuration
@RestController
@RequestMapping(value={"${elide.graphql.path}"})
@EnableConfigurationProperties(value={ElideConfigProperties.class})
@ConditionalOnExpression(value="${elide.graphql.enabled:false}")
@RefreshScope
public class GraphqlController {
    private static final Logger log = LoggerFactory.getLogger(GraphqlController.class);
    private final ElideConfigProperties settings;
    private final QueryRunners runners;
    private final ObjectMapper mapper;
    private final HeaderUtils.HeaderProcessor headerProcessor;
    private static final String JSON_CONTENT_TYPE = "application/json";

    @Autowired
    public GraphqlController(QueryRunners runners, JsonApiMapper jsonApiMapper, HeaderUtils.HeaderProcessor headerProcessor, ElideConfigProperties settings) {
        log.debug("Started ~~");
        this.runners = runners;
        this.settings = settings;
        this.headerProcessor = headerProcessor;
        this.mapper = jsonApiMapper.getObjectMapper();
    }

    @PostMapping(value={"/**", ""}, consumes={"application/json"}, produces={"application/json"})
    public Callable<ResponseEntity<String>> post(@RequestHeader HttpHeaders requestHeaders, final @RequestBody String graphQLDocument, Authentication principal) {
        final AuthenticationUser user = new AuthenticationUser(principal);
        String apiVersion = HeaderUtils.resolveApiVersion((Map)requestHeaders);
        final Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        final QueryRunner runner = this.runners.getRunner(apiVersion);
        final String baseUrl = this.getBaseUrlEndpoint();
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response;
                if (runner == null) {
                    response = QueryRunner.buildErrorResponse((ObjectMapper)GraphqlController.this.mapper, (HttpStatusException)new InvalidOperationException("Invalid API Version"), (boolean)false);
                } else {
                    Elide elide = runner.getElide();
                    response = runner.run(baseUrl, graphQLDocument, user, UUID.randomUUID(), requestHeadersCleaned);
                }
                return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
            }
        };
    }

    protected String getBaseUrlEndpoint() {
        String baseUrl = this.settings.getBaseUrl();
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
        }
        return baseUrl;
    }
}

