/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.controllers;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.RefreshableElide;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.spring.security.AuthenticationUser;
import com.yahoo.elide.utils.HeaderUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@Configuration
@RequestMapping(value={"${elide.json-api.path}"})
@ConditionalOnExpression(value="${elide.json-api.enabled:false}")
@RefreshScope
public class JsonApiController {
    private static final Logger log = LoggerFactory.getLogger(JsonApiController.class);
    private final Elide elide;
    private final ElideConfigProperties settings;
    private final HeaderUtils.HeaderProcessor headerProcessor;
    public static final String JSON_API_CONTENT_TYPE = "application/vnd.api+json";
    public static final String JSON_API_PATCH_CONTENT_TYPE = "application/vnd.api+json; ext=jsonpatch";

    @Autowired
    public JsonApiController(RefreshableElide refreshableElide, ElideConfigProperties settings) {
        log.debug("Started ~~");
        this.settings = settings;
        this.elide = refreshableElide.getElide();
        this.headerProcessor = this.elide.getElideSettings().getHeaderProcessor();
    }

    private <K, V> MultivaluedHashMap<K, V> convert(MultiValueMap<K, V> springMVMap) {
        MultivaluedHashMap convertedMap = new MultivaluedHashMap(springMVMap.size());
        springMVMap.forEach((arg_0, arg_1) -> ((MultivaluedHashMap)convertedMap).put(arg_0, arg_1));
        return convertedMap;
    }

    @GetMapping(value={"/**"}, produces={"application/vnd.api+json"})
    public Callable<ResponseEntity<String>> elideGet(@RequestHeader HttpHeaders requestHeaders, final @RequestParam MultiValueMap<String, String> allRequestParams, HttpServletRequest request, Authentication authentication) {
        final String apiVersion = HeaderUtils.resolveApiVersion((Map)requestHeaders);
        final Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        final String pathname = this.getJsonApiPath(request, this.settings.getJsonApi().getPath());
        final AuthenticationUser user = new AuthenticationUser(authentication);
        final String baseUrl = this.getBaseUrlEndpoint();
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = JsonApiController.this.elide.get(baseUrl, pathname, JsonApiController.this.convert(allRequestParams), requestHeadersCleaned, user, apiVersion, UUID.randomUUID());
                return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
            }
        };
    }

    @PostMapping(value={"/**"}, consumes={"application/vnd.api+json"}, produces={"application/vnd.api+json"})
    public Callable<ResponseEntity<String>> elidePost(@RequestHeader HttpHeaders requestHeaders, final @RequestParam MultiValueMap<String, String> allRequestParams, final @RequestBody String body, HttpServletRequest request, Authentication authentication) {
        final String apiVersion = HeaderUtils.resolveApiVersion((Map)requestHeaders);
        final Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        final String pathname = this.getJsonApiPath(request, this.settings.getJsonApi().getPath());
        final AuthenticationUser user = new AuthenticationUser(authentication);
        final String baseUrl = this.getBaseUrlEndpoint();
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = JsonApiController.this.elide.post(baseUrl, pathname, body, JsonApiController.this.convert(allRequestParams), requestHeadersCleaned, user, apiVersion, UUID.randomUUID());
                return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
            }
        };
    }

    @PatchMapping(value={"/**"}, consumes={"application/vnd.api+json", "application/vnd.api+json; ext=jsonpatch"}, produces={"application/vnd.api+json"})
    public Callable<ResponseEntity<String>> elidePatch(@RequestHeader HttpHeaders requestHeaders, final @RequestParam MultiValueMap<String, String> allRequestParams, final @RequestBody String body, final HttpServletRequest request, Authentication authentication) {
        final String apiVersion = HeaderUtils.resolveApiVersion((Map)requestHeaders);
        final Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        final String pathname = this.getJsonApiPath(request, this.settings.getJsonApi().getPath());
        final AuthenticationUser user = new AuthenticationUser(authentication);
        final String baseUrl = this.getBaseUrlEndpoint();
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = JsonApiController.this.elide.patch(baseUrl, request.getContentType(), request.getContentType(), pathname, body, JsonApiController.this.convert(allRequestParams), requestHeadersCleaned, user, apiVersion, UUID.randomUUID());
                return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
            }
        };
    }

    @DeleteMapping(value={"/**"}, produces={"application/vnd.api+json"})
    public Callable<ResponseEntity<String>> elideDelete(@RequestHeader HttpHeaders requestHeaders, final @RequestParam MultiValueMap<String, String> allRequestParams, HttpServletRequest request, Authentication authentication) {
        final String apiVersion = HeaderUtils.resolveApiVersion((Map)requestHeaders);
        final Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        final String pathname = this.getJsonApiPath(request, this.settings.getJsonApi().getPath());
        final AuthenticationUser user = new AuthenticationUser(authentication);
        final String baseUrl = this.getBaseUrlEndpoint();
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = JsonApiController.this.elide.delete(baseUrl, pathname, null, JsonApiController.this.convert(allRequestParams), requestHeadersCleaned, user, apiVersion, UUID.randomUUID());
                return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
            }
        };
    }

    @DeleteMapping(value={"/**"}, consumes={"application/vnd.api+json"})
    public Callable<ResponseEntity<String>> elideDeleteRelation(@RequestHeader HttpHeaders requestHeaders, final @RequestParam MultiValueMap<String, String> allRequestParams, final @RequestBody String body, HttpServletRequest request, Authentication authentication) {
        final String apiVersion = HeaderUtils.resolveApiVersion((Map)requestHeaders);
        final Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        final String pathname = this.getJsonApiPath(request, this.settings.getJsonApi().getPath());
        final AuthenticationUser user = new AuthenticationUser(authentication);
        final String baseUrl = this.getBaseUrlEndpoint();
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = JsonApiController.this.elide.delete(baseUrl, pathname, body, JsonApiController.this.convert(allRequestParams), requestHeadersCleaned, user, apiVersion, UUID.randomUUID());
                return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
            }
        };
    }

    private String getJsonApiPath(HttpServletRequest request, String prefix) {
        String pathname = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        return pathname.replaceFirst(prefix, "");
    }

    protected String getBaseUrlEndpoint() {
        String baseUrl = this.elide.getElideSettings().getBaseUrl();
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
        }
        return baseUrl;
    }
}

