/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.controllers;

import com.yahoo.elide.swagger.SwaggerBuilder;
import com.yahoo.elide.utils.HeaderUtils;
import io.swagger.models.Swagger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RefreshScope
@RestController
@Configuration
@RequestMapping(value={"${elide.swagger.path}"})
@ConditionalOnExpression(value="${elide.swagger.enabled:false}")
public class SwaggerController {
    private static final Logger log = LoggerFactory.getLogger(SwaggerController.class);
    protected Map<Pair<String, String>, String> documents;
    private static final String JSON_CONTENT_TYPE = "application/json";

    @Autowired
    public SwaggerController(SwaggerRegistrations docs) {
        log.debug("Started ~~");
        this.documents = new HashMap<Pair<String, String>, String>();
        docs.getRegistrations().forEach(doc -> {
            String apiVersion = doc.document.getInfo().getVersion();
            apiVersion = apiVersion == null ? "" : apiVersion;
            String apiPath = doc.path;
            this.documents.put((Pair<String, String>)Pair.of((Object)apiVersion, (Object)apiPath), SwaggerBuilder.getDocument((Swagger)doc.document));
        });
    }

    @GetMapping(value={"/", ""}, produces={"application/json"})
    public Callable<ResponseEntity<String>> list(@RequestHeader HttpHeaders requestHeaders) {
        String apiVersion = HeaderUtils.resolveApiVersion((Map)requestHeaders);
        final List documentPaths = this.documents.keySet().stream().filter(key -> ((String)key.getLeft()).equals(apiVersion)).map(Pair::getRight).collect(Collectors.toList());
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                if (documentPaths.size() == 1) {
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)SwaggerController.this.documents.values().iterator().next());
                }
                String body = documentPaths.stream().map(key -> "\"" + key + "\"").collect(Collectors.joining(",", "[", "]"));
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)body);
            }
        };
    }

    @GetMapping(value={"/{name}"}, produces={"application/json"})
    public Callable<ResponseEntity<String>> list(@RequestHeader HttpHeaders requestHeaders, @PathVariable(value="name") String name) {
        final String apiVersion = HeaderUtils.resolveApiVersion((Map)requestHeaders);
        final String encodedName = Encode.forHtml((String)name);
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                Pair lookupKey = Pair.of((Object)apiVersion, (Object)encodedName);
                if (SwaggerController.this.documents.containsKey(lookupKey)) {
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)SwaggerController.this.documents.get(lookupKey));
                }
                return ResponseEntity.status((int)404).body((Object)("Unknown document: " + encodedName));
            }
        };
    }

    public static class SwaggerRegistration {
        private String path;
        private Swagger document;

        public String getPath() {
            return this.path;
        }

        public Swagger getDocument() {
            return this.document;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setDocument(Swagger document) {
            this.document = document;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SwaggerRegistration)) {
                return false;
            }
            SwaggerRegistration other = (SwaggerRegistration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Swagger this$document = this.getDocument();
            Swagger other$document = other.getDocument();
            return !(this$document == null ? other$document != null : !this$document.equals(other$document));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SwaggerRegistration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Swagger $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : $document.hashCode());
            return result;
        }

        public String toString() {
            return "SwaggerController.SwaggerRegistration(path=" + this.getPath() + ", document=" + this.getDocument() + ")";
        }

        public SwaggerRegistration(String path, Swagger document) {
            this.path = path;
            this.document = document;
        }
    }

    public static class SwaggerRegistrations {
        List<SwaggerRegistration> registrations;

        public SwaggerRegistrations(Swagger doc) {
            this.registrations = List.of(new SwaggerRegistration("", doc));
        }

        public List<SwaggerRegistration> getRegistrations() {
            return this.registrations;
        }

        public void setRegistrations(List<SwaggerRegistration> registrations) {
            this.registrations = registrations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SwaggerRegistrations)) {
                return false;
            }
            SwaggerRegistrations other = (SwaggerRegistrations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<SwaggerRegistration> this$registrations = this.getRegistrations();
            List<SwaggerRegistration> other$registrations = other.getRegistrations();
            return !(this$registrations == null ? other$registrations != null : !((Object)this$registrations).equals(other$registrations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SwaggerRegistrations;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<SwaggerRegistration> $registrations = this.getRegistrations();
            result = result * 59 + ($registrations == null ? 43 : ((Object)$registrations).hashCode());
            return result;
        }

        public String toString() {
            return "SwaggerController.SwaggerRegistrations(registrations=" + this.getRegistrations() + ")";
        }

        public SwaggerRegistrations(List<SwaggerRegistration> registrations) {
            this.registrations = registrations;
        }
    }
}

