/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.api;

import com.yahoo.elide.spring.api.OpenApiDocumentCustomizer;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeIn;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class BasicOpenApiDocumentCustomizer
implements OpenApiDocumentCustomizer,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public void customize(OpenAPI openApi) {
        Components components = openApi.getComponents();
        if (components == null) {
            components = new Components();
            openApi.components(components);
        }
        this.getSecuritySchemes().forEach((arg_0, arg_1) -> ((Components)components).addSecuritySchemes(arg_0, arg_1));
        OpenAPIDefinition openApiDefinition = this.getOpenApiDefinition();
        if (openApiDefinition != null) {
            BasicOpenApiDocumentCustomizer.applyDefinition(openApi, openApiDefinition);
        }
        if (openApi.getInfo() == null) {
            openApi.info(new io.swagger.v3.oas.models.info.Info().title("Elide Service"));
        } else if (openApi.getInfo().getTitle() == null || openApi.getInfo().getTitle().isBlank()) {
            openApi.getInfo().setTitle("Elide Service");
        }
        this.sort(openApi);
    }

    protected void sort(OpenAPI openApi) {
        List tags = openApi.getTags();
        if (tags != null) {
            tags.sort((left, right) -> left.getName().compareTo(right.getName()));
        }
    }

    protected Map<String, SecurityScheme> getSecuritySchemes() {
        HashMap<String, SecurityScheme> securitySchemes = new HashMap<String, SecurityScheme>();
        Map beans = this.applicationContext.getBeansWithAnnotation(io.swagger.v3.oas.annotations.security.SecurityScheme.class);
        for (Object bean : beans.values()) {
            io.swagger.v3.oas.annotations.security.SecurityScheme annotation = (io.swagger.v3.oas.annotations.security.SecurityScheme)AnnotatedElementUtils.findMergedAnnotation(bean.getClass(), io.swagger.v3.oas.annotations.security.SecurityScheme.class);
            if (annotation == null) continue;
            SecurityScheme model = new SecurityScheme();
            model.setIn(this.getIn(annotation.in()));
            model.setType(this.getType(annotation.type()));
            model.setBearerFormat(annotation.bearerFormat());
            model.setScheme(annotation.scheme());
            model.setOpenIdConnectUrl(annotation.openIdConnectUrl());
            if (annotation.ref() != null && !annotation.ref().isBlank()) {
                model.set$ref(annotation.ref());
            }
            model.setName(annotation.name());
            securitySchemes.put(annotation.name(), model);
        }
        return securitySchemes;
    }

    protected OpenAPIDefinition getOpenApiDefinition() {
        Map beans = this.applicationContext.getBeansWithAnnotation(OpenAPIDefinition.class);
        if (!beans.isEmpty()) {
            Object bean = beans.values().iterator().next();
            return (OpenAPIDefinition)AnnotatedElementUtils.findMergedAnnotation(bean.getClass(), OpenAPIDefinition.class);
        }
        return null;
    }

    public static void applyDefinition(OpenAPI openApi, OpenAPIDefinition openApiDefinition) {
        AnnotationsUtils.getInfo((Info)openApiDefinition.info()).ifPresent(arg_0 -> ((OpenAPI)openApi).setInfo(arg_0));
        AnnotationsUtils.getExternalDocumentation((ExternalDocumentation)openApiDefinition.externalDocs()).ifPresent(arg_0 -> ((OpenAPI)openApi).setExternalDocs(arg_0));
        AnnotationsUtils.getTags((Tag[])openApiDefinition.tags(), (boolean)false).ifPresent(tags -> tags.forEach(arg_0 -> ((OpenAPI)openApi).addTagsItem(arg_0)));
        SecurityRequirement model = new SecurityRequirement();
        for (io.swagger.v3.oas.annotations.security.SecurityRequirement securityRequirement : openApiDefinition.security()) {
            model.addList(securityRequirement.name());
        }
        openApi.addSecurityItem(model);
    }

    protected SecurityScheme.In getIn(SecuritySchemeIn value) {
        if (value == null) {
            return null;
        }
        return Arrays.stream(SecurityScheme.In.values()).filter(in -> in.toString().equals(value.toString())).findFirst().orElse(null);
    }

    protected SecurityScheme.Type getType(SecuritySchemeType value) {
        if (value == null) {
            return null;
        }
        return Arrays.stream(SecurityScheme.Type.values()).filter(type -> type.toString().equals(value.toString())).findFirst().orElse(null);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

