/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.api;

import com.yahoo.elide.RefreshableElide;
import com.yahoo.elide.jsonapi.JsonApiSettings;
import com.yahoo.elide.spring.api.ElideGroupedOpenApiCustomizer;
import com.yahoo.elide.spring.api.ElideOpenApiCustomizer;
import com.yahoo.elide.spring.api.OpenApis;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.swagger.OpenApiBuilder;
import io.swagger.v3.oas.models.OpenAPI;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class DefaultElideGroupedOpenApiCustomizer
implements ElideGroupedOpenApiCustomizer {
    private final RefreshableElide elide;
    private final ElideConfigProperties settings;
    private final PathMatcher pathMatcher;

    public DefaultElideGroupedOpenApiCustomizer(RefreshableElide elide, ElideConfigProperties settings, PathMatcher pathMatcher) {
        this.elide = elide;
        this.settings = settings;
        this.pathMatcher = pathMatcher;
    }

    public DefaultElideGroupedOpenApiCustomizer(RefreshableElide elide, ElideConfigProperties settings) {
        this(elide, settings, (PathMatcher)new AntPathMatcher());
    }

    @Override
    public void customize(GroupedOpenApi groupedOpenApi) {
        groupedOpenApi.getOpenApiCustomizers().add(0, new ElideOpenApiCustomizer(){

            public void customise(OpenAPI openApi) {
                OpenApis.removePathsByTags(openApi, "graphql-controller", "api-docs-controller", "json-api-controller");
            }
        });
        for (final String apiVersion : this.elide.getElide().getElideSettings().getEntityDictionary().getApiVersions()) {
            JsonApiSettings jsonApiSettings = (JsonApiSettings)this.elide.getElide().getElideSettings().getSettings(JsonApiSettings.class);
            Object path = jsonApiSettings.getPath();
            if (this.settings.getApiVersioningStrategy().getPath().isEnabled()) {
                if (!"".equals(apiVersion)) {
                    if (!((String)path).endsWith("/")) {
                        path = (String)path + "/";
                    }
                    path = (String)path + this.settings.getApiVersioningStrategy().getPath().getVersionPrefix() + apiVersion;
                }
            } else if (!"".equals(apiVersion)) continue;
            if (!this.match(groupedOpenApi, (String)path)) continue;
            final String basePath = path;
            groupedOpenApi.getOpenApiCustomizers().add(0, new ElideOpenApiCustomizer(){

                public void customise(OpenAPI openApi) {
                    OpenApiBuilder builder = new OpenApiBuilder(DefaultElideGroupedOpenApiCustomizer.this.elide.getElide().getElideSettings().getEntityDictionary()).apiVersion(apiVersion).basePath(basePath);
                    builder.applyTo(openApi);
                }
            });
        }
    }

    protected boolean match(GroupedOpenApi groupedOpenApi, String path) {
        boolean matches = false;
        if (groupedOpenApi.getPathsToMatch() != null) {
            for (String pathToMatch : groupedOpenApi.getPathsToMatch()) {
                if (!this.pathMatcher.match(pathToMatch, path)) continue;
                matches = true;
                break;
            }
        }
        if (matches && groupedOpenApi.getPathsToExclude() != null) {
            for (String pathToExclude : groupedOpenApi.getPathsToExclude()) {
                if (!this.pathMatcher.match(pathToExclude, path)) continue;
                matches = false;
                break;
            }
        }
        return matches;
    }
}

