/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.api;

import com.yahoo.elide.RefreshableElide;
import com.yahoo.elide.jsonapi.JsonApiSettings;
import com.yahoo.elide.spring.api.ElideOpenApiCustomizer;
import com.yahoo.elide.spring.api.OpenApis;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.swagger.OpenApiBuilder;
import io.swagger.v3.oas.models.OpenAPI;

public class DefaultElideOpenApiCustomizer
implements ElideOpenApiCustomizer {
    private final RefreshableElide elide;
    private final ElideConfigProperties settings;

    public DefaultElideOpenApiCustomizer(RefreshableElide elide, ElideConfigProperties settings) {
        this.elide = elide;
        this.settings = settings;
    }

    public void customise(OpenAPI openApi) {
        this.removePaths(openApi);
        JsonApiSettings jsonApiSettings = (JsonApiSettings)this.elide.getElide().getElideSettings().getSettings(JsonApiSettings.class);
        for (String apiVersion : this.elide.getElide().getElideSettings().getEntityDictionary().getApiVersions()) {
            OpenApiBuilder builder = new OpenApiBuilder(this.elide.getElide().getElideSettings().getEntityDictionary()).apiVersion(apiVersion).basePath(jsonApiSettings.getPath());
            if (this.settings.getApiVersioningStrategy().getPath().isEnabled()) {
                if (!"".equals(apiVersion)) {
                    Object path = jsonApiSettings.getPath();
                    if (!((String)path).endsWith("/")) {
                        path = (String)path + "/";
                    }
                    path = (String)path + this.settings.getApiVersioningStrategy().getPath().getVersionPrefix() + apiVersion;
                    builder.basePath((String)path);
                }
            } else if (!"".equals(apiVersion)) {
                // empty if block
            }
            builder.applyTo(openApi);
        }
    }

    protected void removePaths(OpenAPI openApi) {
        OpenApis.removePathsByTags(openApi, "graphql-controller", "api-docs-controller", "json-api-controller");
    }
}

