/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.api;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OpenApis {
    private OpenApis() {
    }

    public static void removePathsByTags(OpenAPI openApi, String ... tagsToRemove) {
        HashSet<String> tags = new HashSet<String>();
        Collections.addAll(tags, tagsToRemove);
        OpenApis.removePathsByTags(openApi, tags);
    }

    public static void removePathsByTags(OpenAPI openApi, Set<String> tagsToRemove) {
        HashSet pathsToRemove = new HashSet();
        Paths paths = openApi.getPaths();
        if (paths != null) {
            openApi.getPaths().forEach((path, pathItem) -> {
                HashSet tags = new HashSet();
                if (pathItem.getGet() != null) {
                    tags.addAll(pathItem.getGet().getTags());
                } else if (pathItem.getPost() != null) {
                    tags.addAll(pathItem.getPost().getTags());
                }
                for (String tagToRemove : tagsToRemove) {
                    if (!tags.contains(tagToRemove)) continue;
                    pathsToRemove.add(path);
                    break;
                }
            });
        }
        pathsToRemove.forEach(key -> openApi.getPaths().remove(key));
    }
}

