/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.config;

import com.yahoo.elide.spring.config.ExportControllerProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;

public class AsyncProperties {
    private Cleanup cleanup = new Cleanup();
    private boolean enabled = false;
    private int threadPoolSize = 5;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxAsyncAfter = Duration.ofSeconds(10L);
    @NestedConfigurationProperty
    private ExportControllerProperties export;

    public Cleanup getCleanup() {
        return this.cleanup;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public Duration getMaxAsyncAfter() {
        return this.maxAsyncAfter;
    }

    public ExportControllerProperties getExport() {
        return this.export;
    }

    public void setCleanup(Cleanup cleanup) {
        this.cleanup = cleanup;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setMaxAsyncAfter(Duration maxAsyncAfter) {
        this.maxAsyncAfter = maxAsyncAfter;
    }

    public void setExport(ExportControllerProperties export) {
        this.export = export;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncProperties)) {
            return false;
        }
        AsyncProperties other = (AsyncProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getThreadPoolSize() != other.getThreadPoolSize()) {
            return false;
        }
        Cleanup this$cleanup = this.getCleanup();
        Cleanup other$cleanup = other.getCleanup();
        if (this$cleanup == null ? other$cleanup != null : !((Object)this$cleanup).equals(other$cleanup)) {
            return false;
        }
        Duration this$maxAsyncAfter = this.getMaxAsyncAfter();
        Duration other$maxAsyncAfter = other.getMaxAsyncAfter();
        if (this$maxAsyncAfter == null ? other$maxAsyncAfter != null : !((Object)this$maxAsyncAfter).equals(other$maxAsyncAfter)) {
            return false;
        }
        ExportControllerProperties this$export = this.getExport();
        ExportControllerProperties other$export = other.getExport();
        return !(this$export == null ? other$export != null : !((Object)this$export).equals(other$export));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getThreadPoolSize();
        Cleanup $cleanup = this.getCleanup();
        result = result * 59 + ($cleanup == null ? 43 : ((Object)$cleanup).hashCode());
        Duration $maxAsyncAfter = this.getMaxAsyncAfter();
        result = result * 59 + ($maxAsyncAfter == null ? 43 : ((Object)$maxAsyncAfter).hashCode());
        ExportControllerProperties $export = this.getExport();
        result = result * 59 + ($export == null ? 43 : ((Object)$export).hashCode());
        return result;
    }

    public String toString() {
        return "AsyncProperties(cleanup=" + this.getCleanup() + ", enabled=" + this.isEnabled() + ", threadPoolSize=" + this.getThreadPoolSize() + ", maxAsyncAfter=" + this.getMaxAsyncAfter() + ", export=" + this.getExport() + ")";
    }

    public static class Cleanup {
        private boolean enabled = false;
        @DurationUnit(value=ChronoUnit.DAYS)
        private Duration queryRetentionDuration = Duration.ofDays(7L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration queryCancellationCheckInterval = Duration.ofSeconds(300L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration queryMaxRunTime = Duration.ofSeconds(3600L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public Duration getQueryRetentionDuration() {
            return this.queryRetentionDuration;
        }

        public Duration getQueryCancellationCheckInterval() {
            return this.queryCancellationCheckInterval;
        }

        public Duration getQueryMaxRunTime() {
            return this.queryMaxRunTime;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setQueryRetentionDuration(Duration queryRetentionDuration) {
            this.queryRetentionDuration = queryRetentionDuration;
        }

        public void setQueryCancellationCheckInterval(Duration queryCancellationCheckInterval) {
            this.queryCancellationCheckInterval = queryCancellationCheckInterval;
        }

        public void setQueryMaxRunTime(Duration queryMaxRunTime) {
            this.queryMaxRunTime = queryMaxRunTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cleanup)) {
                return false;
            }
            Cleanup other = (Cleanup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Duration this$queryRetentionDuration = this.getQueryRetentionDuration();
            Duration other$queryRetentionDuration = other.getQueryRetentionDuration();
            if (this$queryRetentionDuration == null ? other$queryRetentionDuration != null : !((Object)this$queryRetentionDuration).equals(other$queryRetentionDuration)) {
                return false;
            }
            Duration this$queryCancellationCheckInterval = this.getQueryCancellationCheckInterval();
            Duration other$queryCancellationCheckInterval = other.getQueryCancellationCheckInterval();
            if (this$queryCancellationCheckInterval == null ? other$queryCancellationCheckInterval != null : !((Object)this$queryCancellationCheckInterval).equals(other$queryCancellationCheckInterval)) {
                return false;
            }
            Duration this$queryMaxRunTime = this.getQueryMaxRunTime();
            Duration other$queryMaxRunTime = other.getQueryMaxRunTime();
            return !(this$queryMaxRunTime == null ? other$queryMaxRunTime != null : !((Object)this$queryMaxRunTime).equals(other$queryMaxRunTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cleanup;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Duration $queryRetentionDuration = this.getQueryRetentionDuration();
            result = result * 59 + ($queryRetentionDuration == null ? 43 : ((Object)$queryRetentionDuration).hashCode());
            Duration $queryCancellationCheckInterval = this.getQueryCancellationCheckInterval();
            result = result * 59 + ($queryCancellationCheckInterval == null ? 43 : ((Object)$queryCancellationCheckInterval).hashCode());
            Duration $queryMaxRunTime = this.getQueryMaxRunTime();
            result = result * 59 + ($queryMaxRunTime == null ? 43 : ((Object)$queryMaxRunTime).hashCode());
            return result;
        }

        public String toString() {
            return "AsyncProperties.Cleanup(enabled=" + this.isEnabled() + ", queryRetentionDuration=" + this.getQueryRetentionDuration() + ", queryCancellationCheckInterval=" + this.getQueryCancellationCheckInterval() + ", queryMaxRunTime=" + this.getQueryMaxRunTime() + ")";
        }
    }
}

